/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.snmp4j.CertifiedTarget;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.CoexistenceInfoProvider;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.RowStatusEvent;
import org.snmp4j.agent.mo.snmp.RowStatusListener;
import org.snmp4j.agent.mo.snmp.SnmpAdminString;
import org.snmp4j.agent.mo.snmp.SnmpTagList;
import org.snmp4j.agent.mo.snmp.SnmpTlsTmMib;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactory;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactoryImpl;
import org.snmp4j.agent.mo.snmp.TestAndIncr;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.tls.DefaultTlsTmSecurityCallback;
import org.snmp4j.transport.tls.SecurityNameMapping;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.TlsX509CertifiedTarget;

public class SnmpTargetMIB
implements MOGroup,
CounterListener,
MOTableRowListener<DefaultMOMutableRow2PC> {
    public static final long ADDRESS_CACHE_TIMEOUT = 3600000000000L;
    private static final LogAdapter logger = LogFactory.getLogger(SnmpTargetMIB.class);
    private static final OID oidSnmpTargetSpinLock = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 1, 0});
    private MOScalar<Integer32> snmpTargetSpinLock;
    private static final OID oidSnmpUnknownContexts = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 5, 0});
    private MOScalar<Counter32> snmpUnknownContexts;
    private static final OID oidSnmpUnavailableContexts = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 4, 0});
    private MOScalar<Counter32> snmpUnavailableContexts;
    private static final OID oidSnmpTargetParamsEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 3, 1});
    private static final int colSnmpTargetParamsMPModel = 2;
    private static final int colSnmpTargetParamsSecurityModel = 3;
    private static final int colSnmpTargetParamsSecurityName = 4;
    private static final int colSnmpTargetParamsSecurityLevel = 5;
    private static final int colSnmpTargetParamsStorageType = 6;
    private static final int colSnmpTargetParamsRowStatus = 7;
    static final int idxSnmpTargetParamsMPModel = 0;
    static final int idxSnmpTargetParamsSecurityModel = 1;
    static final int idxSnmpTargetParamsSecurityName = 2;
    static final int idxSnmpTargetParamsSecurityLevel = 3;
    static final int idxSnmpTargetParamsStorageType = 4;
    static final int idxSnmpTargetParamsRowStatus = 5;
    private static MOTableSubIndex[] snmpTargetParamsEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32)};
    private static MOTableIndex snmpTargetParamsEntryIndex = new MOTableIndex(snmpTargetParamsEntryIndexes, true);
    private DefaultMOTable<DefaultMOMutableRow2PC, MOColumn, DefaultMOMutableTableModel<DefaultMOMutableRow2PC>> snmpTargetParamsEntry;
    private DefaultMOMutableTableModel<DefaultMOMutableRow2PC> snmpTargetParamsEntryModel;
    private static final OID oidSnmpTargetAddrEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 2, 1});
    private static final int colSnmpTargetAddrTDomain = 2;
    private static final int colSnmpTargetAddrTAddress = 3;
    private static final int colSnmpTargetAddrTimeout = 4;
    private static final int colSnmpTargetAddrRetryCount = 5;
    private static final int colSnmpTargetAddrTagList = 6;
    private static final int colSnmpTargetAddrParams = 7;
    private static final int colSnmpTargetAddrStorageType = 8;
    private static final int colSnmpTargetAddrRowStatus = 9;
    static final int idxSnmpTargetAddrTDomain = 0;
    static final int idxSnmpTargetAddrTAddress = 1;
    static final int idxSnmpTargetAddrTimeout = 2;
    static final int idxSnmpTargetAddrRetryCount = 3;
    static final int idxSnmpTargetAddrTagList = 4;
    static final int idxSnmpTargetAddrParams = 5;
    static final int idxSnmpTargetAddrStorageType = 6;
    static final int idxSnmpTargetAddrRowStatus = 7;
    private static MOTableSubIndex[] snmpTargetAddrEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32)};
    private static MOTableIndex snmpTargetAddrEntryIndex = new MOTableIndex(snmpTargetAddrEntryIndexes, true);
    private static final OID[] DEFAULT_TDOMAINS = new OID[]{TransportDomains.snmpUDPDomain, TransportDomains.transportDomainTcpIpv4, TransportDomains.transportDomainTcpIpv6, TransportDomains.transportDomainUdpIpv4, TransportDomains.transportDomainUdpIpv6, TransportDomains.transportDomainUdpDns, TransportDomains.transportDomainTcpDns};
    private DefaultMOTable<SnmpTargetAddrEntryRow, MOColumn, DefaultMOMutableTableModel<SnmpTargetAddrEntryRow>> snmpTargetAddrEntry;
    private DefaultMOMutableTableModel<SnmpTargetAddrEntryRow> snmpTargetAddrEntryModel;
    private Map<OctetString, Set<SnmpTargetAddrEntryRow>> snmpTargetAddrTagIndex = new Hashtable<OctetString, Set<SnmpTargetAddrEntryRow>>();
    private Hashtable<OID, TDomainAddressFactory> supportedAddressClasses = new Hashtable();
    private MessageDispatcher messageDispatcher;
    private CoexistenceInfoProvider coexistenceProvider;
    private SnmpTlsTmMib tlsTmMib;
    private long addressCacheTimeoutNanos = 3600000000000L;

    public SnmpTargetMIB(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.snmpTargetSpinLock = new TestAndIncr(oidSnmpTargetSpinLock);
        this.snmpUnknownContexts = new MOScalar<Counter32>(oidSnmpUnknownContexts, MOAccessImpl.ACCESS_READ_ONLY, new Counter32());
        this.snmpUnavailableContexts = new MOScalar<Counter32>(oidSnmpUnavailableContexts, MOAccessImpl.ACCESS_READ_ONLY, new Counter32());
        this.createSnmpTargetParamsEntry();
        this.createSnmpTargetAddrEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SnmpTargetAddrEntryRow> getTargetAddrRowsForTag(OctetString tag) {
        ArrayList<SnmpTargetAddrEntryRow> l = (ArrayList<SnmpTargetAddrEntryRow>)((Object)this.snmpTargetAddrTagIndex.get(tag));
        if (l == null) {
            return Collections.emptySet();
        }
        ArrayList<SnmpTargetAddrEntryRow> arrayList = l;
        synchronized (arrayList) {
            l = new ArrayList<SnmpTargetAddrEntryRow>(l);
        }
        return l;
    }

    public long getAddressCacheTimeoutNanos() {
        return this.addressCacheTimeoutNanos;
    }

    public void setAddressCacheTimeoutNanos(long addressCacheTimeoutNanos) {
        this.addressCacheTimeoutNanos = addressCacheTimeoutNanos;
    }

    public SnmpTlsTmMib getTlsTmMib() {
        return this.tlsTmMib;
    }

    public void setTlsTmMib(SnmpTlsTmMib tlsTmMib) {
        this.tlsTmMib = tlsTmMib;
    }

    public byte[] getLocalEngineID() {
        MPv3 mpv3 = (MPv3)this.messageDispatcher.getMessageProcessingModel(3);
        if (mpv3 == null) {
            return null;
        }
        return mpv3.getLocalEngineID();
    }

    public Address getTargetAddress(OctetString name) {
        OID index = name.toSubIndex(true);
        SnmpTargetAddrEntryRow trow = (SnmpTargetAddrEntryRow)this.snmpTargetAddrEntryModel.getRow(index);
        if (trow != null) {
            return trow.getAddress();
        }
        return null;
    }

    public Target<?> getTarget(OctetString name, OctetString contextEngineID, OctetString contextName) {
        OID index = name.toSubIndex(true);
        SnmpTargetAddrEntryRow trow = (SnmpTargetAddrEntryRow)this.snmpTargetAddrEntryModel.getRow(index);
        if (trow != null && RowStatus.isRowActive(trow, 7)) {
            return trow.getTarget(contextEngineID, contextName, null);
        }
        return null;
    }

    public <A extends Address> Target<A> getTarget(OctetString name, OctetString contextEngineID, OctetString contextName, A addressType) {
        OID index = name.toSubIndex(true);
        SnmpTargetAddrEntryRow trow = (SnmpTargetAddrEntryRow)this.snmpTargetAddrEntryModel.getRow(index);
        if (trow != null && RowStatus.isRowActive(trow, 7)) {
            return trow.getTarget(contextEngineID, contextName, addressType);
        }
        return null;
    }

    public void addDefaultTDomains() {
        TDomainAddressFactoryImpl factory = new TDomainAddressFactoryImpl();
        for (OID tDomain : DEFAULT_TDOMAINS) {
            this.supportedAddressClasses.put(tDomain, factory);
        }
    }

    public void addSupportedTDomain(OID transportDomain, TDomainAddressFactory factory) {
        this.supportedAddressClasses.put(transportDomain, factory);
    }

    public TDomainAddressFactory removeSupportedTDomain(OID transportDomain) {
        return this.supportedAddressClasses.remove(transportDomain);
    }

    public boolean addTargetAddress(OctetString name, OID transportDomain, OctetString address, int timeout, int retries, OctetString tagList, OctetString params, int storageType) {
        Variable[] vbs = new Variable[this.snmpTargetAddrEntry.getColumnCount()];
        int n = 0;
        vbs[n++] = transportDomain;
        vbs[n++] = address;
        vbs[n++] = new Integer32(timeout);
        vbs[n++] = new Integer32(retries);
        vbs[n++] = tagList;
        vbs[n++] = params;
        vbs[n++] = new Integer32(storageType);
        vbs[n] = new Integer32(1);
        OID index = name.toSubIndex(true);
        SnmpTargetAddrEntryRow row = this.snmpTargetAddrEntry.createRow(index, vbs);
        this.snmpTargetAddrEntry.addRow(row);
        return true;
    }

    public MOTableRow removeTargetAddress(OctetString name) {
        OID index = name.toSubIndex(true);
        SnmpTargetAddrEntryRow removedRow = this.snmpTargetAddrEntry.removeRow(index);
        if (removedRow != null) {
            this.removeRowFromTargetAddrTagIndex(removedRow);
        }
        return removedRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRowFromTargetAddrTagIndex(MOTableRow removedRow) {
        OctetString tagList = (OctetString)removedRow.getValue(4);
        Set<OctetString> tags = SnmpTagList.getTags(tagList);
        if (this.snmpTargetAddrTagIndex != null) {
            for (OctetString item : tags) {
                Collection indexRows = this.snmpTargetAddrTagIndex.get(item);
                if (indexRows == null) continue;
                Collection collection = indexRows;
                synchronized (collection) {
                    indexRows.remove(removedRow);
                    if (indexRows.isEmpty()) {
                        this.snmpTargetAddrTagIndex.remove(item);
                    }
                }
            }
        }
    }

    public boolean addTargetParams(OctetString name, int mpModel, int secModel, OctetString secName, int secLevel, int storageType) {
        Variable[] vbs = new Variable[this.snmpTargetParamsEntry.getColumnCount()];
        int n = 0;
        vbs[n++] = new Integer32(mpModel);
        vbs[n++] = new Integer32(secModel);
        vbs[n++] = secName;
        vbs[n++] = new Integer32(secLevel);
        vbs[n++] = new Integer32(storageType);
        vbs[n] = new Integer32(1);
        OID index = name.toSubIndex(true);
        DefaultMOMutableRow2PC row = this.snmpTargetParamsEntry.createRow(index, vbs);
        this.snmpTargetParamsEntry.addRow(row);
        return true;
    }

    public MOTableRow removeTargetParams(OctetString name) {
        OID index = name.toSubIndex(true);
        return this.snmpTargetParamsEntry.removeRow(index);
    }

    private void createSnmpTargetParamsEntry() {
        MOColumn[] snmpTargetParamsEntryColumns = new MOColumn[6];
        snmpTargetParamsEntryColumns[0] = new MOMutableColumn<Object>(2, 2, MOAccessImpl.ACCESS_READ_CREATE, null, false);
        ((MOMutableColumn)snmpTargetParamsEntryColumns[0]).addMOValueValidationListener(new SnmpTargetParamsMPModelValidator());
        snmpTargetParamsEntryColumns[1] = new MOMutableColumn<Object>(3, 2, MOAccessImpl.ACCESS_READ_CREATE, null, false);
        ((MOMutableColumn)snmpTargetParamsEntryColumns[1]).addMOValueValidationListener(new SnmpTargetParamsSecurityModelValidator());
        snmpTargetParamsEntryColumns[2] = new SnmpAdminString(4, MOAccessImpl.ACCESS_READ_CREATE, null, false);
        snmpTargetParamsEntryColumns[3] = new Enumerated<Object>(5, 2, MOAccessImpl.ACCESS_READ_CREATE, null, false, new int[]{1, 3, 2});
        snmpTargetParamsEntryColumns[4] = new StorageType(6, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        snmpTargetParamsEntryColumns[5] = new RowStatus(7, MOAccessImpl.ACCESS_READ_CREATE);
        ((RowStatus)snmpTargetParamsEntryColumns[5]).addRowStatusListener(new SnmpTargetParamsEntryRowStatusListener());
        this.snmpTargetParamsEntry = new DefaultMOTable(oidSnmpTargetParamsEntry, snmpTargetParamsEntryIndex, snmpTargetParamsEntryColumns);
        this.snmpTargetParamsEntryModel = new DefaultMOMutableTableModel();
        this.snmpTargetParamsEntryModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.snmpTargetParamsEntry.setModel(this.snmpTargetParamsEntryModel);
    }

    private void createSnmpTargetAddrEntry() {
        MOColumn[] snmpTargetAddrEntryColumns = new MOColumn[8];
        snmpTargetAddrEntryColumns[0] = new MOMutableColumn<Object>(2, 6, MOAccessImpl.ACCESS_READ_CREATE, null, false);
        ((MOMutableColumn)snmpTargetAddrEntryColumns[0]).addMOValueValidationListener(new SnmpTargetAddrTDomainValidator());
        snmpTargetAddrEntryColumns[1] = new MOMutableColumn<Object>(3, 4, MOAccessImpl.ACCESS_READ_CREATE, null, false);
        ((MOMutableColumn)snmpTargetAddrEntryColumns[1]).addMOValueValidationListener(new SnmpTargetAddrTAddressValidator());
        snmpTargetAddrEntryColumns[2] = new MOMutableColumn<Integer32>(4, 2, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1500), true);
        ((MOMutableColumn)snmpTargetAddrEntryColumns[2]).addMOValueValidationListener(new SnmpTargetAddrTimeoutValidator());
        snmpTargetAddrEntryColumns[3] = new MOMutableColumn<Integer32>(5, 2, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        ((MOMutableColumn)snmpTargetAddrEntryColumns[3]).addMOValueValidationListener(new SnmpTargetAddrRetryCountValidator());
        snmpTargetAddrEntryColumns[4] = new SnmpTagList(6, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(new byte[0]), true);
        snmpTargetAddrEntryColumns[5] = new MOMutableColumn<OctetString>(7, 4, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(), true);
        ((MOMutableColumn)snmpTargetAddrEntryColumns[5]).addMOValueValidationListener(new SnmpTargetAddrParamsValidator());
        snmpTargetAddrEntryColumns[6] = new StorageType(8, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        snmpTargetAddrEntryColumns[7] = new RowStatus(9);
        this.snmpTargetAddrEntry = new DefaultMOTable(oidSnmpTargetAddrEntry, snmpTargetAddrEntryIndex, snmpTargetAddrEntryColumns);
        this.snmpTargetAddrEntryModel = new DefaultMOMutableTableModel();
        this.snmpTargetAddrEntryModel.setRowFactory(new SnmpTargetAddrEntryFactory());
        this.snmpTargetAddrEntry.setModel(this.snmpTargetAddrEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmpTargetSpinLock, context);
        server.register(this.snmpUnknownContexts, context);
        server.register(this.snmpUnavailableContexts, context);
        server.register(this.snmpTargetParamsEntry, context);
        server.register(this.snmpTargetAddrEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpTargetSpinLock, context);
        server.unregister(this.snmpUnknownContexts, context);
        server.unregister(this.snmpUnavailableContexts, context);
        server.unregister(this.snmpTargetParamsEntry, context);
        server.unregister(this.snmpTargetAddrEntry, context);
    }

    public void incrementCounter(CounterEvent event) {
        if (event.getOid().equals((Object)this.snmpUnavailableContexts.getOid())) {
            this.snmpUnavailableContexts.getValue().increment();
            event.setCurrentValue((Variable)this.snmpUnavailableContexts.getValue());
        } else if (event.getOid().equals((Object)this.snmpUnknownContexts.getOid())) {
            this.snmpUnknownContexts.getValue().increment();
            event.setCurrentValue((Variable)this.snmpUnknownContexts.getValue());
        }
    }

    @Override
    public void rowChanged(MOTableRowEvent<DefaultMOMutableRow2PC> event) {
        if (event.getType() == 3 && event.getRow() instanceof SnmpTargetAddrEntryRow) {
            Variable[] vbs = new Variable[event.getRow().size()];
            vbs[4] = new OctetString();
            DefaultMOTableRow dummyRow = new DefaultMOTableRow(event.getRow().getIndex(), vbs);
            ((SnmpTargetAddrEntryRow)event.getRow()).updateUserObject(dummyRow);
        }
    }

    public MOTableRow getTargetParamsRow(OctetString paramsName) {
        if (paramsName == null) {
            return null;
        }
        OID paramsIndex = paramsName.toSubIndex(true);
        return this.snmpTargetParamsEntryModel.getRow(paramsIndex);
    }

    public MOTableRow getTargetParamsRow(OctetString paramsName, boolean activeOnly) {
        MOTableRow row = this.getTargetParamsRow(paramsName);
        if (activeOnly && row != null && ((Integer32)row.getValue(5)).getValue() != 1) {
            return null;
        }
        return row;
    }

    public DefaultMOTable<SnmpTargetAddrEntryRow, ? extends MOColumn, ? extends MOTableModel<SnmpTargetAddrEntryRow>> getSnmpTargetAddrEntry() {
        return this.snmpTargetAddrEntry;
    }

    public DefaultMOTable<DefaultMOMutableRow2PC, MOColumn, DefaultMOMutableTableModel<DefaultMOMutableRow2PC>> getSnmpTargetParamsEntry() {
        return this.snmpTargetParamsEntry;
    }

    public CoexistenceInfoProvider getCoexistenceProvider() {
        return this.coexistenceProvider;
    }

    public void setCoexistenceProvider(CoexistenceInfoProvider coexistenceProvider) {
        this.coexistenceProvider = coexistenceProvider;
    }

    public class SnmpTargetAddrEntryRow
    extends DefaultMOMutableRow2PC {
        private volatile transient Address cachedAddress;
        private transient long lastAddressUdpate;

        public SnmpTargetAddrEntryRow(OID index, Variable[] values) {
            super(index, values);
            this.updateUserObject(this);
        }

        private void updateUserObject(MOTableRow changeSet) {
            Variable tagList = changeSet.getValue(4);
            if (tagList != null) {
                Set obsolete = (Set)this.getUserObject();
                Set<OctetString> tags = SnmpTagList.getTags((OctetString)tagList);
                if (obsolete != null) {
                    obsolete.removeAll(tags);
                }
                this.setUserObject(tags);
                this.updateIndex(obsolete, tags);
            }
        }

        @Override
        public void commitRow(SubRequest<?> subRequest, MOTableRow changeSet) {
            super.commitRow(subRequest, changeSet);
            this.updateUserObject(changeSet);
        }

        @Override
        public void setValue(int column, Variable value) {
            this.cachedAddress = null;
            super.setValue(column, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateIndex(Set<OctetString> remove, Set<OctetString> tags) {
            HashSet<SnmpTargetAddrEntryRow> hashSet;
            Set<SnmpTargetAddrEntryRow> list;
            if (remove != null) {
                for (OctetString next : remove) {
                    list = (HashSet<SnmpTargetAddrEntryRow>)SnmpTargetMIB.this.snmpTargetAddrTagIndex.get(next);
                    if (list != null) {
                        hashSet = list;
                        synchronized (hashSet) {
                            if (!list.remove(this)) {
                                logger.error((Serializable)((Object)("Inconsistent tag value '" + next + "' for rows: " + list)));
                            }
                            continue;
                        }
                    }
                    logger.error((Serializable)((Object)("Tag value '" + next + "' not found in tag index")));
                }
            }
            for (OctetString next : tags) {
                list = (Set)SnmpTargetMIB.this.snmpTargetAddrTagIndex.get(next);
                if (list == null) {
                    list = new HashSet<SnmpTargetAddrEntryRow>();
                }
                hashSet = list;
                synchronized (hashSet) {
                    if (!list.add(this)) {
                        list.remove(this);
                        list.add(this);
                    }
                }
                SnmpTargetMIB.this.snmpTargetAddrTagIndex.put(next, list);
            }
        }

        @Override
        public void prepareRow(SubRequest<?> subRequest, MOTableRow changeSet) {
            OID tdomain = (OID)this.getResultingValue(0, changeSet);
            OctetString taddress = (OctetString)this.getResultingValue(1, changeSet);
            if (tdomain != null) {
                TDomainAddressFactory factory = (TDomainAddressFactory)SnmpTargetMIB.this.supportedAddressClasses.get(tdomain);
                if (factory == null || !factory.isValidAddress(tdomain, taddress)) {
                    subRequest.getStatus().setErrorStatus(12);
                }
            } else if (taddress != null) {
                subRequest.getStatus().setErrorStatus(12);
            }
        }

        public Address getAddress() {
            if (this.cachedAddress != null && System.nanoTime() - this.lastAddressUdpate < SnmpTargetMIB.this.addressCacheTimeoutNanos) {
                return this.cachedAddress;
            }
            OID tdomain = (OID)this.getValue(0);
            TDomainAddressFactory factory = (TDomainAddressFactory)SnmpTargetMIB.this.supportedAddressClasses.get(tdomain);
            if (factory != null) {
                Address address;
                OctetString addr = (OctetString)this.getValue(1);
                this.cachedAddress = address = factory.createAddress(tdomain, addr);
                this.lastAddressUdpate = System.nanoTime();
                return address;
            }
            return null;
        }

        public OctetString getTAddress(Address address) {
            OID[] domains;
            OID tdomain = (OID)this.getValue(0);
            TDomainAddressFactory factory = (TDomainAddressFactory)SnmpTargetMIB.this.supportedAddressClasses.get(tdomain);
            for (OID domain : domains = factory.getTransportDomain(address)) {
                if (!domain.equals((Object)tdomain)) continue;
                return factory.getAddress(address);
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public <A extends Address> Target<A> getTarget(OctetString contextEngineID, OctetString contextName, A addressType) {
            Address addr = this.getAddress();
            if (addressType != null && !addressType.getClass().isInstance(addr)) {
                return null;
            }
            OctetString addrParams = (OctetString)this.getValue(5);
            OID paramsIndex = addrParams.toSubIndex(true);
            Object paramsRow = SnmpTargetMIB.this.snmpTargetParamsEntryModel.getRow(paramsIndex);
            if (paramsRow == null || !RowStatus.isRowActive(paramsRow, 5)) {
                return null;
            }
            UserTarget t = null;
            OctetString secName = (OctetString)paramsRow.getValue(2);
            if (paramsRow.getValue(0).toInt() == 3) {
                SnmpTlsTmMib myTlsTmMib = SnmpTargetMIB.this.tlsTmMib;
                if (myTlsTmMib != null) {
                    t = this.getTlsTmTarget(addr, secName, this.getIndex(), paramsIndex, myTlsTmMib);
                    t.setSecurityLevel(paramsRow.getValue(3).toInt());
                }
                if (t == null) {
                    if (contextEngineID == null) return null;
                    t = new UserTarget(addr, secName, contextEngineID.getValue(), paramsRow.getValue(3).toInt());
                }
            } else {
                OctetString community = secName;
                if (SnmpTargetMIB.this.coexistenceProvider != null && (community = SnmpTargetMIB.this.coexistenceProvider.getCommunity(community, contextEngineID, contextName)) == null) {
                    return null;
                }
                t = new CommunityTarget(addr, community);
            }
            t.setRetries(this.getValue(3).toInt());
            t.setTimeout((long)(this.getValue(2).toInt() * 10));
            t.setVersion(paramsRow.getValue(0).toInt());
            return t;
        }

        public <A extends Address> CertifiedTarget<A> getTlsTmTarget(A addr, OctetString secName, OID addrIndex, OID paramsIndex, SnmpTlsTmMib myTlsTmMib) {
            SnmpTlsTmMib.SnmpTlstmParamsEntryRow tlstmParamsEntryRow;
            TlsX509CertifiedTarget t = null;
            SnmpTlsTmMib.SnmpTlstmAddrEntryRow tlstmAddrEntryRow = myTlsTmMib.getSnmpTlstmAddrEntry().getModel().getRow(addrIndex);
            OctetString serverFingerPrint = null;
            if (tlstmAddrEntryRow != null && RowStatus.isRowActive(tlstmAddrEntryRow, 3)) {
                serverFingerPrint = tlstmAddrEntryRow.getSnmpTlstmAddrServerFingerprint();
            }
            if ((tlstmParamsEntryRow = myTlsTmMib.getSnmpTlstmParamsEntry().getModel().getRow(paramsIndex)) != null && RowStatus.isRowActive(tlstmParamsEntryRow, 2)) {
                DefaultTlsTmSecurityCallback tlsTmSecurityCallback = null;
                if (tlstmAddrEntryRow != null) {
                    tlsTmSecurityCallback = new DefaultTlsTmSecurityCallback();
                    tlsTmSecurityCallback.addSecurityNameMapping(serverFingerPrint, SecurityNameMapping.CertMappingType.SANDNSName, tlstmAddrEntryRow.getSnmpTlstmAddrServerIdentity(), secName);
                }
                t = new TlsX509CertifiedTarget(addr, secName, serverFingerPrint, tlstmParamsEntryRow.getSnmpTlstmParamsClientFingerprint(), (TlsTmSecurityCallback)tlsTmSecurityCallback);
            }
            return t;
        }
    }

    class SnmpTargetParamsMPModelValidator
    implements MOValueValidationListener {
        SnmpTargetParamsMPModelValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            int v = ((Integer32)newValue).getValue();
            if (SnmpTargetMIB.this.messageDispatcher.getMessageProcessingModel(v) == null) {
                validationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    class SnmpTargetParamsSecurityModelValidator
    implements MOValueValidationListener {
        SnmpTargetParamsSecurityModelValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            switch (((Integer32)newValue).getValue()) {
                case 3: {
                    if (((MPv3)SnmpTargetMIB.this.messageDispatcher.getMessageProcessingModel(3)).getSecurityModel(((Integer32)newValue).getValue()) != null) break;
                    validationEvent.setValidationStatus(10);
                    return;
                }
            }
        }
    }

    public static final class SnmpTargetParamsSecurityLevelEnum {
        public static final int noAuthNoPriv = 1;
        public static final int authNoPriv = 2;
        public static final int authPriv = 3;
    }

    class SnmpTargetParamsEntryRowStatusListener
    implements RowStatusListener {
        SnmpTargetParamsEntryRowStatusListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rowStatusChanged(RowStatusEvent event) {
            if (event.getNewStatus() == 6) {
                OID index = event.getRow().getIndex();
                OctetString paramsIndex = (OctetString)snmpTargetParamsEntryIndex.getIndexValues(index)[0];
                DefaultMOMutableTableModel defaultMOMutableTableModel = SnmpTargetMIB.this.snmpTargetAddrEntryModel;
                synchronized (defaultMOMutableTableModel) {
                    Iterator it = SnmpTargetMIB.this.snmpTargetAddrEntryModel.iterator();
                    while (it.hasNext()) {
                        MOTableRow r = (MOTableRow)it.next();
                        Integer32 rowStatus = (Integer32)r.getValue(7);
                        if (rowStatus == null || rowStatus.getValue() != 1 || !paramsIndex.equals((Object)r.getValue(5))) continue;
                        event.setDenyReason(12);
                        return;
                    }
                }
            }
        }
    }

    class SnmpTargetAddrTDomainValidator
    implements MOValueValidationListener {
        SnmpTargetAddrTDomainValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            if (newValue instanceof OID) {
                OID tdomain = (OID)newValue;
                if (!SnmpTargetMIB.this.supportedAddressClasses.containsKey(tdomain)) {
                    validationEvent.setValidationStatus(3);
                }
            } else {
                validationEvent.setValidationStatus(7);
            }
        }
    }

    static class SnmpTargetAddrTAddressValidator
    implements MOValueValidationListener {
        SnmpTargetAddrTAddressValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 1 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpTargetAddrTimeoutValidator
    implements MOValueValidationListener {
        SnmpTargetAddrTimeoutValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            long v = ((Integer32)newValue).getValue();
            if (v < 0L) {
                validationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    static class SnmpTargetAddrRetryCountValidator
    implements MOValueValidationListener {
        SnmpTargetAddrRetryCountValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            long v = ((Integer32)newValue).getValue();
            if (v < 0L || v > 255L) {
                validationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    class SnmpTargetAddrParamsValidator
    implements MOValueValidationListener {
        SnmpTargetAddrParamsValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 1 || os.length() > 32) {
                validationEvent.setValidationStatus(8);
                return;
            }
            OID paramsIndexOID = os.toSubIndex(true);
            Object paramsRow = SnmpTargetMIB.this.snmpTargetParamsEntryModel.getRow(paramsIndexOID);
            if (paramsRow == null) {
                validationEvent.setValidationStatus(12);
            }
        }
    }

    class SnmpTargetAddrEntryFactory
    implements MOTableRowFactory<SnmpTargetAddrEntryRow> {
        SnmpTargetAddrEntryFactory() {
        }

        @Override
        public SnmpTargetAddrEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            return new SnmpTargetAddrEntryRow(index, values);
        }

        @Override
        public void freeRow(SnmpTargetAddrEntryRow row) {
        }
    }
}

