/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRelation;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.DateAndTime;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.NotificationLogEvent;
import org.snmp4j.agent.mo.snmp.NotificationLogListener;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.RowStatusEvent;
import org.snmp4j.agent.mo.snmp.RowStatusListener;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactory;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactoryImpl;
import org.snmp4j.agent.mo.snmp.smi.Constraint;
import org.snmp4j.agent.mo.snmp.smi.ConstraintsImpl;
import org.snmp4j.agent.mo.snmp.smi.EnumerationConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class NotificationLogMib
implements MOGroup,
NotificationLogListener,
RowStatusListener {
    private static final LogAdapter LOGGER = LogFactory.getLogger(NotificationLogMib.class);
    private MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidNotificationLogMib = new OID(new int[]{1, 3, 6, 1, 2, 1, 92});
    public static final OID oidNlmConfigGlobalEntryLimit = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 1, 1, 0});
    public static final OID oidNlmConfigGlobalAgeOut = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 1, 2, 0});
    public static final OID oidNlmStatsGlobalNotificationsLogged = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 2, 1, 0});
    public static final OID oidNlmStatsGlobalNotificationsBumped = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 2, 2, 0});
    private static final String TC_MODULE_SNMPV2_TC = "SNMPv2-TC";
    private static final String TC_MODULE_SNMP_FRAMEWORK_MIB = "SNMP-FRAMEWORK-MIB";
    private static final String TC_DATEANDTIME = "DateAndTime";
    private static final String TC_SNMPADMINSTRING = "SnmpAdminString";
    private static final String TC_TADDRESS = "TAddress";
    private static final String TC_ROWSTATUS = "RowStatus";
    private static final String TC_TDOMAIN = "TDomain";
    private static final String TC_TIMESTAMP = "TimeStamp";
    private static final String TC_STORAGETYPE = "StorageType";
    private static final String TC_SNMPENGINEID = "SnmpEngineID";
    private MOScalar<UnsignedInteger32> nlmConfigGlobalEntryLimit;
    private MOScalar<UnsignedInteger32> nlmConfigGlobalAgeOut;
    private MOScalar<Counter32> nlmStatsGlobalNotificationsLogged;
    private MOScalar<Counter32> nlmStatsGlobalNotificationsBumped;
    public static final OID oidNlmConfigLogEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 1, 3, 1});
    public static final OID oidNlmLogName = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 1, 3, 1, 1});
    public static final String tcModuleSnmpFrameworkMib = "SNMP-FRAMEWORK-MIB";
    public static final String tcDefSnmpAdminString = "SnmpAdminString";
    public static final String tcModuleSNMPv2Tc = "SNMPv2-TC";
    public static final String tcDefStorageType = "StorageType";
    public static final String tcDefRowStatus = "RowStatus";
    public static final int colNlmConfigLogFilterName = 2;
    public static final int colNlmConfigLogEntryLimit = 3;
    public static final int colNlmConfigLogAdminStatus = 4;
    public static final int colNlmConfigLogOperStatus = 5;
    public static final int colNlmConfigLogStorageType = 6;
    public static final int colNlmConfigLogEntryStatus = 7;
    public static final int idxNlmConfigLogFilterName = 0;
    public static final int idxNlmConfigLogEntryLimit = 1;
    public static final int idxNlmConfigLogAdminStatus = 2;
    public static final int idxNlmConfigLogOperStatus = 3;
    public static final int idxNlmConfigLogStorageType = 4;
    public static final int idxNlmConfigLogEntryStatus = 5;
    private MOTableSubIndex[] nlmConfigLogEntryIndexes;
    private MOTableIndex nlmConfigLogEntryIndex;
    private MOTable<NlmConfigLogEntryRow, MOColumn, MOTableModel<NlmConfigLogEntryRow>> nlmConfigLogEntry;
    private MOTableModel<NlmConfigLogEntryRow> nlmConfigLogEntryModel;
    public static final OID oidNlmStatsLogEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 2, 3, 1});
    public static final int colNlmStatsLogNotificationsLogged = 1;
    public static final int colNlmStatsLogNotificationsBumped = 2;
    public static final int idxNlmStatsLogNotificationsLogged = 0;
    public static final int idxNlmStatsLogNotificationsBumped = 1;
    private MOTableSubIndex[] nlmStatsLogEntryIndexes;
    private MOTableIndex nlmStatsLogEntryIndex;
    private MOTable<NlmStatsLogEntryRow, MOColumn, MOTableModel<NlmStatsLogEntryRow>> nlmStatsLogEntry;
    private MOTableModel<NlmStatsLogEntryRow> nlmStatsLogEntryModel;
    public static final OID oidNlmLogEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 3, 1, 1});
    public static final OID oidNlmLogIndex = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 3, 1, 1, 1});
    public static final String tcDefTimeStamp = "TimeStamp";
    public static final String tcDefDateAndTime = "DateAndTime";
    public static final String tcDefSnmpEngineID = "SnmpEngineID";
    public static final String tcDefTAddress = "TAddress";
    public static final String tcDefTDomain = "TDomain";
    public static final int colNlmLogTime = 2;
    public static final int colNlmLogDateAndTime = 3;
    public static final int colNlmLogEngineID = 4;
    public static final int colNlmLogEngineTAddress = 5;
    public static final int colNlmLogEngineTDomain = 6;
    public static final int colNlmLogContextEngineID = 7;
    public static final int colNlmLogContextName = 8;
    public static final int colNlmLogNotificationID = 9;
    public static final int idxNlmLogTime = 0;
    public static final int idxNlmLogDateAndTime = 1;
    public static final int idxNlmLogEngineID = 2;
    public static final int idxNlmLogEngineTAddress = 3;
    public static final int idxNlmLogEngineTDomain = 4;
    public static final int idxNlmLogContextEngineID = 5;
    public static final int idxNlmLogContextName = 6;
    public static final int idxNlmLogNotificationID = 7;
    private MOTableSubIndex[] nlmLogEntryIndexes;
    private MOTableIndex nlmLogEntryIndex;
    private MOTable<NlmLogEntryRow, MOColumn, MOTableModel<NlmLogEntryRow>> nlmLogEntry;
    private MOTableModel<NlmLogEntryRow> nlmLogEntryModel;
    public static final OID oidNlmLogVariableEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 3, 2, 1});
    public static final OID oidNlmLogVariableIndex = new OID(new int[]{1, 3, 6, 1, 2, 1, 92, 1, 3, 2, 1, 1});
    public static final int colNlmLogVariableID = 2;
    public static final int colNlmLogVariableValueType = 3;
    public static final int colNlmLogVariableCounter32Val = 4;
    public static final int colNlmLogVariableUnsigned32Val = 5;
    public static final int colNlmLogVariableTimeTicksVal = 6;
    public static final int colNlmLogVariableInteger32Val = 7;
    public static final int colNlmLogVariableOctetStringVal = 8;
    public static final int colNlmLogVariableIpAddressVal = 9;
    public static final int colNlmLogVariableOidVal = 10;
    public static final int colNlmLogVariableCounter64Val = 11;
    public static final int colNlmLogVariableOpaqueVal = 12;
    public static final int idxNlmLogVariableID = 0;
    public static final int idxNlmLogVariableValueType = 1;
    public static final int idxNlmLogVariableCounter32Val = 2;
    public static final int idxNlmLogVariableUnsigned32Val = 3;
    public static final int idxNlmLogVariableTimeTicksVal = 4;
    public static final int idxNlmLogVariableInteger32Val = 5;
    public static final int idxNlmLogVariableOctetStringVal = 6;
    public static final int idxNlmLogVariableIpAddressVal = 7;
    public static final int idxNlmLogVariableOidVal = 8;
    public static final int idxNlmLogVariableCounter64Val = 9;
    public static final int idxNlmLogVariableOpaqueVal = 10;
    private MOTableSubIndex[] nlmLogVariableEntryIndexes;
    private MOTableIndex nlmLogVariableEntryIndex;
    private MOTable<NlmLogVariableEntryRow, MOColumn, MOTableModel<NlmLogVariableEntryRow>> nlmLogVariableEntry;
    private MOTableModel<NlmLogVariableEntryRow> nlmLogVariableEntryModel;
    public static final OID oidSnmp4jNotificationLogMode = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 1, 1, 3, 0});
    private static final int idxNlmConfigLogViewName = 6;
    private static final int[] VAR_SYNTAX_LIST = new int[]{65, 66, 67, 2, 4, 64, 6, 70, 68};
    private VACM vacm;
    private SnmpNotificationMIB snmpNotificationMIB;
    private long nextLogIndex = 0L;
    private TDomainAddressFactory addressFactory = new TDomainAddressFactoryImpl();
    private MOTableRelation<NlmConfigLogEntryRow, NlmStatsLogEntryRow> nlmStatsLogEntryAugmentation;
    private List<OID> nlmLogEntries = new ArrayList<OID>();
    private MOScalar<Integer32> snmp4jNotificationLogMode;

    protected NotificationLogMib() {
    }

    public NotificationLogMib(MOFactory moFactory) {
        this.createMO(moFactory);
        ((DefaultMOTable)this.nlmLogEntry).setVolatile(true);
        ((DefaultMOTable)this.nlmLogVariableEntry).setVolatile(true);
        ((DefaultMOTable)this.nlmStatsLogEntry).setVolatile(true);
    }

    public NotificationLogMib(MOFactory moFactory, VACM vacm, SnmpNotificationMIB snmpNotificationMIB) {
        this(moFactory);
        this.vacm = vacm;
        this.snmpNotificationMIB = snmpNotificationMIB;
        this.nlmStatsLogEntryAugmentation = new MOTableRelation<NlmConfigLogEntryRow, NlmStatsLogEntryRow>(this.nlmConfigLogEntry, this.nlmStatsLogEntry);
        this.nlmStatsLogEntryAugmentation.createRelationShip();
    }

    protected void createMO(MOFactory moFactory) {
        this.addTCsToFactory(moFactory);
        this.nlmConfigGlobalEntryLimit = new NlmConfigGlobalEntryLimit(oidNlmConfigGlobalEntryLimit, moFactory.createAccess(11));
        this.nlmConfigGlobalAgeOut = new NlmConfigGlobalAgeOut(oidNlmConfigGlobalAgeOut, moFactory.createAccess(11));
        this.nlmStatsGlobalNotificationsLogged = moFactory.createScalar(oidNlmStatsGlobalNotificationsLogged, moFactory.createAccess(9), new Counter32());
        this.nlmStatsGlobalNotificationsBumped = moFactory.createScalar(oidNlmStatsGlobalNotificationsBumped, moFactory.createAccess(9), new Counter32());
        this.snmp4jNotificationLogMode = moFactory.createScalar(oidSnmp4jNotificationLogMode, moFactory.createAccess(11), new Integer32(1));
        this.snmp4jNotificationLogMode.addMOValueValidationListener(new ValueConstraintValidator(new EnumerationConstraint(new int[]{1, 2})));
        this.createNlmConfigLogEntry(moFactory);
        this.createNlmStatsLogEntry(moFactory);
        this.createNlmLogEntry(moFactory);
        this.createNlmLogVariableEntry(moFactory);
    }

    public MOScalar<UnsignedInteger32> getNlmConfigGlobalEntryLimit() {
        return this.nlmConfigGlobalEntryLimit;
    }

    public MOScalar<UnsignedInteger32> getNlmConfigGlobalAgeOut() {
        return this.nlmConfigGlobalAgeOut;
    }

    public MOScalar<Counter32> getNlmStatsGlobalNotificationsLogged() {
        return this.nlmStatsGlobalNotificationsLogged;
    }

    public MOScalar<Counter32> getNlmStatsGlobalNotificationsBumped() {
        return this.nlmStatsGlobalNotificationsBumped;
    }

    public MOTable<NlmConfigLogEntryRow, MOColumn, MOTableModel<NlmConfigLogEntryRow>> getNlmConfigLogEntry() {
        return this.nlmConfigLogEntry;
    }

    private void createNlmConfigLogEntry(MOFactory moFactory) {
        this.nlmConfigLogEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidNlmLogName, 4, 0, 32)};
        this.nlmConfigLogEntryIndex = moFactory.createIndex(this.nlmConfigLogEntryIndexes, false);
        MOColumn[] nlmConfigLogEntryColumns = new MOColumn[6];
        nlmConfigLogEntryColumns[0] = new MOMutableColumn<OctetString>(2, 4, moFactory.createAccess(15), new OctetString(new byte[0]));
        ConstraintsImpl nlmConfigLogFilterNameVC = new ConstraintsImpl();
        nlmConfigLogFilterNameVC.add(new Constraint(0L, 32L));
        ((MOMutableColumn)nlmConfigLogEntryColumns[0]).addMOValueValidationListener(new ValueConstraintValidator(nlmConfigLogFilterNameVC));
        ((MOMutableColumn)nlmConfigLogEntryColumns[0]).addMOValueValidationListener(new NlmConfigLogFilterNameValidator());
        nlmConfigLogEntryColumns[1] = new MOMutableColumn<UnsignedInteger32>(3, 66, moFactory.createAccess(15), new UnsignedInteger32(0));
        nlmConfigLogEntryColumns[2] = new Enumerated<Integer32>(4, 2, moFactory.createAccess(15), new Integer32(1));
        EnumerationConstraint nlmConfigLogAdminStatusVC = new EnumerationConstraint(new int[]{1, 2});
        ((MOMutableColumn)nlmConfigLogEntryColumns[2]).addMOValueValidationListener(new ValueConstraintValidator(nlmConfigLogAdminStatusVC));
        nlmConfigLogEntryColumns[3] = moFactory.createColumn(5, 2, moFactory.createAccess(9));
        nlmConfigLogEntryColumns[4] = new StorageType(6, moFactory.createAccess(15), (Integer32)null);
        EnumerationConstraint nlmConfigLogStorageTypeVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5});
        ((MOMutableColumn)nlmConfigLogEntryColumns[4]).addMOValueValidationListener(new ValueConstraintValidator(nlmConfigLogStorageTypeVC));
        nlmConfigLogEntryColumns[5] = new RowStatus(7);
        EnumerationConstraint nlmConfigLogEntryStatusVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5, 6});
        ((MOMutableColumn)nlmConfigLogEntryColumns[5]).addMOValueValidationListener(new ValueConstraintValidator(nlmConfigLogEntryStatusVC));
        this.nlmConfigLogEntryModel = moFactory.createTableModel(oidNlmConfigLogEntry, this.nlmConfigLogEntryIndex, nlmConfigLogEntryColumns);
        ((MOMutableTableModel)this.nlmConfigLogEntryModel).setRowFactory(new NlmConfigLogEntryRowFactory());
        this.nlmConfigLogEntry = moFactory.createTable(oidNlmConfigLogEntry, this.nlmConfigLogEntryIndex, nlmConfigLogEntryColumns, this.nlmConfigLogEntryModel);
    }

    public MOTable<NlmStatsLogEntryRow, MOColumn, MOTableModel<NlmStatsLogEntryRow>> getNlmStatsLogEntry() {
        return this.nlmStatsLogEntry;
    }

    private void createNlmStatsLogEntry(MOFactory moFactory) {
        this.nlmStatsLogEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidNlmLogName, 4, 0, 32)};
        this.nlmStatsLogEntryIndex = moFactory.createIndex(this.nlmStatsLogEntryIndexes, false);
        MOColumn[] nlmStatsLogEntryColumns = new MOColumn[]{moFactory.createColumn(1, 65, moFactory.createAccess(9)), moFactory.createColumn(2, 65, moFactory.createAccess(9))};
        this.nlmStatsLogEntryModel = moFactory.createTableModel(oidNlmStatsLogEntry, this.nlmStatsLogEntryIndex, nlmStatsLogEntryColumns);
        ((MOMutableTableModel)this.nlmStatsLogEntryModel).setRowFactory(new NlmStatsLogEntryRowFactory());
        this.nlmStatsLogEntry = moFactory.createTable(oidNlmStatsLogEntry, this.nlmStatsLogEntryIndex, nlmStatsLogEntryColumns, this.nlmStatsLogEntryModel);
    }

    public MOTable<NlmLogEntryRow, MOColumn, MOTableModel<NlmLogEntryRow>> getNlmLogEntry() {
        return this.nlmLogEntry;
    }

    private void createNlmLogEntry(MOFactory moFactory) {
        this.nlmLogEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidNlmLogName, 4, 0, 32), moFactory.createSubIndex(oidNlmLogIndex, 2, 1, 1)};
        this.nlmLogEntryIndex = moFactory.createIndex(this.nlmLogEntryIndexes, false);
        MOColumn[] nlmLogEntryColumns = new MOColumn[]{moFactory.createColumn(2, 67, moFactory.createAccess(9), "SNMPv2-TC", "TimeStamp"), moFactory.createColumn(3, 4, moFactory.createAccess(9), "SNMPv2-TC", "DateAndTime"), moFactory.createColumn(4, 4, moFactory.createAccess(9), "SNMP-FRAMEWORK-MIB", "SnmpEngineID"), moFactory.createColumn(5, 4, moFactory.createAccess(9), "SNMPv2-TC", "TAddress"), moFactory.createColumn(6, 6, moFactory.createAccess(9), "SNMPv2-TC", "TDomain"), moFactory.createColumn(7, 4, moFactory.createAccess(9), "SNMP-FRAMEWORK-MIB", "SnmpEngineID"), moFactory.createColumn(8, 4, moFactory.createAccess(9), "SNMP-FRAMEWORK-MIB", "SnmpAdminString"), moFactory.createColumn(9, 6, moFactory.createAccess(9))};
        this.nlmLogEntryModel = moFactory.createTableModel(oidNlmLogEntry, this.nlmLogEntryIndex, nlmLogEntryColumns);
        ((MOMutableTableModel)this.nlmLogEntryModel).setRowFactory(new NlmLogEntryRowFactory());
        this.nlmLogEntry = moFactory.createTable(oidNlmLogEntry, this.nlmLogEntryIndex, nlmLogEntryColumns, this.nlmLogEntryModel);
    }

    public MOTable<NlmLogVariableEntryRow, MOColumn, MOTableModel<NlmLogVariableEntryRow>> getNlmLogVariableEntry() {
        return this.nlmLogVariableEntry;
    }

    private void createNlmLogVariableEntry(MOFactory moFactory) {
        this.nlmLogVariableEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidNlmLogName, 4, 0, 32), moFactory.createSubIndex(oidNlmLogIndex, 2, 1, 1), moFactory.createSubIndex(oidNlmLogVariableIndex, 2, 1, 1)};
        this.nlmLogVariableEntryIndex = moFactory.createIndex(this.nlmLogVariableEntryIndexes, false);
        MOColumn[] nlmLogVariableEntryColumns = new MOColumn[]{moFactory.createColumn(2, 6, moFactory.createAccess(9)), moFactory.createColumn(3, 2, moFactory.createAccess(9)), moFactory.createColumn(4, 65, moFactory.createAccess(9)), moFactory.createColumn(5, 66, moFactory.createAccess(9)), moFactory.createColumn(6, 67, moFactory.createAccess(9)), moFactory.createColumn(7, 2, moFactory.createAccess(9)), moFactory.createColumn(8, 4, moFactory.createAccess(9)), moFactory.createColumn(9, 64, moFactory.createAccess(9)), moFactory.createColumn(10, 6, moFactory.createAccess(9)), moFactory.createColumn(11, 70, moFactory.createAccess(9)), moFactory.createColumn(12, 68, moFactory.createAccess(9))};
        this.nlmLogVariableEntryModel = moFactory.createTableModel(oidNlmLogVariableEntry, this.nlmLogVariableEntryIndex, nlmLogVariableEntryColumns);
        ((MOMutableTableModel)this.nlmLogVariableEntryModel).setRowFactory(new NlmLogVariableEntryRowFactory());
        this.nlmLogVariableEntry = moFactory.createTable(oidNlmLogVariableEntry, this.nlmLogVariableEntryIndex, nlmLogVariableEntryColumns, this.nlmLogVariableEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.nlmConfigGlobalEntryLimit, context);
        server.register(this.nlmConfigGlobalAgeOut, context);
        server.register(this.nlmStatsGlobalNotificationsLogged, context);
        server.register(this.nlmStatsGlobalNotificationsBumped, context);
        server.register(this.nlmConfigLogEntry, context);
        server.register(this.nlmStatsLogEntry, context);
        server.register(this.nlmLogEntry, context);
        server.register(this.nlmLogVariableEntry, context);
        server.register(this.snmp4jNotificationLogMode, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.nlmConfigGlobalEntryLimit, context);
        server.unregister(this.nlmConfigGlobalAgeOut, context);
        server.unregister(this.nlmStatsGlobalNotificationsLogged, context);
        server.unregister(this.nlmStatsGlobalNotificationsBumped, context);
        server.unregister(this.nlmConfigLogEntry, context);
        server.unregister(this.nlmStatsLogEntry, context);
        server.unregister(this.nlmLogEntry, context);
        server.unregister(this.nlmLogVariableEntry, context);
        server.unregister(this.snmp4jNotificationLogMode, context);
    }

    public void setLogMode(int loggerMode) {
        this.snmp4jNotificationLogMode.setValue(new Integer32(loggerMode));
    }

    public int getLogMode() {
        return this.snmp4jNotificationLogMode.getValue().toInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Address> void notificationLogEvent(NotificationLogEvent<A> notificationLogEvent) {
        if (notificationLogEvent.isSubEvent() == (this.getLogMode() == 2)) {
            Integer32 enabledStatus = new Integer32(1);
            MOTableModel<NlmConfigLogEntryRow> mOTableModel = this.nlmConfigLogEntryModel;
            synchronized (mOTableModel) {
                Iterator<NlmConfigLogEntryRow> it = this.nlmConfigLogEntryModel.iterator();
                while (it.hasNext()) {
                    NlmLogEntryRow logRow;
                    NlmConfigLogEntryRow row = it.next();
                    if (!enabledStatus.equals((Object)row.getNlmConfigLogAdminStatus())) continue;
                    OctetString profileName = new OctetString();
                    profileName.fromSubIndex(row.getIndex(), false);
                    OctetString filterName = row.getNlmConfigLogFilterName();
                    if (filterName == null || profileName.length() != 0 && !this.checkAccess(notificationLogEvent.getNotificationID(), notificationLogEvent.getVariables(), row) || !this.snmpNotificationMIB.passesFilter(filterName, notificationLogEvent.getNotificationID(), notificationLogEvent.getVariables())) continue;
                    this.nextLogIndex = this.nextLogIndex > 0xFFFFFFFFL ? 1L : ++this.nextLogIndex;
                    while (!this.nlmLogEntryModel.isEmpty() && (long)this.nlmLogEntryModel.lastIndex().last() >= this.nextLogIndex) {
                        ++this.nextLogIndex;
                    }
                    OID logIndex = profileName.toSubIndex(false);
                    logIndex.append((int)this.nextLogIndex);
                    OctetString addrString = new OctetString();
                    OID domainOID = new OID();
                    if (notificationLogEvent.getOriginatorTarget() != null) {
                        Address addr = notificationLogEvent.getOriginatorTarget().getAddress();
                        addrString = this.addressFactory.getAddress(addr);
                        domainOID = this.addressFactory.getTransportDomain(addr)[0];
                    }
                    if (this.nlmLogEntry.addRow(logRow = this.nlmLogEntry.createRow(logIndex, new Variable[]{SNMPv2MIB.getSysUpTime(null).get(), DateAndTime.makeDateAndTime(new GregorianCalendar()), notificationLogEvent.getOriginatorEngineID(), addrString, domainOID, notificationLogEvent.getContextEngineID(), notificationLogEvent.getContext(), notificationLogEvent.getNotificationID()}))) {
                        this.nlmLogEntries.add(logRow.getIndex());
                    }
                    for (int i = 0; i < notificationLogEvent.getVariables().length; ++i) {
                        this.addVariable(logIndex, i + 1, notificationLogEvent.getVariables()[i]);
                    }
                    MOTableModel<NlmStatsLogEntryRow> mOTableModel2 = this.nlmStatsLogEntryModel;
                    synchronized (mOTableModel2) {
                        NlmStatsLogEntryRow statsRow = this.nlmStatsLogEntryModel.getRow(profileName.toSubIndex(false));
                        if (statsRow != null) {
                            statsRow.getNlmStatsLogNotificationsLogged().increment();
                        }
                    }
                    this.nlmStatsGlobalNotificationsLogged.getValue().increment();
                    this.checkLimits(profileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLimits(OctetString profileName) {
        long l;
        UnsignedInteger32 limit;
        NlmConfigLogEntryRow profile;
        long ageOut;
        long globalLimit = this.nlmConfigGlobalEntryLimit.getValue().getValue();
        if (globalLimit > 0L) {
            this.deleteLogRows(globalLimit, null);
        }
        if ((ageOut = this.nlmConfigGlobalAgeOut.getValue().getValue()) > 0L) {
            ArrayList<OID> victims = new ArrayList<OID>();
            MOTableModel<NlmLogEntryRow> mOTableModel = this.nlmLogEntryModel;
            synchronized (mOTableModel) {
                TimeTicks uptime = SNMPv2MIB.getSysUpTime(null).get();
                Iterator<NlmLogEntryRow> it = this.nlmLogEntryModel.iterator();
                while (it.hasNext()) {
                    NlmStatsLogEntryRow statsRow;
                    NlmLogEntryRow row = it.next();
                    if (uptime.getValue() - row.getNlmLogTime().getValue() <= ageOut * 6000L || (statsRow = this.nlmStatsLogEntryModel.getRow(row.getIndex().trim())) == null) continue;
                    statsRow.getNlmStatsLogNotificationsBumped().increment();
                    victims.add(statsRow.getIndex());
                }
            }
            for (OID index : victims) {
                this.nlmLogEntries.remove(index);
                this.nlmLogEntry.removeRow(index);
                ((DefaultMOMutableTableModel)this.nlmLogVariableEntryModel).removeRows(index, index.nextPeer());
                this.nlmStatsGlobalNotificationsBumped.getValue().increment();
            }
        }
        if (profileName != null && (profile = this.nlmConfigLogEntry.getModel().getRow(profileName.toSubIndex(false))) != null && (limit = profile.getNlmConfigLogEntryLimit()) != null && (l = limit.getValue()) > 0L) {
            this.deleteLogRows(l, profileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLogRows(long limit, OctetString profileName) {
        long delta = (long)this.nlmLogEntry.getModel().getRowCount() - limit;
        if (delta > 0L) {
            List<OID> list = this.nlmLogEntries;
            synchronized (list) {
                int i = 0;
                while ((long)i < delta && this.nlmLogEntries.size() > 0) {
                    OID firstIndex = this.nlmLogEntries.remove(0);
                    if (firstIndex != null) {
                        NlmStatsLogEntryRow profile;
                        this.nlmLogEntry.removeRow(firstIndex);
                        ((DefaultMOMutableTableModel)this.nlmLogVariableEntryModel).removeRows(firstIndex, firstIndex.nextPeer());
                        NlmStatsLogEntryRow statsRow = this.nlmStatsLogEntryModel.getRow(firstIndex.trim());
                        if (statsRow != null) {
                            statsRow.getNlmStatsLogNotificationsBumped().increment();
                        }
                        this.nlmStatsGlobalNotificationsBumped.getValue().increment();
                        if (profileName != null && (profile = this.nlmStatsLogEntry.getModel().getRow(profileName.toSubIndex(false))) != null) {
                            profile.getNlmStatsLogNotificationsBumped().increment();
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private boolean addVariable(OID logIndex, int varIndex, VariableBinding vb) {
        OID vIndex = new OID(logIndex);
        vIndex.append(varIndex);
        Variable[] variables = new Variable[]{vb.getOid(), null, null, null, null, null, null, null, null, null, null};
        for (int i = 0; i < VAR_SYNTAX_LIST.length; ++i) {
            if (VAR_SYNTAX_LIST[i] != vb.getSyntax()) continue;
            switch (i + 1) {
                case 5: {
                    variables[1] = new Integer32(6);
                    break;
                }
                case 6: {
                    variables[1] = new Integer32(5);
                    break;
                }
                default: {
                    variables[1] = new Integer32(i + 1);
                }
            }
            variables[2 + i] = vb.getVariable();
        }
        NlmLogVariableEntryRow row = this.nlmLogVariableEntry.createRow(vIndex, variables);
        return this.nlmLogVariableEntry.addRow(row);
    }

    private boolean checkAccess(OID notifyID, VariableBinding[] vbs, NlmConfigLogEntryRow row) {
        OctetString viewName = row.getViewName();
        if (viewName == null || viewName.length() == 0) {
            return true;
        }
        boolean accessAllowed = true;
        if (this.vacm.isAccessAllowed(row.getViewName(), notifyID) != 0) {
            accessAllowed = false;
        }
        for (int i = 0; accessAllowed && i < vbs.length; ++i) {
            if (this.vacm.isAccessAllowed(row.getViewName(), vbs[i].getOid()) == 0) continue;
            accessAllowed = false;
        }
        if (!accessAllowed) {
            LOGGER.info((CharSequence)("Notification not logged because view '" + row.getViewName() + "' of log entry '" + row.getIndex() + "' has not access"));
        }
        return accessAllowed;
    }

    @Override
    public void rowStatusChanged(RowStatusEvent event) {
        Request<?, ?, ?> r = event.getRequest().getRequest();
        if (event.isRowActivated() && event.isDeniable()) {
            OctetString viewName = this.vacm.getViewName(r.getContext(), r.getSecurityName(), r.getSecurityModel(), r.getSecurityLevel(), 0);
            if (viewName == null) {
                event.setDenyReason(16);
                return;
            }
            event.getRequest().setUserObject(viewName);
        } else if (event.isRowActivated()) {
            ((NlmConfigLogEntryRow)event.getRow()).setViewName((OctetString)event.getRequest().getUserObject());
        }
    }

    protected void addTCsToFactory(MOFactory moFactory) {
    }

    public void addImportedTCsToFactory(MOFactory moFactory) {
        moFactory.addTextualConvention(new SnmpAdminString());
        moFactory.addTextualConvention(new TAddress());
        moFactory.addTextualConvention(new TDomain());
        moFactory.addTextualConvention(new SnmpEngineID());
    }

    public class NlmConfigGlobalEntryLimit
    extends MOScalar<UnsignedInteger32> {
        NlmConfigGlobalEntryLimit(OID oid, MOAccess access) {
            super(oid, access, new UnsignedInteger32());
        }

        @Override
        public int isValueOK(SubRequest<?> request) {
            Variable newValue = request.getVariableBinding().getVariable();
            int valueOK = super.isValueOK(request);
            if (valueOK != 0) {
                return valueOK;
            }
            return valueOK;
        }

        @Override
        public UnsignedInteger32 getValue() {
            return (UnsignedInteger32)super.getValue();
        }

        @Override
        public int setValue(UnsignedInteger32 newValue) {
            return super.setValue(newValue);
        }

        @Override
        public void commit(SubRequest<?> sreq) {
            super.commit(sreq);
            if (sreq.getStatus().getErrorStatus() == 0) {
                OID index = sreq.getVariableBinding().getOid();
                index = new OID(index.getValue(), oidNlmConfigLogEntry.size() + 1, index.size() - oidNlmConfigLogEntry.size() + 1);
                OctetString profileName = new OctetString();
                profileName.fromSubIndex(index, false);
                NotificationLogMib.this.checkLimits(profileName);
            }
        }
    }

    public class NlmConfigGlobalAgeOut
    extends MOScalar<UnsignedInteger32> {
        NlmConfigGlobalAgeOut(OID oid, MOAccess access) {
            super(oid, access, new UnsignedInteger32());
        }

        @Override
        public int isValueOK(SubRequest<?> request) {
            Variable newValue = request.getVariableBinding().getVariable();
            int valueOK = super.isValueOK(request);
            if (valueOK != 0) {
                return valueOK;
            }
            return valueOK;
        }

        @Override
        public UnsignedInteger32 getValue() {
            return (UnsignedInteger32)super.getValue();
        }

        @Override
        public int setValue(UnsignedInteger32 newValue) {
            return super.setValue(newValue);
        }
    }

    public static final class Snmp4jNotificationLogModeEnum {
        public static final int fired = 1;
        public static final int sent = 2;
    }

    static class NlmConfigLogFilterNameValidator
    implements MOValueValidationListener {
        NlmConfigLogFilterNameValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 32) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    public static final class NlmConfigLogAdminStatusEnum {
        public static final int enabled = 1;
        public static final int disabled = 2;
    }

    class NlmConfigLogEntryRowFactory
    implements MOTableRowFactory<NlmConfigLogEntryRow> {
        NlmConfigLogEntryRowFactory() {
        }

        @Override
        public synchronized NlmConfigLogEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            NlmConfigLogEntryRow row = new NlmConfigLogEntryRow(index, values);
            if (values.length < NotificationLogMib.this.nlmConfigLogEntry.getColumnCount() + 1) {
                Variable[] extended = new Variable[NotificationLogMib.this.nlmConfigLogEntry.getColumnCount() + 1];
                System.arraycopy(values, 0, extended, 0, values.length);
                extended[values.length] = new OctetString();
                row = new NlmConfigLogEntryRow(index, extended);
            }
            return row;
        }

        @Override
        public synchronized void freeRow(NlmConfigLogEntryRow row) {
        }
    }

    class NlmStatsLogEntryRowFactory
    implements MOTableRowFactory<NlmStatsLogEntryRow> {
        NlmStatsLogEntryRowFactory() {
        }

        @Override
        public synchronized NlmStatsLogEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            NlmStatsLogEntryRow row = new NlmStatsLogEntryRow(index, values);
            values[0] = new Counter32(0L);
            values[1] = new Counter32(0L);
            return row;
        }

        @Override
        public synchronized void freeRow(NlmStatsLogEntryRow row) {
        }
    }

    class NlmLogEntryRowFactory
    implements MOTableRowFactory<NlmLogEntryRow> {
        NlmLogEntryRowFactory() {
        }

        @Override
        public synchronized NlmLogEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            NlmLogEntryRow row = new NlmLogEntryRow(index, values);
            return row;
        }

        @Override
        public synchronized void freeRow(NlmLogEntryRow row) {
        }
    }

    class NlmLogVariableEntryRowFactory
    implements MOTableRowFactory<NlmLogVariableEntryRow> {
        NlmLogVariableEntryRowFactory() {
        }

        @Override
        public synchronized NlmLogVariableEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            NlmLogVariableEntryRow row = new NlmLogVariableEntryRow(index, values);
            return row;
        }

        @Override
        public synchronized void freeRow(NlmLogVariableEntryRow row) {
        }
    }

    public class NlmConfigLogEntryRow
    extends DefaultMOMutableRow2PC {
        public NlmConfigLogEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getNlmConfigLogFilterName() {
            return (OctetString)super.getValue(0);
        }

        public void setNlmConfigLogFilterName(OctetString newValue) {
            super.setValue(0, (Variable)newValue);
        }

        public UnsignedInteger32 getNlmConfigLogEntryLimit() {
            return (UnsignedInteger32)super.getValue(1);
        }

        public void setNlmConfigLogEntryLimit(UnsignedInteger32 newValue) {
            super.setValue(1, (Variable)newValue);
        }

        public Integer32 getNlmConfigLogAdminStatus() {
            return (Integer32)super.getValue(2);
        }

        public void setNlmConfigLogAdminStatus(Integer32 newValue) {
            super.setValue(2, (Variable)newValue);
        }

        public Integer32 getNlmConfigLogOperStatus() {
            OctetString logFilter;
            this.values[3] = 1 == this.getNlmConfigLogAdminStatus().getValue() ? ((logFilter = this.getNlmConfigLogFilterName()) != null && logFilter.length() > 0 && NotificationLogMib.this.snmpNotificationMIB.hasFilter(this.getNlmConfigLogFilterName()) ? new Integer32(2) : new Integer32(3)) : new Integer32(1);
            return (Integer32)super.getValue(3);
        }

        public void setNlmConfigLogOperStatus(Integer32 newValue) {
            super.setValue(3, (Variable)newValue);
        }

        public Integer32 getNlmConfigLogStorageType() {
            return (Integer32)super.getValue(4);
        }

        public void setNlmConfigLogStorageType(Integer32 newValue) {
            super.setValue(4, (Variable)newValue);
        }

        public Integer32 getNlmConfigLogEntryStatus() {
            return (Integer32)super.getValue(5);
        }

        public void setNlmConfigLogEntryStatus(Integer32 newValue) {
            super.setValue(5, (Variable)newValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getNlmConfigLogFilterName();
                }
                case 1: {
                    return this.getNlmConfigLogEntryLimit();
                }
                case 2: {
                    return this.getNlmConfigLogAdminStatus();
                }
                case 3: {
                    return this.getNlmConfigLogOperStatus();
                }
                case 4: {
                    return this.getNlmConfigLogStorageType();
                }
                case 5: {
                    return this.getNlmConfigLogEntryStatus();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setNlmConfigLogFilterName((OctetString)value);
                    break;
                }
                case 1: {
                    this.setNlmConfigLogEntryLimit((UnsignedInteger32)value);
                    break;
                }
                case 2: {
                    this.setNlmConfigLogAdminStatus((Integer32)value);
                    break;
                }
                case 3: {
                    this.setNlmConfigLogOperStatus((Integer32)value);
                    break;
                }
                case 4: {
                    this.setNlmConfigLogStorageType((Integer32)value);
                    break;
                }
                case 5: {
                    this.setNlmConfigLogEntryStatus((Integer32)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }

        public void setViewName(OctetString viewName) {
            this.values[6] = viewName;
        }

        public OctetString getViewName() {
            return (OctetString)this.values[6];
        }
    }

    public class NlmLogEntryRow
    extends DefaultMOMutableRow2PC {
        public NlmLogEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public TimeTicks getNlmLogTime() {
            return (TimeTicks)super.getValue(0);
        }

        public void setNlmLogTime(TimeTicks newValue) {
            super.setValue(0, (Variable)newValue);
        }

        public OctetString getNlmLogDateAndTime() {
            return (OctetString)super.getValue(1);
        }

        public void setNlmLogDateAndTime(OctetString newValue) {
            super.setValue(1, (Variable)newValue);
        }

        public OctetString getNlmLogEngineID() {
            return (OctetString)super.getValue(2);
        }

        public void setNlmLogEngineID(OctetString newValue) {
            super.setValue(2, (Variable)newValue);
        }

        public OctetString getNlmLogEngineTAddress() {
            return (OctetString)super.getValue(3);
        }

        public void setNlmLogEngineTAddress(OctetString newValue) {
            super.setValue(3, (Variable)newValue);
        }

        public OID getNlmLogEngineTDomain() {
            return (OID)super.getValue(4);
        }

        public void setNlmLogEngineTDomain(OID newValue) {
            super.setValue(4, (Variable)newValue);
        }

        public OctetString getNlmLogContextEngineID() {
            return (OctetString)super.getValue(5);
        }

        public void setNlmLogContextEngineID(OctetString newValue) {
            super.setValue(5, (Variable)newValue);
        }

        public OctetString getNlmLogContextName() {
            return (OctetString)super.getValue(6);
        }

        public void setNlmLogContextName(OctetString newValue) {
            super.setValue(6, (Variable)newValue);
        }

        public OID getNlmLogNotificationID() {
            return (OID)super.getValue(7);
        }

        public void setNlmLogNotificationID(OID newValue) {
            super.setValue(7, (Variable)newValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getNlmLogTime();
                }
                case 1: {
                    return this.getNlmLogDateAndTime();
                }
                case 2: {
                    return this.getNlmLogEngineID();
                }
                case 3: {
                    return this.getNlmLogEngineTAddress();
                }
                case 4: {
                    return this.getNlmLogEngineTDomain();
                }
                case 5: {
                    return this.getNlmLogContextEngineID();
                }
                case 6: {
                    return this.getNlmLogContextName();
                }
                case 7: {
                    return this.getNlmLogNotificationID();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setNlmLogTime((TimeTicks)value);
                    break;
                }
                case 1: {
                    this.setNlmLogDateAndTime((OctetString)value);
                    break;
                }
                case 2: {
                    this.setNlmLogEngineID((OctetString)value);
                    break;
                }
                case 3: {
                    this.setNlmLogEngineTAddress((OctetString)value);
                    break;
                }
                case 4: {
                    this.setNlmLogEngineTDomain((OID)value);
                    break;
                }
                case 5: {
                    this.setNlmLogContextEngineID((OctetString)value);
                    break;
                }
                case 6: {
                    this.setNlmLogContextName((OctetString)value);
                    break;
                }
                case 7: {
                    this.setNlmLogNotificationID((OID)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }
    }

    public class NlmStatsLogEntryRow
    extends DefaultMOMutableRow2PC {
        public NlmStatsLogEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public Counter32 getNlmStatsLogNotificationsLogged() {
            return (Counter32)super.getValue(0);
        }

        public void setNlmStatsLogNotificationsLogged(Counter32 newValue) {
            super.setValue(0, (Variable)newValue);
        }

        public Counter32 getNlmStatsLogNotificationsBumped() {
            return (Counter32)super.getValue(1);
        }

        public void setNlmStatsLogNotificationsBumped(Counter32 newValue) {
            super.setValue(1, (Variable)newValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getNlmStatsLogNotificationsLogged();
                }
                case 1: {
                    return this.getNlmStatsLogNotificationsBumped();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setNlmStatsLogNotificationsLogged((Counter32)value);
                    break;
                }
                case 1: {
                    this.setNlmStatsLogNotificationsBumped((Counter32)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }
    }

    public static final class NlmLogVariableValueTypeEnum {
        public static final int counter32 = 1;
        public static final int unsigned32 = 2;
        public static final int timeTicks = 3;
        public static final int integer32 = 4;
        public static final int ipAddress = 5;
        public static final int octetString = 6;
        public static final int objectId = 7;
        public static final int counter64 = 8;
        public static final int opaque = 9;
    }

    public class NlmLogVariableEntryRow
    extends DefaultMOMutableRow2PC {
        public NlmLogVariableEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OID getNlmLogVariableID() {
            return (OID)super.getValue(0);
        }

        public void setNlmLogVariableID(OID newValue) {
            super.setValue(0, (Variable)newValue);
        }

        public Integer32 getNlmLogVariableValueType() {
            return (Integer32)super.getValue(1);
        }

        public void setNlmLogVariableValueType(Integer32 newValue) {
            super.setValue(1, (Variable)newValue);
        }

        public Counter32 getNlmLogVariableCounter32Val() {
            return (Counter32)super.getValue(2);
        }

        public void setNlmLogVariableCounter32Val(Counter32 newValue) {
            super.setValue(2, (Variable)newValue);
        }

        public UnsignedInteger32 getNlmLogVariableUnsigned32Val() {
            return (UnsignedInteger32)super.getValue(3);
        }

        public void setNlmLogVariableUnsigned32Val(UnsignedInteger32 newValue) {
            super.setValue(3, (Variable)newValue);
        }

        public TimeTicks getNlmLogVariableTimeTicksVal() {
            return (TimeTicks)super.getValue(4);
        }

        public void setNlmLogVariableTimeTicksVal(TimeTicks newValue) {
            super.setValue(4, (Variable)newValue);
        }

        public Integer32 getNlmLogVariableInteger32Val() {
            return (Integer32)super.getValue(5);
        }

        public void setNlmLogVariableInteger32Val(Integer32 newValue) {
            super.setValue(5, (Variable)newValue);
        }

        public OctetString getNlmLogVariableOctetStringVal() {
            return (OctetString)super.getValue(6);
        }

        public void setNlmLogVariableOctetStringVal(OctetString newValue) {
            super.setValue(6, (Variable)newValue);
        }

        public IpAddress getNlmLogVariableIpAddressVal() {
            return (IpAddress)super.getValue(7);
        }

        public void setNlmLogVariableIpAddressVal(IpAddress newValue) {
            super.setValue(7, (Variable)newValue);
        }

        public OID getNlmLogVariableOidVal() {
            return (OID)super.getValue(8);
        }

        public void setNlmLogVariableOidVal(OID newValue) {
            super.setValue(8, (Variable)newValue);
        }

        public Counter64 getNlmLogVariableCounter64Val() {
            return (Counter64)super.getValue(9);
        }

        public void setNlmLogVariableCounter64Val(Counter64 newValue) {
            super.setValue(9, (Variable)newValue);
        }

        public Opaque getNlmLogVariableOpaqueVal() {
            return (Opaque)super.getValue(10);
        }

        public void setNlmLogVariableOpaqueVal(Opaque newValue) {
            super.setValue(10, (Variable)newValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getNlmLogVariableID();
                }
                case 1: {
                    return this.getNlmLogVariableValueType();
                }
                case 2: {
                    return this.getNlmLogVariableCounter32Val();
                }
                case 3: {
                    return this.getNlmLogVariableUnsigned32Val();
                }
                case 4: {
                    return this.getNlmLogVariableTimeTicksVal();
                }
                case 5: {
                    return this.getNlmLogVariableInteger32Val();
                }
                case 6: {
                    return this.getNlmLogVariableOctetStringVal();
                }
                case 7: {
                    return this.getNlmLogVariableIpAddressVal();
                }
                case 8: {
                    return this.getNlmLogVariableOidVal();
                }
                case 9: {
                    return this.getNlmLogVariableCounter64Val();
                }
                case 10: {
                    return this.getNlmLogVariableOpaqueVal();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setNlmLogVariableID((OID)value);
                    break;
                }
                case 1: {
                    this.setNlmLogVariableValueType((Integer32)value);
                    break;
                }
                case 2: {
                    this.setNlmLogVariableCounter32Val((Counter32)value);
                    break;
                }
                case 3: {
                    this.setNlmLogVariableUnsigned32Val((UnsignedInteger32)value);
                    break;
                }
                case 4: {
                    this.setNlmLogVariableTimeTicksVal((TimeTicks)value);
                    break;
                }
                case 5: {
                    this.setNlmLogVariableInteger32Val((Integer32)value);
                    break;
                }
                case 6: {
                    this.setNlmLogVariableOctetStringVal((OctetString)value);
                    break;
                }
                case 7: {
                    this.setNlmLogVariableIpAddressVal((IpAddress)value);
                    break;
                }
                case 8: {
                    this.setNlmLogVariableOidVal((OID)value);
                    break;
                }
                case 9: {
                    this.setNlmLogVariableCounter64Val((Counter64)value);
                    break;
                }
                case 10: {
                    this.setNlmLogVariableOpaqueVal((Opaque)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }
    }

    public class SnmpAdminString
    implements TextualConvention<OctetString> {
        @Override
        public String getModuleName() {
            return "SNMP-FRAMEWORK-MIB";
        }

        @Override
        public String getName() {
            return "SnmpAdminString";
        }

        @Override
        public OctetString createInitialValue() {
            OctetString v = new OctetString();
            if (v instanceof AssignableFromLong) {
                ((AssignableFromLong)v).setValue(0L);
            }
            return v;
        }

        @Override
        public MOScalar<OctetString> createScalar(OID oid, MOAccess access, OctetString value) {
            MOScalar<OctetString> scalar = NotificationLogMib.this.moFactory.createScalar(oid, access, value);
            ConstraintsImpl vc = new ConstraintsImpl();
            vc.add(new Constraint(0L, 255L));
            scalar.addMOValueValidationListener(new ValueConstraintValidator(vc));
            return scalar;
        }

        @Override
        public MOColumn<OctetString> createColumn(int columnID, int syntax, MOAccess access, OctetString defaultValue, boolean mutableInService) {
            MOColumn<OctetString> col = NotificationLogMib.this.moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            if (col instanceof MOMutableColumn) {
                MOMutableColumn mcol = (MOMutableColumn)col;
                ConstraintsImpl vc = new ConstraintsImpl();
                vc.add(new Constraint(0L, 255L));
                mcol.addMOValueValidationListener(new ValueConstraintValidator(vc));
            }
            return col;
        }
    }

    public class TAddress
    implements TextualConvention<OctetString> {
        @Override
        public String getModuleName() {
            return "SNMPv2-TC";
        }

        @Override
        public String getName() {
            return "TAddress";
        }

        @Override
        public OctetString createInitialValue() {
            OctetString v = new OctetString();
            return v;
        }

        @Override
        public MOScalar<OctetString> createScalar(OID oid, MOAccess access, OctetString value) {
            MOScalar<OctetString> scalar = NotificationLogMib.this.moFactory.createScalar(oid, access, value);
            ConstraintsImpl vc = new ConstraintsImpl();
            vc.add(new Constraint(1L, 255L));
            scalar.addMOValueValidationListener(new ValueConstraintValidator(vc));
            return scalar;
        }

        @Override
        public MOColumn<OctetString> createColumn(int columnID, int syntax, MOAccess access, OctetString defaultValue, boolean mutableInService) {
            MOColumn<OctetString> col = NotificationLogMib.this.moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            if (col instanceof MOMutableColumn) {
                MOMutableColumn mcol = (MOMutableColumn)col;
                ConstraintsImpl vc = new ConstraintsImpl();
                vc.add(new Constraint(1L, 255L));
                mcol.addMOValueValidationListener(new ValueConstraintValidator(vc));
            }
            return col;
        }
    }

    public class TDomain
    implements TextualConvention<OID> {
        @Override
        public String getModuleName() {
            return "SNMPv2-TC";
        }

        @Override
        public String getName() {
            return "TDomain";
        }

        @Override
        public OID createInitialValue() {
            OID v = new OID();
            return v;
        }

        @Override
        public MOScalar<OID> createScalar(OID oid, MOAccess access, OID value) {
            MOScalar<OID> scalar = NotificationLogMib.this.moFactory.createScalar(oid, access, value);
            return scalar;
        }

        @Override
        public MOColumn<OID> createColumn(int columnID, int syntax, MOAccess access, OID defaultValue, boolean mutableInService) {
            MOColumn<OID> col = NotificationLogMib.this.moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            return col;
        }
    }

    public class SnmpEngineID
    implements TextualConvention<OctetString> {
        @Override
        public String getModuleName() {
            return "SNMP-FRAMEWORK-MIB";
        }

        @Override
        public String getName() {
            return "SnmpEngineID";
        }

        @Override
        public OctetString createInitialValue() {
            OctetString v = new OctetString();
            return v;
        }

        @Override
        public MOScalar<OctetString> createScalar(OID oid, MOAccess access, OctetString value) {
            MOScalar<OctetString> scalar = NotificationLogMib.this.moFactory.createScalar(oid, access, value);
            ConstraintsImpl vc = new ConstraintsImpl();
            vc.add(new Constraint(5L, 32L));
            scalar.addMOValueValidationListener(new ValueConstraintValidator(vc));
            return scalar;
        }

        @Override
        public MOColumn<OctetString> createColumn(int columnID, int syntax, MOAccess access, OctetString defaultValue, boolean mutableInService) {
            MOColumn<OctetString> col = NotificationLogMib.this.moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            if (col instanceof MOMutableColumn) {
                MOMutableColumn mcol = (MOMutableColumn)col;
                ConstraintsImpl vc = new ConstraintsImpl();
                vc.add(new Constraint(5L, 32L));
                mcol.addMOValueValidationListener(new ValueConstraintValidator(vc));
            }
            return col;
        }
    }

    static class Snmp4jNotificationLogModeValidator
    implements MOValueValidationListener {
        Snmp4jNotificationLogModeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    public static final class NlmConfigLogOperStatusEnum {
        public static final int disabled = 1;
        public static final int operational = 2;
        public static final int noFilter = 3;
    }
}

