/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.dh;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.snmp4j.agent.mo.snmp.dh.DHKickstartParameters;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class DHKickstartParametersImpl
implements DHKickstartParameters {
    private OctetString securityName;
    private OctetString publicKey;
    private OID authenticationProtocol = SnmpConstants.usmHMACMD5AuthProtocol;
    private OID privacyProtocol = SnmpConstants.usmDESPrivProtocol;
    private String vacmRole;
    private boolean resetRequested;

    public DHKickstartParametersImpl(OctetString securityName, OctetString publicKey, OID authenticationProtocol, OID privacyProtocol, String vacmRole, boolean resetRequested) {
        this.securityName = securityName;
        this.publicKey = publicKey;
        this.authenticationProtocol = authenticationProtocol;
        this.privacyProtocol = privacyProtocol;
        this.vacmRole = vacmRole;
        this.resetRequested = resetRequested;
    }

    public DHKickstartParametersImpl(OctetString securityName, OctetString publicKey) {
        this.securityName = securityName;
        this.publicKey = publicKey;
    }

    @Override
    public OctetString getSecurityName() {
        return this.securityName;
    }

    @Override
    public OctetString getPublicKey() {
        return this.publicKey;
    }

    @Override
    public OID getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    @Override
    public OID getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    @Override
    public String getVacmRole() {
        return this.vacmRole;
    }

    @Override
    public boolean isResetRequested() {
        return this.resetRequested;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DHKickstartParametersImpl that = (DHKickstartParametersImpl)o;
        if (!this.getSecurityName().equals((Object)that.getSecurityName())) {
            return false;
        }
        return this.getPublicKey().equals((Object)that.getPublicKey());
    }

    public int hashCode() {
        int result = this.getSecurityName().hashCode();
        result = 31 * result + this.getPublicKey().hashCode();
        return result;
    }

    public String toString() {
        return "DHKickstartParametersImpl{securityName=" + this.securityName + ", publicKey=" + this.publicKey + ", authenticationProtocol=" + this.authenticationProtocol + ", privacyProtocol=" + this.privacyProtocol + ", vacmRole='" + this.vacmRole + "', resetRequested=" + this.resetRequested + "}";
    }

    public static List<DHKickstartParameters> readFromProperties(String propertyPrefix, Properties properties) {
        ArrayList<DHKickstartParameters> kickstartParameters = new ArrayList<DHKickstartParameters>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String privProtocol;
            if (!entry.getKey().toString().startsWith(propertyPrefix + "dh.publicKey.")) continue;
            String userName = entry.getKey().toString().substring(propertyPrefix.length() + "dh.publicKey.".length());
            String publicKeyHex = entry.getValue().toString();
            DHKickstartParametersImpl dhKickstartParameters = new DHKickstartParametersImpl(new OctetString(userName), OctetString.fromString((String)publicKeyHex, (int)16));
            String authProtocol = properties.getProperty(propertyPrefix + "dh.authProtocol." + userName, null);
            if (authProtocol != null) {
                dhKickstartParameters.authenticationProtocol = new OID(authProtocol);
            }
            if ((privProtocol = properties.getProperty(propertyPrefix + "dh.privProtocol." + userName, null)) != null) {
                dhKickstartParameters.privacyProtocol = new OID(privProtocol);
            }
            dhKickstartParameters.vacmRole = properties.getProperty(propertyPrefix + "dh.vacm.role." + userName, null);
            dhKickstartParameters.resetRequested = Boolean.parseBoolean(properties.getProperty(propertyPrefix + "dh.reset." + userName, null));
            kickstartParameters.add(dhKickstartParameters);
        }
        return kickstartParameters;
    }
}

