/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableCellInfo;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.AutonomousType;
import org.snmp4j.agent.mo.snmp.KeyChange;
import org.snmp4j.agent.mo.snmp.RowPointer;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpAdminString;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.TestAndIncr;
import org.snmp4j.agent.mo.snmp.UsmKeyChange;
import org.snmp4j.agent.mo.snmp.UsmOwnKeyChange;
import org.snmp4j.agent.mo.snmp.dh.SnmpUsmDhObjectsMib;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.UsmUserEvent;
import org.snmp4j.event.UsmUserListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecretOctetString;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.security.dh.DHOperations;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class UsmMIB
implements MOGroup,
CounterListener,
MOValueValidationListener,
MOTableRowListener<UsmTableRow>,
UsmUserListener {
    private static final LogAdapter logger = LogFactory.getLogger(UsmMIB.class);
    public static final OID noAuthProtocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 1, 1});
    public static final OID noPrivProtocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 2, 1});
    public static final OID usmUserSpinLockOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 2, 1, 0});
    public static final OID usmUserEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 2, 2, 1});
    public static final int colUsmUserSecurityName = 0;
    public static final int colUsmUserCloneFrom = 1;
    public static final int colUsmUserAuthProtocol = 2;
    public static final int colUsmUserAuthKeyChange = 3;
    public static final int colUsmUserOwnAuthKeyChange = 4;
    public static final int colUsmUserPrivProtocol = 5;
    public static final int colUsmUserPrivKeyChange = 6;
    public static final int colUsmUserOwnPrivKeyChange = 7;
    public static final int colUsmUserPublic = 8;
    public static final int colUsmUserStorageType = 9;
    public static final int colUsmUserStatus = 10;
    public static final int colUsmUserAuthPassword = 11;
    public static final int colUsmUserPrivPassword = 12;
    public static final int colUsmUserLocalizationEngineID = 13;
    public static final int colUsmUserAuthKey = 14;
    public static final int colUsmUserPrivKey = 15;
    private static final int[][] keyChangeColumns = new int[][]{{3, 4}, {6, 7}};
    private USM usm;
    private SecurityProtocols securityProtocols;
    private static final OID usmStatsPrefix = new OID(SnmpConstants.usmStatsUnsupportedSecLevels.getValue(), 0, SnmpConstants.usmStatsUnsupportedSecLevels.size() - 2);
    private static final OID[] usmStatOIDs = new OID[]{SnmpConstants.usmStatsUnsupportedSecLevels, SnmpConstants.usmStatsNotInTimeWindows, SnmpConstants.usmStatsUnknownUserNames, SnmpConstants.usmStatsUnknownEngineIDs, SnmpConstants.usmStatsWrongDigests, SnmpConstants.usmStatsDecryptionErrors};
    private MOScalar<?>[] usmStats;
    private TestAndIncr usmUserSpinLock;
    private DefaultMOTable<UsmTableRow, MOColumn, DefaultMOMutableTableModel<UsmTableRow>> usmUserEntry;
    private UsmTableModel usmUserTableModel;
    private volatile boolean usmEventProcessing;

    public UsmMIB(USM usm, SecurityProtocols securityProtocols) {
        this.usm = usm;
        this.securityProtocols = securityProtocols;
        usm.getCounterSupport().addCounterListener((CounterListener)this);
        this.createUsmStats();
        this.createUsmUser();
    }

    private void createUsmUser() {
        this.usmUserSpinLock = new TestAndIncr(usmUserSpinLockOID);
        MOTableSubIndex[] usmUserSubIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 5, 32), new MOTableSubIndex(4, 1, 32)};
        MOColumn[] usmUserColumns = new MOColumn[]{new SnmpAdminString(3, MOAccessImpl.ACCESS_READ_ONLY, null, false), new UsmRowPointer(4, MOAccessImpl.ACCESS_READ_CREATE, null, true), new AutonomousType(5, MOAccessImpl.ACCESS_READ_CREATE, noAuthProtocol, true), new UsmKeyChange(6, MOAccessImpl.ACCESS_READ_CREATE, 0), new UsmOwnKeyChange(7, MOAccessImpl.ACCESS_READ_CREATE, 0), new AutonomousType(8, MOAccessImpl.ACCESS_READ_CREATE, noPrivProtocol, true), new UsmKeyChange(9, MOAccessImpl.ACCESS_READ_CREATE, 1), new UsmOwnKeyChange(10, MOAccessImpl.ACCESS_READ_CREATE, 1), new SnmpAdminString(11, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(), true, 0, 32), new StorageType(12, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(13, MOAccessImpl.ACCESS_READ_CREATE)};
        MOTableIndex usmUserIndex = new MOTableIndex(usmUserSubIndexes, false);
        this.usmUserTableModel = new UsmTableModel(usmUserIndex);
        this.usmUserEntry = new DefaultMOTable<UsmTableRow, MOColumn, DefaultMOMutableTableModel<UsmTableRow>>(usmUserEntryOID, usmUserIndex, usmUserColumns, (DefaultMOMutableTableModel)this.usmUserTableModel){

            @Override
            protected void fireRowChanged(MOTableRowEvent<UsmTableRow> event) {
                if (this.moTableRowListeners != null) {
                    List listeners = this.moTableRowListeners;
                    for (MOTableRowListener<UsmTableRow> mOTableRowListener : listeners) {
                        if (UsmMIB.this.usmEventProcessing && mOTableRowListener instanceof UsmMIB) continue;
                        mOTableRowListener.rowChanged(event);
                    }
                }
            }

            @Override
            protected Variable[] restoreRawDataForHiddenColumns(Variable[] rawValues, int startIndexHidden) {
                for (int i = startIndexHidden; i < rawValues.length; ++i) {
                    if (!(rawValues[i] instanceof OctetString) || i == 13) continue;
                    rawValues[i] = SecretOctetString.fromOctetString((OctetString)((OctetString)rawValues[i]));
                }
                return super.restoreRawDataForHiddenColumns(rawValues, startIndexHidden);
            }
        };
        ((AutonomousType)usmUserColumns[2]).addMOValueValidationListener(this);
        ((AutonomousType)usmUserColumns[5]).addMOValueValidationListener(this);
        ((UsmRowPointer)usmUserColumns[1]).setTargetTable(this.usmUserEntry);
        this.usmUserEntry.addMOTableRowListener(this);
    }

    public OID getProtocolForKeyChange(Request<?, ?, ?> request, OID rowIndex, DHOperations.KeyType keyType) {
        DefaultMOTable.ChangeSet changeSet = this.getUsmUserEntry().getRowPreview(request, rowIndex);
        OID cloneFrom = (OID)changeSet.getValue(1);
        if (cloneFrom != null && cloneFrom.size() > usmUserEntryOID.size()) {
            OID cloneRowIndex = new OID(cloneFrom.getValue(), usmUserEntryOID.size() + 1, cloneFrom.size() - (usmUserEntryOID.size() + 1));
            DefaultMOTable.ChangeSet changeSetClone = this.getUsmUserEntry().getRowPreview(request, cloneRowIndex);
            return this.getProtocolForKeyChangeWithoutCloneFrom(changeSetClone, keyType);
        }
        return this.getProtocolForKeyChangeWithoutCloneFrom(changeSet, keyType);
    }

    private OID getProtocolForKeyChangeWithoutCloneFrom(DefaultMOTable.ChangeSet changeSet, DHOperations.KeyType keyType) {
        OID result = null;
        switch (keyType) {
            case authKeyChange: {
                result = (OID)changeSet.getValue(2);
                break;
            }
            case privKeyChange: {
                result = (OID)changeSet.getValue(5);
            }
        }
        if (noAuthProtocol.equals(result) || noPrivProtocol.equals((Object)result)) {
            return null;
        }
        return result;
    }

    private void createUsmStats() {
        this.usmStats = new MOScalar[usmStatOIDs.length];
        for (int i = 0; i < this.usmStats.length; ++i) {
            this.usmStats[i] = new MOScalar<Counter32>(usmStatOIDs[i], MOAccessImpl.ACCESS_READ_ONLY, new Counter32(0L));
        }
    }

    public SecurityProtocols getSecurityProtocols() {
        return this.securityProtocols;
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        for (MOScalar<?> usmStat : this.usmStats) {
            server.register(usmStat, context);
        }
        server.register(this.usmUserSpinLock, context);
        server.register(this.usmUserEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        for (MOScalar<?> usmStat : this.usmStats) {
            server.unregister(usmStat, context);
        }
        server.unregister(this.usmUserSpinLock, context);
        server.unregister(this.usmUserEntry, context);
    }

    public void incrementCounter(CounterEvent event) {
        if (event.getOid().startsWith(usmStatsPrefix) && event.getOid().size() > usmStatsPrefix.size()) {
            Counter32 current = (Counter32)this.usmStats[event.getOid().get(usmStatsPrefix.size()) - 1].getValue();
            current.increment();
            event.setCurrentValue((Variable)((Counter32)current.clone()));
        }
    }

    @Override
    public void validate(MOValueValidationEvent validationEvent) {
        if (validationEvent.getSource() instanceof MOColumn) {
            MOColumn col = (MOColumn)validationEvent.getSource();
            switch (col.getColumnID() - 4) {
                case 2: {
                    AuthenticationProtocol authProtocol;
                    OID value = (OID)validationEvent.getNewValue();
                    if (noAuthProtocol.equals((Object)value) || (authProtocol = this.securityProtocols.getAuthenticationProtocol((OID)validationEvent.getNewValue())) != null) break;
                    validationEvent.setValidationStatus(10);
                    break;
                }
                case 5: {
                    PrivacyProtocol privProtocol;
                    OID value = (OID)validationEvent.getNewValue();
                    if (noPrivProtocol.equals((Object)value) || (privProtocol = SecurityProtocols.getInstance().getPrivacyProtocol(value)) != null) break;
                    validationEvent.setValidationStatus(10);
                    break;
                }
            }
        }
    }

    private Variable[] getValuesFromUsmUser(UsmUserEntry user) {
        Variable[] row = new Variable[this.usmUserEntry.getColumnCount() + 5];
        int n = 0;
        row[n++] = user.getUsmUser().getSecurityName();
        row[n++] = null;
        row[n++] = user.getUsmUser().getAuthenticationProtocol();
        row[n++] = null;
        row[n++] = null;
        row[n++] = user.getUsmUser().getPrivacyProtocol();
        row[n++] = null;
        row[n++] = null;
        row[n++] = new OctetString();
        row[n++] = new Integer32(user.getStorageType().getSmiValue());
        row[n++] = new Integer32(1);
        row[n++] = user.getAuthenticationKey() == null ? user.getUsmUser().getAuthenticationPassphrase() : null;
        row[n++] = user.getPrivacyKey() == null ? user.getUsmUser().getPrivacyPassphrase() : null;
        row[n++] = user.getUsmUser().getLocalizationEngineID();
        row[n++] = user.getAuthenticationKey() == null ? null : new SecretOctetString(user.getAuthenticationKey());
        row[n] = user.getPrivacyKey() == null ? null : new SecretOctetString(user.getPrivacyKey());
        return row;
    }

    private OID createIndex(OctetString engineID, OctetString userName) {
        if (engineID == null || engineID.length() == 0) {
            engineID = this.usm.getLocalEngineID();
        }
        OID index = engineID.toSubIndex(false);
        index.append(userName.toSubIndex(false));
        return index;
    }

    public synchronized void usmUserChange(UsmUserEvent event) {
        if (event.getUser() != null && event.getUser().getOwnerReference() == this) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Ignored UsmUserEvent=" + event + " because event triggered by this instance")));
            }
            return;
        }
        this.usmEventProcessing = true;
        switch (event.getType()) {
            case 1: {
                Variable[] values = this.getValuesFromUsmUser(event.getUser());
                OID index = this.createIndex(event.getUser().getEngineID(), event.getUser().getUserName());
                UsmTableRow row = this.usmUserEntry.createRow(index, values);
                this.usmUserEntry.addRow(row);
                break;
            }
            case 2: {
                if (event.getUser() == null) {
                    this.usmUserTableModel.clear();
                    break;
                }
                OID index = this.createIndex(event.getUser().getEngineID(), event.getUser().getUserName());
                this.usmUserEntry.removeRow(index);
                break;
            }
            case 3: {
                OID index = this.createIndex(event.getUser().getEngineID(), event.getUser().getUserName());
                UsmTableRow row = (UsmTableRow)this.usmUserEntry.getModel().getRow(index);
                if (row != null) {
                    UsmUser user = event.getUser().getUsmUser();
                    row.setValue(2, (Variable)user.getAuthenticationProtocol());
                    row.setValue(5, (Variable)user.getPrivacyProtocol());
                    row.setValue(11, (Variable)SecretOctetString.fromOctetString((OctetString)user.getAuthenticationPassphrase()));
                    row.setValue(12, (Variable)SecretOctetString.fromOctetString((OctetString)user.getPrivacyPassphrase()));
                    row.setValue(13, (Variable)user.getLocalizationEngineID());
                    row.setValue(14, (Variable)(event.getUser().getAuthenticationKey() == null ? null : new SecretOctetString(event.getUser().getAuthenticationKey())));
                    row.setValue(15, (Variable)(event.getUser().getPrivacyKey() == null ? null : new SecretOctetString(event.getUser().getPrivacyKey())));
                    break;
                }
                Variable[] values = this.getValuesFromUsmUser(event.getUser());
                row = this.usmUserEntry.createRow(index, values);
                this.usmUserEntry.addRow(row);
                break;
            }
        }
        this.usmEventProcessing = false;
    }

    private static boolean isKeyChanged(MOTableRow changeSet, int keyChangeColumn) {
        OctetString value = (OctetString)changeSet.getValue(keyChangeColumn);
        return value != null && value.length() > 0;
    }

    private static boolean isKeyChanged(MOTableRow changeSet) {
        return UsmMIB.isKeyChanged(changeSet, 4) || UsmMIB.isKeyChanged(changeSet, 3) || UsmMIB.isKeyChanged(changeSet, 7) || UsmMIB.isKeyChanged(changeSet, 6);
    }

    private SnmpConstants.StorageTypeEnum getStorageType(MOTableRow changeSet) {
        Variable storageTypeValue = changeSet.getValue(9);
        if (storageTypeValue != null) {
            return StorageType.StorageTypeEnum.toSnmpConstantsStorageTypeEnum(storageTypeValue.toInt());
        }
        return null;
    }

    public DefaultMOTable<UsmTableRow, MOColumn, DefaultMOMutableTableModel<UsmTableRow>> getUsmUserEntry() {
        return this.usmUserEntry;
    }

    @Override
    public synchronized void rowChanged(MOTableRowEvent<UsmTableRow> event) {
        UsmUserEntry entry;
        UsmTableRow row = event.getRow();
        if (event.getType() == 1 && event.getOriginType() == MOTableRowEvent.OriginType.internal) {
            if (!(row.containsHiddenValues() || row.getAuthProtocolOID(row) == null && row.getPrivProtocolOID(row) == null)) {
                logger.warn((Serializable)((Object)("Cannot add user with index '" + event.getRow().getIndex() + "' to the USM from USM-MIB because key information is missing")));
                return;
            }
            UsmUserEntry entry2 = row.getUserEntry();
            if (entry2 != null) {
                this.usm.removeAllUsers(entry2.getUserName(), entry2.getEngineID());
            }
            this.addOrUpdateUsmUserFromRow(row, false);
        } else if (event.getOriginType() == MOTableRowEvent.OriginType.internal && event.getType() == 4) {
            this.addOrUpdateUsmUserFromRow(row, true);
        } else if (event.getType() == 3 && (entry = row.getUserEntry()) != null) {
            this.usm.removeAllUsers(entry.getUserName(), entry.getEngineID());
        }
    }

    public static UsmUserEntry localizeUser(OctetString securityName, OctetString localizationEngineID, OID authProtocol, OctetString authPassphrase, OID privProtocol, OctetString privPassphrase, SecurityProtocols securityProtocols) {
        SecretOctetString newAuthKey = authProtocol != null && authPassphrase != null ? new SecretOctetString(securityProtocols.passwordToKey(authProtocol, authPassphrase, localizationEngineID.getValue())) : null;
        SecretOctetString newPrivKey = authProtocol != null && privProtocol != null && privPassphrase != null ? new SecretOctetString(securityProtocols.passwordToKey(privProtocol, authProtocol, privPassphrase, localizationEngineID.getValue())) : null;
        return new UsmUserEntry(localizationEngineID.getValue(), securityName, authProtocol, newAuthKey == null ? null : newAuthKey.getValue(), privProtocol, newPrivKey == null ? null : newPrivKey.getValue());
    }

    private void addOrUpdateUsmUserFromRow(UsmTableRow row, boolean update) {
        OctetString[] idxValues = row.getIndexValues();
        OctetString engineID = idxValues[0];
        OctetString securityName = idxValues[1];
        try {
            if (row.size() > 13 && row.getCachedValue(11) != null) {
                UsmUserEntry usmUserEntry;
                if (update || row.getCachedValue(14) == null) {
                    usmUserEntry = UsmMIB.localizeUser(securityName, engineID, row.getAuthProtocolOID(row), (OctetString)row.getCachedValue(11), row.getPrivProtocolOID(row), (OctetString)row.getCachedValue(12), this.securityProtocols);
                    row.setValue(14, (Variable)(usmUserEntry.getAuthenticationKey() == null ? null : new SecretOctetString(usmUserEntry.getAuthenticationKey())));
                    row.setValue(15, (Variable)(usmUserEntry.getPrivacyKey() == null ? null : new SecretOctetString(usmUserEntry.getPrivacyKey())));
                } else {
                    OctetString authKey = (OctetString)row.getCachedValue(14);
                    OctetString privKey = (OctetString)row.getCachedValue(15);
                    usmUserEntry = new UsmUserEntry(engineID.getValue(), securityName, row.getAuthProtocolOID(row), authKey == null ? null : authKey.getValue(), row.getPrivProtocolOID(row), privKey == null ? null : privKey.getValue());
                }
                row.setValue(11, null);
                row.setValue(12, null);
                usmUserEntry.setOwnerReference((Object)this);
                if (update) {
                    this.usm.updateUser(usmUserEntry);
                } else {
                    this.usm.addUsmUserEntry(usmUserEntry);
                }
                usmUserEntry.setOwnerReference(null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)((update ? "Updated" : "Added") + " user " + securityName + " and removed passwords from row")));
                }
            } else if (row.size() > 15) {
                OctetString authKey = (OctetString)row.getCachedValue(14);
                OctetString privKey = (OctetString)row.getCachedValue(15);
                UsmUserEntry usmUserEntry = new UsmUserEntry(engineID.getValue(), securityName, row.getAuthProtocolOID(row), authKey == null ? null : authKey.getValue(), row.getPrivProtocolOID(row), privKey == null ? null : privKey.getValue());
                usmUserEntry.setOwnerReference((Object)this);
                if (update) {
                    this.usm.updateUser(usmUserEntry);
                } else {
                    this.usm.addUsmUserEntry(usmUserEntry);
                }
                usmUserEntry.setOwnerReference(null);
            } else {
                logger.warn((Serializable)((Object)("Cannot " + (update ? "update" : "add") + " user '" + idxValues[1] + "' to the USM from USM-MIB because key information is missing")));
            }
        }
        catch (NullPointerException npe) {
            logger.error((CharSequence)("Cannot add/update user '" + idxValues[1] + "' to USM because auth/priv protocol not available."), (Throwable)npe);
        }
    }

    class UsmRowPointer
    extends RowPointer {
        public UsmRowPointer(int columnID, MOAccess access, OID defaultValue, boolean mutableInService) {
            super(columnID, access, defaultValue, mutableInService);
        }

        @Override
        public void prepare(SubRequest<?> subRequest, MOTableRow row, MOTableRow changeSet, int column) {
            super.prepare(subRequest, row, changeSet, column);
            if (!subRequest.hasError()) {
                OID rowPointer = (OID)subRequest.getVariableBinding().getVariable();
                MOTableCellInfo cell = this.getTargetTable().getCellInfo(rowPointer);
                if (cell.getIndex().equals((Object)row.getIndex())) {
                    subRequest.getStatus().setErrorStatus(12);
                }
            }
        }

        public OID getValue(MOTableRow row, int column) {
            return SnmpConstants.zeroDotZero;
        }
    }

    public class UsmTableModel
    extends DefaultMOMutableTableModel<UsmTableRow> {
        private final MOTableIndex indexDef;

        public UsmTableModel(MOTableIndex indexDef) {
            this.indexDef = indexDef;
        }

        @Override
        public UsmTableRow createRow(OID index, Variable[] values) {
            if (values.length < 16) {
                Variable[] h = new Variable[16];
                System.arraycopy(values, 0, h, 0, values.length);
                values = h;
            }
            return new UsmTableRow(this, index, values);
        }

        public MOTableIndex getIndexDef() {
            return this.indexDef;
        }
    }

    public class UsmTableRow
    extends DefaultMOMutableRow2PC {
        private final UsmTableModel tableModel;
        private boolean cloned;

        public UsmTableRow(UsmTableModel model, OID index, Variable[] values) {
            super(index, values);
            this.cloned = false;
            this.tableModel = model;
        }

        public void setCloned(boolean cloned) {
            this.cloned = cloned;
        }

        public boolean isCloned() {
            return this.cloned;
        }

        public MOTableIndex getIndexDef() {
            return this.tableModel.getIndexDef();
        }

        public AuthenticationProtocol getAuthProtocol(MOTableRow changeSet) {
            OID authOID = this.getAuthProtocolOID(changeSet);
            return UsmMIB.this.securityProtocols.getAuthenticationProtocol(authOID);
        }

        public PrivacyProtocol getPrivProtocol(MOTableRow changeSet) {
            OID privOID = this.getPrivProtocolOID(changeSet);
            return UsmMIB.this.securityProtocols.getPrivacyProtocol(privOID);
        }

        public OID getPrivProtocolOID(MOTableRow preparedChanges) {
            OID privID = null;
            if (preparedChanges.getValue(1) == null) {
                privID = (OID)preparedChanges.getValue(5);
            }
            if (privID == null) {
                privID = (OID)this.getValue(5);
            }
            if (noPrivProtocol.equals((Object)privID)) {
                privID = null;
            }
            return privID;
        }

        @Override
        public void prepare(SubRequest<?> subRequest, MOTableRow preparedChanges, int column) {
            switch (column) {
                case 2: {
                    OID authProtocol = (OID)subRequest.getVariableBinding().getVariable();
                    if (!authProtocol.equals((Object)noAuthProtocol)) {
                        subRequest.getStatus().setErrorStatus(12);
                        break;
                    }
                    OID privProtocol = null;
                    Variable privProtocolVariable = preparedChanges.getValue(5);
                    if (privProtocolVariable instanceof OID) {
                        privProtocol = (OID)privProtocolVariable;
                    } else if (privProtocolVariable == null) {
                        privProtocol = (OID)this.getValue(5);
                    }
                    if (privProtocol != null && privProtocol.equals((Object)noPrivProtocol)) break;
                    subRequest.getStatus().setErrorStatus(12);
                    break;
                }
                case 5: {
                    OID privProtocol = (OID)subRequest.getVariableBinding().getVariable();
                    if (privProtocol.equals((Object)noPrivProtocol)) break;
                    subRequest.getStatus().setErrorStatus(12);
                    break;
                }
            }
        }

        private OID getCloneFromIndex(MOTableRow changeSet) {
            OID cloneFrom = (OID)changeSet.getValue(1);
            if (cloneFrom == null) {
                cloneFrom = (OID)this.getValue(1);
            }
            if (cloneFrom == null || cloneFrom.size() <= usmUserEntryOID.size()) {
                return null;
            }
            return new OID(cloneFrom.getValue(), usmUserEntryOID.size() + 1, cloneFrom.size() - (usmUserEntryOID.size() + 1));
        }

        @Override
        public synchronized void commitRow(SubRequest<?> subRequest, MOTableRow changeSet) {
            UsmUserEntry oldUserEntry;
            if (subRequest.hasError()) {
                return;
            }
            Variable[] indexValues = this.getIndexDef().getIndexValues(this.getIndex());
            OctetString engineID = (OctetString)indexValues[0];
            OctetString userName = (OctetString)indexValues[1];
            OID cloneFromUserIndex = this.getCloneFromIndex(changeSet);
            if (cloneFromUserIndex != null) {
                Variable[] cloneFromIndexValues = this.getIndexDef().getIndexValues(cloneFromUserIndex);
                OctetString cloneFromEngineID = (OctetString)cloneFromIndexValues[0];
                OctetString cloneFromUserName = (OctetString)cloneFromIndexValues[1];
                oldUserEntry = UsmMIB.this.usm.getUser(cloneFromEngineID, cloneFromUserName);
                if (oldUserEntry != null) {
                    this.setValue(2, (Variable)oldUserEntry.getUsmUser().getAuthenticationProtocol());
                    this.setValue(5, (Variable)oldUserEntry.getUsmUser().getPrivacyProtocol());
                }
            } else {
                oldUserEntry = UsmMIB.this.usm.getUser(engineID, userName);
            }
            SnmpUsmDhObjectsMib.UsmDHUserKeyEntryRow dhUsmUserEntry = (SnmpUsmDhObjectsMib.UsmDHUserKeyEntryRow)UsmMIB.this.usmUserEntry.getDependentTableRow(SnmpUsmDhObjectsMib.oidUsmDHUserKeyEntry, this.getIndex());
            Integer32 newStatus = (Integer32)changeSet.getValue(10);
            if (newStatus != null && (newStatus.getValue() == 1 || newStatus.getValue() == 4) || this.getValue(10) != null && ((Integer32)this.getValue(10)).getValue() == 1 && (UsmMIB.isKeyChanged(changeSet) || dhUsmUserEntry != null && dhUsmUserEntry.isKeyChangePending())) {
                if (cloneFromUserIndex != null) {
                    this.setUserObject(oldUserEntry);
                }
                if (oldUserEntry == null) {
                    subRequest.getStatus().setErrorStatus(14);
                    return;
                }
                OctetString[] newKeys = new OctetString[2];
                OctetString[] oldKeys = new OctetString[2];
                AuthenticationProtocol a = this.getAuthProtocol(changeSet);
                if (a != null) {
                    for (int p = 0; p < 2; ++p) {
                        byte[] newKeyValue;
                        byte[] k = p == 0 ? oldUserEntry.getAuthenticationKey() : oldUserEntry.getPrivacyKey();
                        oldKeys[p] = null;
                        if (k == null) continue;
                        oldKeys[p] = new SecretOctetString(k);
                        for (int i = 0; i < keyChangeColumns[p].length; ++i) {
                            OctetString keyChange = (OctetString)this.getValue(keyChangeColumns[p][i]);
                            if (keyChange == null || keyChange.length() <= 0) continue;
                            int keyLength = a.getDigestLength();
                            OctetString doKey = oldKeys[p];
                            if (p == 1) {
                                PrivacyProtocol privProtocol = this.getPrivProtocol(changeSet);
                                keyLength = privProtocol.getMaxKeyLength();
                            }
                            newKeys[p] = KeyChange.changeKey(a, doKey, keyChange, keyLength);
                            break;
                        }
                        if (newKeys[p] != null || dhUsmUserEntry == null) continue;
                        byte[] byArray = newKeyValue = p == 0 ? dhUsmUserEntry.getNewAuthKey() : dhUsmUserEntry.getNewPrivKey();
                        if (newKeyValue == null) continue;
                        newKeys[p] = new SecretOctetString(newKeyValue);
                    }
                }
                UsmUserEntry newEntry = new UsmUserEntry(engineID.getValue(), userName, this.getAuthProtocolOID(changeSet), (byte[])(newKeys[0] == null ? (Object)(oldKeys[0] == null ? null : oldKeys[0].getValue()) : newKeys[0].getValue()), this.getPrivProtocolOID(changeSet), (byte[])(newKeys[1] == null ? (Object)(oldKeys[1] == null ? null : oldKeys[1].getValue()) : newKeys[1].getValue()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Modifying user keys from old " + Arrays.asList(oldKeys) + " to new " + Arrays.asList(newKeys))));
                }
                newEntry.setStorageType(UsmMIB.this.getStorageType(changeSet));
                UsmMIB.this.usm.updateUser(newEntry);
                this.setValue(1, null);
                this.clearKeyChangeObjects();
                if (dhUsmUserEntry != null) {
                    dhUsmUserEntry.clearDHKeyChange();
                }
            }
            if (newStatus != null) {
                switch (newStatus.getValue()) {
                    case 4: 
                    case 5: {
                        this.setValue(0, (Variable)userName);
                    }
                }
            }
        }

        public OID getAuthProtocolOID(MOTableRow changeSet) {
            OID authID = null;
            if (changeSet.getValue(1) == null) {
                authID = (OID)changeSet.getValue(2);
            }
            if (authID == null) {
                authID = (OID)this.getValue(2);
            }
            if (noAuthProtocol.equals((Object)authID)) {
                authID = null;
            }
            return authID;
        }

        @Override
        public void cleanupRow(SubRequest<?> subRequest, DefaultMOTable.ChangeSet changeSet) {
            this.setUserObject(null);
        }

        @Override
        public void undoRow(SubRequest<?> subRequest, DefaultMOTable.ChangeSet changeSet) {
            if (this.getUserObject() != null) {
                UsmMIB.this.usm.updateUser((UsmUserEntry)this.getUserObject());
            }
        }

        Variable getCachedValue(int column) {
            return super.getValue(column);
        }

        @Override
        public Variable getValue(int column) {
            UsmUserEntry userEntry;
            if (column > 10 && (userEntry = this.getUserEntry()) != null) {
                switch (column) {
                    case 11: {
                        if (userEntry.getUsmUser().isLocalized()) {
                            this.setValue(column, null);
                            break;
                        }
                        this.setValue(column, (Variable)userEntry.getUsmUser().getAuthenticationPassphrase());
                        break;
                    }
                    case 12: {
                        if (userEntry.getUsmUser().isLocalized()) {
                            this.setValue(column, null);
                            break;
                        }
                        this.setValue(column, (Variable)userEntry.getUsmUser().getPrivacyPassphrase());
                        break;
                    }
                    case 13: {
                        this.setValue(column, (Variable)(userEntry.getUsmUser().isLocalized() ? userEntry.getUsmUser().getLocalizationEngineID() : null));
                        break;
                    }
                    case 14: {
                        byte[] key = userEntry.getAuthenticationKey();
                        this.setValue(column, (Variable)(key == null ? null : new SecretOctetString(key)));
                        break;
                    }
                    case 15: {
                        byte[] key = userEntry.getPrivacyKey();
                        this.setValue(column, (Variable)(key == null ? null : new SecretOctetString(key)));
                        break;
                    }
                }
            }
            return super.getValue(column);
        }

        public boolean containsHiddenValues() {
            for (int i = 11; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                return true;
            }
            return false;
        }

        private UsmUserEntry getUserEntry() {
            Variable[] indexValues = this.getIndexDef().getIndexValues(this.getIndex());
            OctetString engineID = (OctetString)indexValues[0];
            OctetString userName = (OctetString)indexValues[1];
            return UsmMIB.this.usm.getUser(engineID, userName);
        }

        private OctetString[] getIndexValues() {
            Variable[] indexValues = this.getIndexDef().getIndexValues(this.getIndex());
            OctetString[] idxValues = new OctetString[]{(OctetString)indexValues[0], (OctetString)indexValues[1]};
            return idxValues;
        }

        public void clearKeyChangeObjects() {
            this.setValue(3, null);
            this.setValue(4, null);
            this.setValue(6, null);
            this.setValue(7, null);
        }
    }
}

