/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.unix;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.SMIAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.TransportStateListener;

public class UnixDomainAddress
extends SMIAddress {
    private static final long serialVersionUID = -6151626307033468271L;
    private UnixDomainSocketAddress unixDomainAddress;
    private transient List<TransportStateListener> transportStateListeners;

    public UnixDomainAddress() {
    }

    public UnixDomainAddress(Path unixDomainAddress) {
        this.unixDomainAddress = UnixDomainSocketAddress.of(unixDomainAddress);
    }

    public UnixDomainAddress(UnixDomainSocketAddress unixDomainAddress) {
        this.unixDomainAddress = unixDomainAddress;
    }

    public UnixDomainSocketAddress getUnixDomainAddress() {
        return this.unixDomainAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UnixDomainAddress that = (UnixDomainAddress)((Object)o);
        return this.getUnixDomainAddress().equals(that.getUnixDomainAddress());
    }

    public int compareTo(Variable variable) {
        return this.unixDomainAddress.getPath().compareTo(((UnixDomainAddress)variable).unixDomainAddress.getPath());
    }

    public int hashCode() {
        return this.unixDomainAddress.hashCode();
    }

    public int getBERLength() {
        return new OctetString(this.unixDomainAddress.getPath().toString()).getBERLength();
    }

    public void decodeBER(BERInputStream berInputStream) throws IOException {
        OctetString os = new OctetString();
        os.decodeBER(berInputStream);
        this.unixDomainAddress = UnixDomainSocketAddress.of(os.toString());
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        OctetString os = new OctetString(this.unixDomainAddress.toString());
        os.encodeBER(outputStream);
    }

    public int getSyntax() {
        return 4;
    }

    public String toString() {
        return this.unixDomainAddress == null ? "unix:[]" : this.unixDomainAddress.toString();
    }

    public int toInt() {
        throw new UnsupportedOperationException();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        return new UnixDomainAddress(this.unixDomainAddress.getPath());
    }

    public OID toSubIndex(boolean impliedLength) {
        return new OctetString(this.unixDomainAddress.toString()).toSubIndex(impliedLength);
    }

    public void fromSubIndex(OID oid, boolean b) {
        OctetString os = OctetString.fromIndex((OID)oid, (int)0, (boolean)b);
        this.unixDomainAddress = UnixDomainSocketAddress.of(Path.of(os.toString(), new String[0]));
    }

    public boolean isValid() {
        return UnixDomainAddress.isValidUnixDomainSocket(this.unixDomainAddress.getPath());
    }

    private static boolean isValidUnixDomainSocket(Path path) {
        File socketFile = path.getParent().toFile();
        return socketFile.canExecute() && socketFile.canWrite() && socketFile.isDirectory();
    }

    public boolean parseAddress(String s) {
        UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(s);
        if (UnixDomainAddress.isValidUnixDomainSocket(unixDomainSocketAddress.getPath())) {
            this.unixDomainAddress = unixDomainSocketAddress;
            return true;
        }
        return false;
    }

    public void setValue(String s) {
        this.unixDomainAddress = UnixDomainSocketAddress.of(s);
    }

    public void setValue(byte[] bytes) {
        OctetString os = new OctetString(bytes);
        this.unixDomainAddress = UnixDomainSocketAddress.of(os.toString());
    }

    public byte[] toByteArray() {
        return this.unixDomainAddress.toString().getBytes(StandardCharsets.UTF_8);
    }

    public Path getPath() {
        if (this.unixDomainAddress != null) {
            return this.unixDomainAddress.getPath();
        }
        return null;
    }

    public ProtocolFamily getFamily() {
        return StandardProtocolFamily.UNIX;
    }

    public SocketAddress getSocketAddress() {
        return this.unixDomainAddress;
    }
}

