/*
 * Decompiled with CFR 0.152.
 */
package org.softee.management;

import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.softee.management.annotation.Description;
import org.softee.management.annotation.ManagedAttribute;
import org.softee.management.annotation.ManagedOperation;
import org.softee.management.exception.ManagementException;
import org.softee.management.helper.MBeanRegistration;
import org.softee.management.helper.ObjectNameBuilder;

public abstract class AbstractMBean {
    protected static final long NONE = Long.MIN_VALUE;
    private DatatypeFactory dtf;
    private AtomicLong started;
    protected final MBeanRegistration registration;

    public AbstractMBean() throws MalformedObjectNameException {
        ObjectName objectName = new ObjectNameBuilder(this.getClass()).build();
        this.registration = new MBeanRegistration(this, objectName);
        this.initialize();
    }

    public AbstractMBean(String mbeanName) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectNameBuilder(this.getClass()).withName(mbeanName).build();
        this.registration = new MBeanRegistration(this, objectName);
        this.initialize();
    }

    public AbstractMBean(ObjectName objectName) {
        this.registration = new MBeanRegistration(this, objectName);
        this.initialize();
    }

    protected void initialize() {
        try {
            this.dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.resetMBean();
    }

    @ManagedOperation(value=ManagedOperation.Impact.ACTION)
    @Description(value="Reset this MBean's metrics")
    public void resetMBean() {
    }

    public void start() throws ManagementException {
        this.started = new AtomicLong(this.now());
        this.registration.register();
    }

    public void stop() throws ManagementException {
        this.registration.unregister();
    }

    @ManagedAttribute
    @Description(value="The time at which the MBean was started")
    public XMLGregorianCalendar getStarted() {
        return this.date(this.noneAsNull(this.started));
    }

    protected Long noneAsNull(AtomicLong a) {
        long n = a.get();
        return n == Long.MIN_VALUE ? null : Long.valueOf(n);
    }

    protected Long age(Long millis, TimeUnit unit) {
        return millis == null ? null : Long.valueOf(unit.convert(this.now() - millis, TimeUnit.MILLISECONDS));
    }

    protected String dateString(Long millis) {
        return millis != null ? this.date(millis).toXMLFormat() : null;
    }

    protected XMLGregorianCalendar date(Long millis) {
        if (millis == null) {
            return null;
        }
        GregorianCalendar gCal = new GregorianCalendar();
        gCal.setTimeInMillis(millis);
        return this.dtf.newXMLGregorianCalendar(gCal);
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    protected AtomicLong zero() {
        return new AtomicLong();
    }

    protected AtomicLong none() {
        return new AtomicLong(Long.MIN_VALUE);
    }
}

