/*
 * Decompiled with CFR 0.152.
 */
package org.softee.management.helper;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.softee.management.exception.ManagementException;
import org.softee.management.helper.IntrospectedDynamicMBean;
import org.softee.management.helper.ObjectNameBuilder;

public class MBeanRegistration {
    private final Object mBean;
    private final ObjectName mBeanObjectName;
    private final MBeanServer mBeanServer;

    public MBeanRegistration(Object mBean) throws MalformedObjectNameException {
        this(mBean, new ObjectNameBuilder(mBean.getClass()).build());
    }

    public MBeanRegistration(Object mBean, ObjectName mBeanObjectName) {
        this.mBean = mBean;
        this.mBeanObjectName = mBeanObjectName;
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public void register() throws ManagementException {
        try {
            IntrospectedDynamicMBean dynamicMBean = new IntrospectedDynamicMBean(this.mBean);
            this.mBeanServer.registerMBean(dynamicMBean, this.mBeanObjectName);
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    public void unregister() throws ManagementException {
        try {
            this.mBeanServer.unregisterMBean(this.mBeanObjectName);
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }
}

