/*
 * Decompiled with CFR 0.152.
 */
package org.softee.management.samples;

import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import org.softee.management.MessagingMBean;
import org.softee.management.annotation.Description;
import org.softee.management.annotation.MBean;
import org.softee.time.StopWatch;

public class MessageProcesingApplication {
    private static final int PROCESSING_TIME_MILLIS = 1000;
    private MessagingMBean monitor;

    public void run() {
        try {
            this.monitor = new DemoMessagingMBean();
            this.start();
            this.runFor(1, TimeUnit.DAYS, 1000);
            this.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() throws Exception {
        this.monitor.start();
    }

    public void shutdown() throws Exception {
        this.monitor.stop();
    }

    public static void main(String[] args) {
        new MessageProcesingApplication().run();
    }

    public void runFor(int value, TimeUnit tu, int averageProcessingTimeMillis) {
        System.out.println("MBean demo running for " + value + " " + (Object)((Object)tu));
        int count = 0;
        StopWatch runtime = new StopWatch();
        try {
            while (runtime.elapsed(tu) < (long)value) {
                int delayMillis = (int)(Math.random() * 2.0 * (double)averageProcessingTimeMillis);
                this.monitor.notifyInput();
                Thread.sleep(delayMillis);
                if (++count % 10 == 0) {
                    this.monitor.notifyFailed(this.dummyThrowable(count));
                    this.log(count, "failed");
                    continue;
                }
                this.monitor.notifyOutput();
                this.log(count, null);
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    private void log(int count, String suffix) {
        String msgSuffix = suffix == null ? "" : " (" + suffix + ")";
        String msg = String.format("message #%d%s", count, msgSuffix);
        System.out.println(msg);
    }

    private Throwable dummyThrowable(int count) {
        RuntimeException e = new RuntimeException("Wrapped failure, message #" + count);
        return new Exception("Failed message #" + count, e);
    }

    @MBean(objectName="org.softee:type=Demo,application=ESB,name=MessageMonitor")
    @Description(value="An MBean created to show the ease of use of the pojo-mbean")
    private static class DemoMessagingMBean
    extends MessagingMBean {
    }
}

