/*
 * Decompiled with CFR 0.152.
 */
package org.softee.time;

import java.util.concurrent.TimeUnit;

public class StopWatch {
    private State state = State.NEW;
    long nanoTimeStart;
    long nanoTimeStop;

    public StopWatch() {
        this.start();
    }

    public synchronized void start() {
        this.state = State.RUNNING;
        this.nanoTimeStart = System.nanoTime();
    }

    public synchronized void stop() {
        if (this.state != State.STOPPED) {
            this.nanoTimeStop = System.nanoTime();
            this.state = State.STOPPED;
        }
    }

    public synchronized long elapsedMillis() {
        return this.elapsed(TimeUnit.MILLISECONDS);
    }

    public synchronized long elapsed(TimeUnit unit) {
        long elapsed;
        switch (this.state) {
            case RUNNING: {
                elapsed = System.nanoTime() - this.nanoTimeStart;
                break;
            }
            case STOPPED: {
                elapsed = this.nanoTimeStop - this.nanoTimeStart;
                break;
            }
            default: {
                throw new IllegalStateException("State: " + this.state.toString());
            }
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        return unit.convert(elapsed, TimeUnit.NANOSECONDS);
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public String toString() {
        return "StopWatch " + (Object)((Object)this.state) + " @ " + this.elapsed(TimeUnit.MILLISECONDS) + "ms";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NEW,
        STOPPED,
        RUNNING;

    }
}

