/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.model.plugins;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PluginUtil {
    public static boolean customIsEqualNode(Node left, Node right) {
        Node child2;
        if (left == right) {
            return true;
        }
        if (left.getNodeType() != right.getNodeType()) {
            return false;
        }
        if (left.getNodeName() == null && right.getNodeName() != null) {
            return false;
        }
        if (left.getLocalName() == null ? right.getLocalName() != null : !left.getLocalName().equals(right.getLocalName())) {
            return false;
        }
        if (left.getNamespaceURI() == null ? right.getNamespaceURI() != null : !left.getNamespaceURI().equals(right.getNamespaceURI())) {
            return false;
        }
        if (left.getNodeValue() == null ? right.getNodeValue() != null : !left.getNodeValue().equals(right.getNodeValue())) {
            return false;
        }
        boolean hasAttrs = left.hasAttributes();
        if (hasAttrs != right.hasAttributes()) {
            return false;
        }
        if (hasAttrs) {
            NamedNodeMap map1 = left.getAttributes();
            NamedNodeMap map2 = right.getAttributes();
            if (PluginUtil.getLengthWithoutNamespaceDeclaration(map1) != PluginUtil.getLengthWithoutNamespaceDeclaration(map2)) {
                return false;
            }
            int len = map1.getLength();
            for (int i = 0; i < len; ++i) {
                Node n1 = map1.item(i);
                if (PluginUtil.isAttributeANamespaceDeclaration(n1)) continue;
                boolean equalAttributeFound = false;
                for (int j = 0; j < len; ++j) {
                    Node n2 = map2.item(j);
                    if (PluginUtil.isAttributeANamespaceDeclaration(n2) || !PluginUtil.customIsEqualNode(n1, n2)) continue;
                    equalAttributeFound = true;
                    break;
                }
                if (equalAttributeFound) continue;
                return false;
            }
        }
        Node child1 = left.getFirstChild();
        for (child2 = right.getFirstChild(); child1 != null && child2 != null; child1 = child1.getNextSibling(), child2 = child2.getNextSibling()) {
            if (PluginUtil.customIsEqualNode(child1, child2)) continue;
            return false;
        }
        return child1 == child2;
    }

    private static int getLengthWithoutNamespaceDeclaration(NamedNodeMap map) {
        int len = 0;
        for (int i = 0; i < map.getLength(); ++i) {
            if (PluginUtil.isAttributeANamespaceDeclaration(map.item(i))) continue;
            ++len;
        }
        return len;
    }

    private static boolean isAttributeANamespaceDeclaration(Node node) {
        if (node.getLocalName() != null && node.getLocalName().equals("xmlns") && node.getPrefix() == null) {
            return true;
        }
        if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
            return true;
        }
        return node.getPrefix() != null && node.getPrefix().equals("xmlns");
    }
}

