/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.model.participant;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.Duration;
import org.jetbrains.annotations.Nullable;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractSetStateOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetStringOperationDescriptor;
import org.somda.sdc.biceps.model.participant.SetValueOperationDescriptor;
import org.somda.sdc.common.model.DurationAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractOperationDescriptor", namespace="http://standards.ieee.org/downloads/11073/11073-10207-2017/participant")
@XmlSeeAlso(value={SetValueOperationDescriptor.class, SetStringOperationDescriptor.class, AbstractSetStateOperationDescriptor.class})
public class AbstractOperationDescriptor
extends AbstractDescriptor
implements Cloneable,
CopyTo,
ToString {
    @XmlAttribute(name="OperationTarget", required=true)
    protected String operationTarget;
    @XmlAttribute(name="MaxTimeToFinish")
    @XmlJavaTypeAdapter(value=DurationAdapter.class)
    @XmlSchemaType(name="duration")
    protected Duration maxTimeToFinish;
    @XmlAttribute(name="InvocationEffectiveTimeout")
    @XmlJavaTypeAdapter(value=DurationAdapter.class)
    @XmlSchemaType(name="duration")
    protected Duration invocationEffectiveTimeout;
    @XmlAttribute(name="Retriggerable")
    protected Boolean retriggerable;
    @XmlAttribute(name="AccessLevel")
    protected AccessLevel accessLevel;

    public String getOperationTarget() {
        return this.operationTarget;
    }

    public void setOperationTarget(String value) {
        this.operationTarget = value;
    }

    @Nullable
    public Duration getMaxTimeToFinish() {
        return this.maxTimeToFinish;
    }

    public void setMaxTimeToFinish(@Nullable Duration value) {
        this.maxTimeToFinish = value;
    }

    @Nullable
    public Duration getInvocationEffectiveTimeout() {
        return this.invocationEffectiveTimeout;
    }

    public void setInvocationEffectiveTimeout(@Nullable Duration value) {
        this.invocationEffectiveTimeout = value;
    }

    @Nullable
    public Boolean isRetriggerable() {
        return this.retriggerable;
    }

    public void setRetriggerable(@Nullable Boolean value) {
        this.retriggerable = value;
    }

    @Nullable
    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(@Nullable AccessLevel value) {
        this.accessLevel = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractOperationDescriptor that = (AbstractOperationDescriptor)object;
        String leftOperationTarget = this.getOperationTarget();
        String rightOperationTarget = that.getOperationTarget();
        if (this.operationTarget != null) {
            if (that.operationTarget == null) return false;
            if (!leftOperationTarget.equals(rightOperationTarget)) {
                return false;
            }
        } else if (that.operationTarget != null) {
            return false;
        }
        Duration leftMaxTimeToFinish = this.getMaxTimeToFinish();
        Duration rightMaxTimeToFinish = that.getMaxTimeToFinish();
        if (this.maxTimeToFinish != null) {
            if (that.maxTimeToFinish == null) return false;
            if (!leftMaxTimeToFinish.equals(rightMaxTimeToFinish)) {
                return false;
            }
        } else if (that.maxTimeToFinish != null) {
            return false;
        }
        Duration leftInvocationEffectiveTimeout = this.getInvocationEffectiveTimeout();
        Duration rightInvocationEffectiveTimeout = that.getInvocationEffectiveTimeout();
        if (this.invocationEffectiveTimeout != null) {
            if (that.invocationEffectiveTimeout == null) return false;
            if (!leftInvocationEffectiveTimeout.equals(rightInvocationEffectiveTimeout)) {
                return false;
            }
        } else if (that.invocationEffectiveTimeout != null) {
            return false;
        }
        Boolean leftRetriggerable = this.isRetriggerable();
        Boolean rightRetriggerable = that.isRetriggerable();
        if (this.retriggerable != null) {
            if (that.retriggerable == null) return false;
            if (!leftRetriggerable.equals(rightRetriggerable)) {
                return false;
            }
        } else if (that.retriggerable != null) {
            return false;
        }
        AccessLevel leftAccessLevel = this.getAccessLevel();
        AccessLevel rightAccessLevel = that.getAccessLevel();
        if (this.accessLevel != null) {
            if (that.accessLevel == null) return false;
            if (leftAccessLevel.equals((Object)rightAccessLevel)) return true;
            return false;
        }
        if (that.accessLevel == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        String theOperationTarget = this.getOperationTarget();
        if (this.operationTarget != null) {
            currentHashCode += theOperationTarget.hashCode();
        }
        currentHashCode *= 31;
        Duration theMaxTimeToFinish = this.getMaxTimeToFinish();
        if (this.maxTimeToFinish != null) {
            currentHashCode += theMaxTimeToFinish.hashCode();
        }
        currentHashCode *= 31;
        Duration theInvocationEffectiveTimeout = this.getInvocationEffectiveTimeout();
        if (this.invocationEffectiveTimeout != null) {
            currentHashCode += theInvocationEffectiveTimeout.hashCode();
        }
        currentHashCode *= 31;
        Boolean theRetriggerable = this.isRetriggerable();
        if (this.retriggerable != null) {
            currentHashCode += theRetriggerable.hashCode();
        }
        currentHashCode *= 31;
        AccessLevel theAccessLevel = this.getAccessLevel();
        if (this.accessLevel != null) {
            currentHashCode += theAccessLevel.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        String theOperationTarget = this.getOperationTarget();
        strategy.appendField(locator, (Object)this, "operationTarget", buffer, (Object)theOperationTarget, this.operationTarget != null);
        Duration theMaxTimeToFinish = this.getMaxTimeToFinish();
        strategy.appendField(locator, (Object)this, "maxTimeToFinish", buffer, (Object)theMaxTimeToFinish, this.maxTimeToFinish != null);
        Duration theInvocationEffectiveTimeout = this.getInvocationEffectiveTimeout();
        strategy.appendField(locator, (Object)this, "invocationEffectiveTimeout", buffer, (Object)theInvocationEffectiveTimeout, this.invocationEffectiveTimeout != null);
        Boolean theRetriggerable = this.isRetriggerable();
        strategy.appendField(locator, (Object)this, "retriggerable", buffer, (Object)theRetriggerable, this.retriggerable != null);
        AccessLevel theAccessLevel = this.getAccessLevel();
        strategy.appendField(locator, (Object)this, "accessLevel", buffer, (Object)theAccessLevel, this.accessLevel != null);
        return buffer;
    }

    @Override
    public Object clone() {
        return this.copyTo(this.createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        JAXBCopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return this.copyTo(null, target, (CopyStrategy)strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        Object draftCopy = target == null ? this.createNewInstance() : target;
        super.copyTo(locator, draftCopy, strategy);
        if (draftCopy instanceof AbstractOperationDescriptor) {
            AbstractOperationDescriptor copy = (AbstractOperationDescriptor)draftCopy;
            Boolean operationTargetShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, this.operationTarget != null);
            if (operationTargetShouldBeCopiedAndSet == Boolean.TRUE) {
                String sourceOperationTarget = this.getOperationTarget();
                String copyOperationTarget = (String)strategy.copy((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"operationTarget", (Object)sourceOperationTarget), (Object)sourceOperationTarget, this.operationTarget != null);
                copy.setOperationTarget(copyOperationTarget);
            } else if (operationTargetShouldBeCopiedAndSet == Boolean.FALSE) {
                copy.operationTarget = null;
            }
            Boolean maxTimeToFinishShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, this.maxTimeToFinish != null);
            if (maxTimeToFinishShouldBeCopiedAndSet == Boolean.TRUE) {
                Duration sourceMaxTimeToFinish = this.getMaxTimeToFinish();
                Duration copyMaxTimeToFinish = (Duration)strategy.copy((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"maxTimeToFinish", (Object)sourceMaxTimeToFinish), (Object)sourceMaxTimeToFinish, this.maxTimeToFinish != null);
                copy.setMaxTimeToFinish(copyMaxTimeToFinish);
            } else if (maxTimeToFinishShouldBeCopiedAndSet == Boolean.FALSE) {
                copy.maxTimeToFinish = null;
            }
            Boolean invocationEffectiveTimeoutShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, this.invocationEffectiveTimeout != null);
            if (invocationEffectiveTimeoutShouldBeCopiedAndSet == Boolean.TRUE) {
                Duration sourceInvocationEffectiveTimeout = this.getInvocationEffectiveTimeout();
                Duration copyInvocationEffectiveTimeout = (Duration)strategy.copy((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"invocationEffectiveTimeout", (Object)sourceInvocationEffectiveTimeout), (Object)sourceInvocationEffectiveTimeout, this.invocationEffectiveTimeout != null);
                copy.setInvocationEffectiveTimeout(copyInvocationEffectiveTimeout);
            } else if (invocationEffectiveTimeoutShouldBeCopiedAndSet == Boolean.FALSE) {
                copy.invocationEffectiveTimeout = null;
            }
            Boolean retriggerableShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, this.retriggerable != null);
            if (retriggerableShouldBeCopiedAndSet == Boolean.TRUE) {
                Boolean sourceRetriggerable = this.isRetriggerable();
                Boolean copyRetriggerable = (Boolean)strategy.copy((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"retriggerable", (Object)sourceRetriggerable), (Object)sourceRetriggerable, this.retriggerable != null);
                copy.setRetriggerable(copyRetriggerable);
            } else if (retriggerableShouldBeCopiedAndSet == Boolean.FALSE) {
                copy.retriggerable = null;
            }
            Boolean accessLevelShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, this.accessLevel != null);
            if (accessLevelShouldBeCopiedAndSet == Boolean.TRUE) {
                AccessLevel sourceAccessLevel = this.getAccessLevel();
                AccessLevel copyAccessLevel = (AccessLevel)((Object)strategy.copy((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"accessLevel", (Object)((Object)sourceAccessLevel)), (Object)sourceAccessLevel, this.accessLevel != null));
                copy.setAccessLevel(copyAccessLevel);
            } else if (accessLevelShouldBeCopiedAndSet == Boolean.FALSE) {
                copy.accessLevel = null;
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new AbstractOperationDescriptor();
    }

    @XmlType(name="")
    @XmlEnum
    public static enum AccessLevel {
        USR("Usr"),
        CS_USR("CSUsr"),
        RO("RO"),
        SP("SP"),
        OTH("Oth");

        private final String value;

        private AccessLevel(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static AccessLevel fromValue(String v) {
            for (AccessLevel c : AccessLevel.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

