/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.biceps.model.participant;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;
import org.somda.sdc.biceps.model.participant.AbstractMetricState;
import org.somda.sdc.biceps.model.participant.NumericMetricValue;
import org.somda.sdc.biceps.model.participant.Range;
import org.somda.sdc.common.model.DurationAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NumericMetricState", namespace="http://standards.ieee.org/downloads/11073/11073-10207-2017/participant", propOrder={"metricValue", "physiologicalRange"})
public class NumericMetricState
extends AbstractMetricState
implements Cloneable,
CopyTo,
ToString {
    @XmlElement(name="MetricValue", namespace="http://standards.ieee.org/downloads/11073/11073-10207-2017/participant")
    protected NumericMetricValue metricValue;
    @XmlElement(name="PhysiologicalRange", namespace="http://standards.ieee.org/downloads/11073/11073-10207-2017/participant")
    protected List<Range> physiologicalRange;
    @XmlAttribute(name="ActiveAveragingPeriod")
    @XmlJavaTypeAdapter(value=DurationAdapter.class)
    @XmlSchemaType(name="duration")
    protected Duration activeAveragingPeriod;

    @Nullable
    public NumericMetricValue getMetricValue() {
        return this.metricValue;
    }

    public void setMetricValue(@Nullable NumericMetricValue value) {
        this.metricValue = value;
    }

    public List<Range> getPhysiologicalRange() {
        if (this.physiologicalRange == null) {
            this.physiologicalRange = new ArrayList<Range>();
        }
        return this.physiologicalRange;
    }

    @Nullable
    public Duration getActiveAveragingPeriod() {
        return this.activeAveragingPeriod;
    }

    public void setActiveAveragingPeriod(@Nullable Duration value) {
        this.activeAveragingPeriod = value;
    }

    public void setPhysiologicalRange(@Nullable List<Range> value) {
        this.physiologicalRange = null;
        if (value != null) {
            List<Range> draftl = this.getPhysiologicalRange();
            draftl.addAll(value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Range> rightPhysiologicalRange;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        NumericMetricState that = (NumericMetricState)object;
        NumericMetricValue leftMetricValue = this.getMetricValue();
        NumericMetricValue rightMetricValue = that.getMetricValue();
        if (this.metricValue != null) {
            if (that.metricValue == null) return false;
            if (!leftMetricValue.equals(rightMetricValue)) {
                return false;
            }
        } else if (that.metricValue != null) {
            return false;
        }
        List<Range> leftPhysiologicalRange = this.physiologicalRange != null && !this.physiologicalRange.isEmpty() ? this.getPhysiologicalRange() : null;
        List<Range> list = rightPhysiologicalRange = that.physiologicalRange != null && !that.physiologicalRange.isEmpty() ? that.getPhysiologicalRange() : null;
        if (this.physiologicalRange != null && !this.physiologicalRange.isEmpty()) {
            if (that.physiologicalRange == null || that.physiologicalRange.isEmpty()) return false;
            if (!leftPhysiologicalRange.equals(rightPhysiologicalRange)) {
                return false;
            }
        } else if (that.physiologicalRange != null && !that.physiologicalRange.isEmpty()) {
            return false;
        }
        Duration leftActiveAveragingPeriod = this.getActiveAveragingPeriod();
        Duration rightActiveAveragingPeriod = that.getActiveAveragingPeriod();
        if (this.activeAveragingPeriod != null) {
            if (that.activeAveragingPeriod == null) return false;
            if (leftActiveAveragingPeriod.equals(rightActiveAveragingPeriod)) return true;
            return false;
        }
        if (that.activeAveragingPeriod == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Range> thePhysiologicalRange;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        NumericMetricValue theMetricValue = this.getMetricValue();
        if (this.metricValue != null) {
            currentHashCode += theMetricValue.hashCode();
        }
        currentHashCode *= 31;
        List<Range> list = thePhysiologicalRange = this.physiologicalRange != null && !this.physiologicalRange.isEmpty() ? this.getPhysiologicalRange() : null;
        if (this.physiologicalRange != null && !this.physiologicalRange.isEmpty()) {
            currentHashCode += thePhysiologicalRange.hashCode();
        }
        currentHashCode *= 31;
        Duration theActiveAveragingPeriod = this.getActiveAveragingPeriod();
        if (this.activeAveragingPeriod != null) {
            currentHashCode += theActiveAveragingPeriod.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        NumericMetricValue theMetricValue = this.getMetricValue();
        strategy.appendField(locator, (Object)this, "metricValue", buffer, (Object)theMetricValue, this.metricValue != null);
        List<Range> thePhysiologicalRange = this.physiologicalRange != null && !this.physiologicalRange.isEmpty() ? this.getPhysiologicalRange() : null;
        strategy.appendField(locator, (Object)this, "physiologicalRange", buffer, thePhysiologicalRange, this.physiologicalRange != null && !this.physiologicalRange.isEmpty());
        Duration theActiveAveragingPeriod = this.getActiveAveragingPeriod();
        strategy.appendField(locator, (Object)this, "activeAveragingPeriod", buffer, (Object)theActiveAveragingPeriod, this.activeAveragingPeriod != null);
        return buffer;
    }

    @Override
    public Object clone() {
        return this.copyTo(this.createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        JAXBCopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return this.copyTo(null, target, (CopyStrategy)strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        Object draftCopy = target == null ? this.createNewInstance() : target;
        super.copyTo(locator, draftCopy, strategy);
        if (draftCopy instanceof NumericMetricState) {
            NumericMetricState copy = (NumericMetricState)draftCopy;
            Boolean metricValueShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, this.metricValue != null);
            if (metricValueShouldBeCopiedAndSet == Boolean.TRUE) {
                NumericMetricValue sourceMetricValue = this.getMetricValue();
                NumericMetricValue copyMetricValue = (NumericMetricValue)strategy.copy((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"metricValue", (Object)sourceMetricValue), (Object)sourceMetricValue, this.metricValue != null);
                copy.setMetricValue(copyMetricValue);
            } else if (metricValueShouldBeCopiedAndSet == Boolean.FALSE) {
                copy.metricValue = null;
            }
            Boolean physiologicalRangeShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, this.physiologicalRange != null && !this.physiologicalRange.isEmpty());
            if (physiologicalRangeShouldBeCopiedAndSet == Boolean.TRUE) {
                List<Range> sourcePhysiologicalRange = this.physiologicalRange != null && !this.physiologicalRange.isEmpty() ? this.getPhysiologicalRange() : null;
                List copyPhysiologicalRange = (List)strategy.copy((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"physiologicalRange", sourcePhysiologicalRange), sourcePhysiologicalRange, this.physiologicalRange != null && !this.physiologicalRange.isEmpty());
                copy.setPhysiologicalRange(copyPhysiologicalRange);
            } else if (physiologicalRangeShouldBeCopiedAndSet == Boolean.FALSE) {
                copy.physiologicalRange = null;
            }
            Boolean activeAveragingPeriodShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, this.activeAveragingPeriod != null);
            if (activeAveragingPeriodShouldBeCopiedAndSet == Boolean.TRUE) {
                Duration sourceActiveAveragingPeriod = this.getActiveAveragingPeriod();
                Duration copyActiveAveragingPeriod = (Duration)strategy.copy((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"activeAveragingPeriod", (Object)sourceActiveAveragingPeriod), (Object)sourceActiveAveragingPeriod, this.activeAveragingPeriod != null);
                copy.setActiveAveragingPeriod(copyActiveAveragingPeriod);
            } else if (activeAveragingPeriodShouldBeCopiedAndSet == Boolean.FALSE) {
                copy.activeAveragingPeriod = null;
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new NumericMetricState();
    }
}

