/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.model;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.somda.sdc.common.model.ObjectStringifier;

public class AnyDateTime {
    private static final ZoneOffset DEFAULT_OFFSET = OffsetDateTime.now().getOffset();
    private LocalDateTime local;
    private OffsetDateTime offset;

    private AnyDateTime(LocalDateTime local) {
        this.local = local;
    }

    private AnyDateTime(OffsetDateTime offset) {
        this.offset = offset;
    }

    public static AnyDateTime create(LocalDateTime local) {
        return new AnyDateTime(local);
    }

    public static AnyDateTime create(OffsetDateTime offset) {
        return new AnyDateTime(offset);
    }

    public Optional<OffsetDateTime> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    public Optional<LocalDateTime> getLocal() {
        return Optional.ofNullable(this.local);
    }

    public OffsetDateTime forceOffset() {
        return this.forceOffset(DEFAULT_OFFSET);
    }

    public OffsetDateTime forceOffset(ZoneOffset localOffset) {
        return Objects.requireNonNullElseGet(this.offset, () -> OffsetDateTime.of(this.local, localOffset));
    }

    public Else<OffsetDateTime> doIfLocal(Consumer<LocalDateTime> consumer) {
        if (this.local != null) {
            consumer.accept(this.local);
            return elseConsumer -> {};
        }
        return elseConsumer -> elseConsumer.accept(this.offset);
    }

    public Else<LocalDateTime> doIfOffset(Consumer<OffsetDateTime> consumer) {
        if (this.offset != null) {
            consumer.accept(this.offset);
            return elseConsumer -> {};
        }
        return elseConsumer -> elseConsumer.accept(this.local);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AnyDateTime that = (AnyDateTime)object;
        return Objects.equals(this.local, that.local) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.local, this.offset);
    }

    public String toString() {
        return ObjectStringifier.stringify(this);
    }

    public static interface Else<T> {
        public void orElse(Consumer<T> var1);
    }
}

