/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.model;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class DurationAdapter
extends XmlAdapter<String, Duration> {
    private static final String SIGN = "sign";
    private static final String DAYS = "days";
    private static final String HOURS = "hours";
    private static final String MINUTES = "minutes";
    private static final String SECONDS = "seconds";
    private static final Pattern PATTERN = Pattern.compile("^(?<sign>[+-])?P(?!\\b)(?:(?<years>[0-9]+([,.][0-9]+)?)Y)?(?:(?<months>[0-9]+([,.][0-9]+)?)M)?(?:(?<weeks>[0-9]+([,.][0-9]+)?)W)?(?:(?<days>[0-9]+([,.][0-9]+)?)D)?((?<separator>T)(?:(?<hours>[0-9]+([,.][0-9]+)?)H)?(?:(?<minutes>[0-9]+([,.][0-9]+)?)M)?(?:(?<seconds>[0-9]+([,.][0-9]+)?)S)?)?$", 2);

    public Duration unmarshal(@Nullable String v) {
        if (v == null) {
            return null;
        }
        try {
            return Duration.parse(v);
        }
        catch (DateTimeParseException e) {
            Matcher matcher = PATTERN.matcher(v);
            if (matcher.matches()) {
                String sign = matcher.group(SIGN);
                return Duration.parse(String.format("%sP%sDT%sH%sM%sS", sign == null ? "" : sign, DurationAdapter.givenOrZero(matcher.group(DAYS)), DurationAdapter.givenOrZero(matcher.group(HOURS)), DurationAdapter.givenOrZero(matcher.group(MINUTES)), DurationAdapter.givenOrZero(matcher.group(SECONDS))));
            }
            throw new DateTimeParseException("XML Schema duration could not be parsed to a Java Duration", v, 0);
        }
    }

    public String marshal(@Nullable Duration v) {
        return v == null ? null : v.toString();
    }

    private static String givenOrZero(@Nullable String given) {
        return given == null ? "0" : given;
    }
}

