/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.guice;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public abstract class AbstractConfigurationModule
extends AbstractModule {
    private static final Logger LOG = LogManager.getLogger(AbstractConfigurationModule.class);
    private final Map<String, ConfigurationValue> boundValues = new TreeMap<String, ConfigurationValue>();
    private boolean configureStarted = false;

    public <T> void bind(String name, Class<T> dataType, @Nullable T value) {
        if (!this.boundValues.containsKey(name)) {
            Runnable runBind = () -> {
                if (value == null) {
                    this.bind(dataType).annotatedWith((Annotation)Names.named((String)name)).toProvider(Providers.of(null));
                } else {
                    this.bind(dataType).annotatedWith((Annotation)Names.named((String)name)).toInstance(value);
                }
            };
            ValueOrigin valueOrigin = this.configureStarted ? ValueOrigin.DEFAULTED : ValueOrigin.CUSTOMIZED;
            this.boundValues.put(name, new ConfigurationValue(valueOrigin, runBind, value));
        } else if (!this.configureStarted) {
            LOG.warn("Try to populate configuration key '{}' twice. Attempt skipped.", (Object)name);
        }
    }

    public <T> void bind(String name, TypeLiteral<T> typeLiteral, @Nullable T value) {
        if (!this.boundValues.containsKey(name)) {
            Runnable runBind = () -> {
                if (value == null) {
                    this.bind(typeLiteral).annotatedWith((Annotation)Names.named((String)name)).toProvider(Providers.of(null));
                } else {
                    this.bind(typeLiteral).annotatedWith((Annotation)Names.named((String)name)).toInstance(value);
                }
            };
            ValueOrigin valueOrigin = this.configureStarted ? ValueOrigin.DEFAULTED : ValueOrigin.CUSTOMIZED;
            this.boundValues.put(name, new ConfigurationValue(valueOrigin, runBind, value));
        } else if (!this.configureStarted) {
            LOG.warn("Try to populate configuration key '{}' twice. Attempt skipped.", (Object)name);
        }
    }

    protected final void configure() {
        this.customConfigure();
        this.configureStarted = true;
        this.defaultConfigure();
        this.logConfiguredValues();
        this.boundValues.forEach((key, value) -> value.getBinder().run());
    }

    protected abstract void defaultConfigure();

    protected void customConfigure() {
    }

    private void logConfiguredValues() {
        this.boundValues.forEach((key, value) -> LOG.info("{} {} := {}", (Object)value.getValueOrigin(), key, value.getValue()));
    }

    private static enum ValueOrigin {
        DEFAULTED("[defaulted ]"),
        CUSTOMIZED("[customized]");

        private final String caption;

        private ValueOrigin(String value) {
            this.caption = value;
        }

        public String toString() {
            return this.caption;
        }
    }

    private static class ConfigurationValue {
        private final ValueOrigin valueOrigin;
        private final Runnable binder;
        private final Object value;

        ConfigurationValue(ValueOrigin valueOrigin, Runnable binder, Object value) {
            this.valueOrigin = valueOrigin;
            this.binder = binder;
            this.value = value;
        }

        ValueOrigin getValueOrigin() {
            return this.valueOrigin;
        }

        Runnable getBinder() {
            return this.binder;
        }

        Object getValue() {
            return this.value;
        }
    }
}

