/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class InstanceLogger {
    public static final String INSTANCE_ID = "instanceId";

    public static Logger wrapLogger(Logger logger, String instanceId) {
        return (Logger)Proxy.newProxyInstance(InstanceLogger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new InstanceLoggerInvocationHandler(logger, instanceId));
    }

    public static ExtendedLogger wrapLogger(ExtendedLogger logger, String instanceId) {
        return (ExtendedLogger)Proxy.newProxyInstance(InstanceLogger.class.getClassLoader(), new Class[]{ExtendedLogger.class}, (InvocationHandler)new InstanceLoggerInvocationHandler((Logger)logger, instanceId));
    }

    public static KotlinLogger wrapLogger(KotlinLogger logger, String instanceId) {
        return new KotlinLogger(InstanceLogger.wrapLogger(logger.getDelegate(), instanceId));
    }

    private static class InstanceLoggerInvocationHandler
    implements InvocationHandler {
        private final String instanceId;
        private final Logger logger;

        InstanceLoggerInvocationHandler(Logger logger, String instanceId) {
            this.instanceId = instanceId;
            this.logger = logger;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)InstanceLogger.INSTANCE_ID, (String)this.instanceId);){
                Object object = method.invoke((Object)this.logger, args);
                return object;
            }
        }
    }
}

