/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.util;

import jakarta.xml.bind.JAXBElement;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.util.JaxbUtil;

public class JaxbUtilImpl
implements JaxbUtil {
    private static final Logger LOG = LogManager.getLogger(JaxbUtilImpl.class);

    @Override
    public <T> Optional<T> extractElement(Object element, QName elementType, Class<T> typeClass) {
        Optional<T> extractedObj = this.extractElement(element, elementType);
        if (extractedObj.isPresent() && typeClass.isAssignableFrom(extractedObj.get().getClass())) {
            return Optional.of(typeClass.cast(extractedObj.get()));
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> extractElement(Object element, Class<T> typeClass) {
        try {
            if (element instanceof JAXBElement) {
                Object value = ((JAXBElement)element).getValue();
                return Optional.of(typeClass.cast(value));
            }
            return Optional.of(typeClass.cast(element));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    public <T> Optional<T> extractElement(Object element, QName elementType) {
        try {
            JAXBElement elementAsJaxb = (JAXBElement)element;
            if (elementAsJaxb.getName().equals(elementType)) {
                return Optional.ofNullable(elementAsJaxb.getValue());
            }
        }
        catch (ClassCastException e) {
            LOG.trace("Object was not a JAXBElement, extracting elements failed but it's alright");
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> extractFirstElementFromAny(List<Object> anyList, QName elementType, Class<T> typeClass) {
        if (anyList.isEmpty()) {
            return Optional.empty();
        }
        Optional<T> first = this.extractElement(anyList.get(0), elementType, typeClass);
        if (first.isPresent()) {
            try {
                return Optional.of(typeClass.cast(first.get()));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> extractFirstElementFromAny(List<Object> anyList, Class<T> typeClass) {
        if (anyList.isEmpty()) {
            return Optional.empty();
        }
        Optional<T> first = this.extractElement(anyList.get(0), typeClass);
        if (first.isPresent()) {
            try {
                return Optional.of(typeClass.cast(first.get()));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

