/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client.helper;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.event.DeviceEnteredMessage;
import org.somda.sdc.dpws.client.event.DeviceLeftMessage;
import org.somda.sdc.dpws.client.event.DeviceProbeTimeoutMessage;
import org.somda.sdc.dpws.client.event.ProbedDeviceFoundMessage;
import org.somda.sdc.dpws.client.helper.DiscoveredDeviceResolver;
import org.somda.sdc.dpws.guice.NetworkJobThreadPool;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsdiscovery.HelloByeAndProbeMatchesObserver;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ByeMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.HelloMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ProbeMatchesMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ProbeTimeoutMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ByeType;

public class HelloByeAndProbeMatchesObserverImpl
implements HelloByeAndProbeMatchesObserver {
    private static final Logger LOG = LogManager.getLogger(HelloByeAndProbeMatchesObserverImpl.class);
    private final DiscoveredDeviceResolver discoveredDeviceResolver;
    private final ExecutorWrapperService<ListeningExecutorService> networkJobExecutor;
    private final WsAddressingUtil wsaUtil;
    private final EventBus discoveryBus;
    private final Logger instanceLogger;

    @Inject
    HelloByeAndProbeMatchesObserverImpl(@Assisted DiscoveredDeviceResolver discoveredDeviceResolver, @NetworkJobThreadPool ExecutorWrapperService<ListeningExecutorService> networkJobExecutor, WsAddressingUtil wsaUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.discoveredDeviceResolver = discoveredDeviceResolver;
        this.networkJobExecutor = networkJobExecutor;
        this.wsaUtil = wsaUtil;
        this.discoveryBus = new EventBus();
    }

    public void registerDiscoveryObserver(DiscoveryObserver observer) {
        this.discoveryBus.register((Object)observer);
    }

    public void unregisterDiscoveryObserver(DiscoveryObserver observer) {
        this.discoveryBus.unregister((Object)observer);
    }

    public void publishDeviceLeft(String deviceUuid) {
        this.discoveryBus.post((Object)new DeviceLeftMessage(deviceUuid));
    }

    @Subscribe
    void onHello(HelloMessage helloMessage) {
        ListenableFuture future = ((ListeningExecutorService)this.networkJobExecutor.get()).submit(() -> this.discoveredDeviceResolver.resolve(helloMessage));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Optional<DiscoveredDevice>>(){

            public void onSuccess(@Nullable Optional<DiscoveredDevice> discoveredDevice) {
                if (discoveredDevice == null) {
                    HelloByeAndProbeMatchesObserverImpl.this.instanceLogger.warn("{} delivered null pointer", DiscoveredDeviceResolver.class);
                    return;
                }
                discoveredDevice.ifPresent(dp -> HelloByeAndProbeMatchesObserverImpl.this.discoveryBus.post((Object)new DeviceEnteredMessage((DiscoveredDevice)dp)));
            }

            public void onFailure(Throwable throwable) {
                HelloByeAndProbeMatchesObserverImpl.this.instanceLogger.trace("Error while processing Hello message.", throwable);
            }
        }, (Executor)this.networkJobExecutor.get());
    }

    @Subscribe
    void onBye(ByeMessage byeMessage) {
        this.wsaUtil.getAddressUri(((ByeType)byeMessage.getPayload()).getEndpointReference()).ifPresent(this::publishDeviceLeft);
    }

    @Subscribe
    void onProbeMatches(final ProbeMatchesMessage probeMatchesMessage) {
        ListenableFuture future = ((ListeningExecutorService)this.networkJobExecutor.get()).submit(() -> this.discoveredDeviceResolver.resolve(probeMatchesMessage));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Optional<DiscoveredDevice>>(){

            public void onSuccess(@Nullable Optional<DiscoveredDevice> discoveredDevice) {
                if (discoveredDevice == null) {
                    HelloByeAndProbeMatchesObserverImpl.this.instanceLogger.warn("{} delivered null pointer", DiscoveredDeviceResolver.class);
                    return;
                }
                discoveredDevice.ifPresent(dp -> HelloByeAndProbeMatchesObserverImpl.this.discoveryBus.post((Object)new ProbedDeviceFoundMessage((DiscoveredDevice)dp, probeMatchesMessage.getProbeRequestId())));
            }

            public void onFailure(Throwable throwable) {
            }
        }, (Executor)this.networkJobExecutor.get());
    }

    @Subscribe
    void onProbeTimeout(ProbeTimeoutMessage probeTimeoutMessage) {
        this.discoveryBus.post((Object)new DeviceProbeTimeoutMessage(probeTimeoutMessage.getProbeMatchesCount(), probeTimeoutMessage.getProbeRequestId()));
    }
}

