/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.device.helper;

import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.guice.AppDelayExecutor;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.MarshallingService;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapDebug;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryConstants;
import org.somda.sdc.dpws.udp.UdpMessage;
import org.somda.sdc.dpws.udp.UdpMessageQueueObserver;
import org.somda.sdc.dpws.udp.UdpMessageQueueService;

public class DiscoveryDeviceUdpMessageProcessor
implements UdpMessageQueueObserver {
    private static final Logger LOG = LogManager.getLogger(DiscoveryDeviceUdpMessageProcessor.class);
    private final RequestResponseServer requestResponseServer;
    private final UdpMessageQueueService udpMessageQueueService;
    private final MarshallingService marshallingService;
    private final SoapUtil soapUtil;
    private final ExecutorWrapperService<ScheduledExecutorService> scheduledExecutorService;
    private final Random randomNumbers;
    private final Logger instanceLogger;

    @AssistedInject
    DiscoveryDeviceUdpMessageProcessor(@Assisted RequestResponseServer requestResponseServer, @Assisted UdpMessageQueueService udpMessageQueueService, MarshallingService marshallingService, SoapUtil soapUtil, @AppDelayExecutor ExecutorWrapperService<ScheduledExecutorService> scheduledExecutorService, Random randomNumbers, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.requestResponseServer = requestResponseServer;
        this.udpMessageQueueService = udpMessageQueueService;
        this.marshallingService = marshallingService;
        this.soapUtil = soapUtil;
        this.scheduledExecutorService = scheduledExecutorService;
        this.randomNumbers = randomNumbers;
    }

    @Subscribe
    private void receiveUdpMessage(UdpMessage msg) {
        SoapMessage request;
        this.instanceLogger.trace("Receive UDP message called with message: {}", (Object)msg);
        SoapMessage response = this.soapUtil.createMessage();
        try {
            request = this.marshallingService.unmarshal(new ByteArrayInputStream(msg.getData(), 0, msg.getLength()));
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn("Incoming UDP message could not be unmarshalled. Message Bytes: {}", (Object)msg);
            return;
        }
        this.instanceLogger.debug("Incoming SOAP/UDP message: {}", new Supplier[]{() -> SoapDebug.get(request)});
        try {
            this.requestResponseServer.receiveRequestResponse(request, response, msg.getCommunicationContext());
        }
        catch (SoapFaultException e) {
            this.instanceLogger.debug("SOAP fault thrown [{}]", (Object)e.getMessage());
            this.instanceLogger.trace("SOAP fault thrown", (Throwable)e);
            return;
        }
        Optional<AttributedURIType> action = response.getWsAddressingHeader().getAction();
        if (action.isEmpty() || action.get().getValue().isBlank()) {
            this.instanceLogger.debug("Not sending a response, no response with an action generated for message {}", (Object)SoapDebug.get(request));
            return;
        }
        this.instanceLogger.debug("Outgoing SOAP/UDP message: {}", new Supplier[]{() -> SoapDebug.get(response)});
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.marshallingService.marshal(response, os);
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn("WS-Discovery response could not be created. Reason: {}", (Object)e.getMessage());
            this.instanceLogger.trace("WS-Discovery response could not be created", (Throwable)e);
            return;
        }
        byte[] bytes = os.toByteArray();
        int wait = this.randomNumbers.nextInt((int)WsDiscoveryConstants.APP_MAX_DELAY.toMillis() + 1);
        ((ScheduledExecutorService)this.scheduledExecutorService.get()).schedule(() -> {
            CommunicationContext ctxt = new CommunicationContext(new ApplicationInfo(), new TransportInfo("soap.udp", null, null, msg.getHost(), msg.getPort(), Collections.emptyList()), null);
            this.udpMessageQueueService.sendMessage(new UdpMessage(bytes, bytes.length, ctxt));
        }, (long)wait, TimeUnit.MILLISECONDS);
    }
}

