/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.crypto.CryptoConfigurator;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.factory.CommunicationLogFactory;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.http.HttpClient;
import org.somda.sdc.dpws.http.HttpConnectionInterceptor;
import org.somda.sdc.dpws.http.apache.ClientTransportBindingFactory;
import org.somda.sdc.dpws.http.apache.CommunicationLogHttpRequestInterceptor;
import org.somda.sdc.dpws.http.apache.CommunicationLogHttpResponseInterceptor;
import org.somda.sdc.dpws.http.apache.CustomHttpRetryHandler;
import org.somda.sdc.dpws.http.apache.MyApacheDefaultManagedHttpClientConnection;
import org.somda.sdc.dpws.http.apache.PoolCleaner;
import org.somda.sdc.dpws.http.factory.HttpClientFactory;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapUtil;

public class ApacheTransportBindingFactoryImpl
implements TransportBindingFactory,
HttpClientFactory {
    private static final Logger LOG = LogManager.getLogger(ApacheTransportBindingFactoryImpl.class);
    private static final String SCHEME_SOAP_OVER_UDP = "soap.udp";
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private final SoapMarshalling marshalling;
    private final SoapUtil soapUtil;
    private final boolean enableGzipCompression;
    private final Duration clientConnectTimeout;
    private final Duration clientReadTimeout;
    private final org.apache.http.client.HttpClient client;
    private final String[] tlsProtocols;
    private final HostnameVerifier hostnameVerifier;
    private final String[] enabledCiphers;
    private final boolean enableHttps;
    private final boolean enableHttp;
    private final CryptoConfigurator cryptoConfigurator;
    private final @Nullable CryptoSettings cryptoSettings;
    private final Logger instanceLogger;
    private final String frameworkIdentifier;
    private final int clientPoolSize;
    private final boolean retryNonIdempotent;
    private final HttpConnectionInterceptor httpConnectionInterceptor;
    private final PoolCleaner poolCleaner;
    private final ClientTransportBindingFactory clientTransportBindingFactory;

    @Inject
    ApacheTransportBindingFactoryImpl(SoapMarshalling marshalling, SoapUtil soapUtil, CryptoConfigurator cryptoConfigurator, @Named(value="Dpws.Crypto.Settings") @Nullable CryptoSettings cryptoSettings, @Named(value="Dpws.HttpClientConnectTimeout") Duration clientConnectTimeout, @Named(value="Dpws.HttpClientReadTimeout") Duration clientReadTimeout, @Named(value="Dpws.ClientPoolSize") int clientPoolSize, @Named(value="Dpws.ClientRetryPost") boolean retryNonIdempotent, @Named(value="Dpws.GzipCompression") boolean enableGzipCompression, ClientTransportBindingFactory clientTransportBindingFactory, CommunicationLogFactory communicationLogFactory, @Named(value="Dpws.Crypto.TlsEnabledVersions") String[] tlsProtocols, @Named(value="Dpws.Crypto.TlsEnabledCiphers") String[] enabledCiphers, @Named(value="Dpws.Crypto.ClientHostnameVerifier") HostnameVerifier hostnameVerifier, @Named(value="Dpws.EnableHttps") boolean enableHttps, @Named(value="Dpws.EnableHttp") boolean enableHttp, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier, @Named(value="Dpws.HttpConnectionInterceptor") HttpConnectionInterceptor httpConnectionInterceptor, PoolCleaner poolCleaner) {
        this.cryptoConfigurator = cryptoConfigurator;
        this.cryptoSettings = cryptoSettings;
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.frameworkIdentifier = frameworkIdentifier;
        this.marshalling = marshalling;
        this.soapUtil = soapUtil;
        this.clientConnectTimeout = clientConnectTimeout;
        this.clientReadTimeout = clientReadTimeout;
        this.enableGzipCompression = enableGzipCompression;
        this.clientTransportBindingFactory = clientTransportBindingFactory;
        this.tlsProtocols = tlsProtocols;
        this.enabledCiphers = enabledCiphers;
        this.hostnameVerifier = hostnameVerifier;
        this.enableHttps = enableHttps;
        this.enableHttp = enableHttp;
        this.clientPoolSize = clientPoolSize;
        this.retryNonIdempotent = retryNonIdempotent;
        this.httpConnectionInterceptor = httpConnectionInterceptor;
        this.poolCleaner = poolCleaner;
        if (!this.enableHttp && !this.enableHttps) {
            throw new RuntimeException("Http and https are disabled, cannot continue");
        }
        this.client = this.buildClient(cryptoConfigurator, cryptoSettings, communicationLogFactory.createCommunicationLog());
    }

    private org.apache.http.client.HttpClient buildClient(CryptoConfigurator cryptoConfigurator, @Nullable CryptoSettings cryptoSettings, CommunicationLog communicationLog) {
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)this.clientReadTimeout.toMillis()).setConnectTimeout((int)this.clientConnectTimeout.toMillis()).setSocketTimeout((int)this.clientConnectTimeout.toMillis()).build();
        HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultSocketConfig(socketConfig).addInterceptorLast((HttpRequestInterceptor)new CommunicationLogHttpRequestInterceptor(communicationLog, this.frameworkIdentifier, CryptoConfigurator.getCertificates(cryptoSettings))).addInterceptorLast((HttpResponseInterceptor)new CommunicationLogHttpResponseInterceptor(communicationLog, this.frameworkIdentifier)).addInterceptorLast((response, context) -> {
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            ManagedHttpClientConnection connection = (ManagedHttpClientConnection)clientContext.getConnection(ManagedHttpClientConnection.class);
            if (connection != null && connection.isOpen()) {
                UUID connectionId = UUID.fromString(connection.getId());
                if (connection.getMetrics() != null && connection.getMetrics().getRequestCount() == 1L && connection.getSSLSession() != null) {
                    this.httpConnectionInterceptor.onFirstIntercept(connectionId, connection.getSSLSession(), HttpConnectionInterceptor.Source.CLIENT);
                }
                this.httpConnectionInterceptor.onIntercept(connectionId);
            }
        }).setDefaultRequestConfig(requestConfig).disableConnectionState().setRetryHandler((HttpRequestRetryHandler)new CustomHttpRetryHandler(1, this.retryNonIdempotent, this.httpConnectionInterceptor));
        if (!this.enableGzipCompression) {
            clientBuilder.disableContentCompression();
        }
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (this.enableHttps) {
            SSLContext sslContext;
            try {
                sslContext = cryptoConfigurator.createSslContextFromCryptoConfig(cryptoSettings);
            }
            catch (Exception e) {
                this.instanceLogger.error("Could not read client crypto config, fallback to system properties", (Throwable)e);
                sslContext = cryptoConfigurator.createSslContextFromSystemProperties();
            }
            this.instanceLogger.debug("Enabled protocols: {}", new Supplier[]{() -> List.of(this.tlsProtocols)});
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, this.tlsProtocols, this.enabledCiphers, this.hostnameVerifier);
            registryBuilder.register(SCHEME_HTTPS, (Object)socketFactory);
        }
        if (this.enableHttp) {
            registryBuilder.register(SCHEME_HTTP, (Object)PlainConnectionSocketFactory.getSocketFactory());
        }
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(registryBuilder.build(), (HttpConnectionFactory)this.getConnectionFactory(), null, null, -1L, TimeUnit.MILLISECONDS);
        this.poolCleaner.addPool((HttpClientConnectionManager)poolingConnectionManager);
        poolingConnectionManager.setDefaultMaxPerRoute(1);
        poolingConnectionManager.setMaxTotal(this.clientPoolSize);
        HttpRequestExecutor requestExecutor = new HttpRequestExecutor(){

            public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                HttpResponse response = super.execute(request, conn, context);
                if (response.getEntity() != null && !response.getEntity().isStreaming()) {
                    response.setEntity((HttpEntity)new HttpEntityWrapper(response.getEntity()){

                        public boolean isStreaming() {
                            return true;
                        }
                    });
                }
                return response;
            }
        };
        return clientBuilder.setRequestExecutor(requestExecutor).setConnectionManager((HttpClientConnectionManager)poolingConnectionManager).build();
    }

    private ManagedHttpClientConnectionFactory getConnectionFactory() {
        return new ManagedHttpClientConnectionFactory(){
            private final KotlinLogger headerLog = LoggingFactoryKt.logger((String)"org.apache.http.headers");
            private final Log wireLog = LogFactory.getLog((String)"org.apache.http.wire");

            public ManagedHttpClientConnection create(HttpRoute route, ConnectionConfig config) {
                CodingErrorAction unmappableInputAction;
                ConnectionConfig cconfig = config != null ? config : ConnectionConfig.DEFAULT;
                CharsetDecoder charDecoder = null;
                CharsetEncoder charEncoder = null;
                Charset charset = cconfig.getCharset();
                CodingErrorAction malformedInputAction = cconfig.getMalformedInputAction() != null ? cconfig.getMalformedInputAction() : CodingErrorAction.REPORT;
                CodingErrorAction codingErrorAction = unmappableInputAction = cconfig.getUnmappableInputAction() != null ? cconfig.getUnmappableInputAction() : CodingErrorAction.REPORT;
                if (charset != null) {
                    charDecoder = charset.newDecoder();
                    charDecoder.onMalformedInput(malformedInputAction);
                    charDecoder.onUnmappableCharacter(unmappableInputAction);
                    charEncoder = charset.newEncoder();
                    charEncoder.onMalformedInput(malformedInputAction);
                    charEncoder.onUnmappableCharacter(unmappableInputAction);
                }
                String id = UUID.randomUUID().toString();
                return new MyApacheDefaultManagedHttpClientConnection(id, this.headerLog, this.wireLog, cconfig.getBufferSize(), cconfig.getFragmentSizeHint(), charDecoder, charEncoder, cconfig.getMessageConstraints(), (ContentLengthStrategy)LaxContentLengthStrategy.INSTANCE, (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, (HttpMessageWriterFactory<HttpRequest>)DefaultHttpRequestWriterFactory.INSTANCE, (HttpMessageParserFactory<HttpResponse>)DefaultHttpResponseParserFactory.INSTANCE, ApacheTransportBindingFactoryImpl.this.httpConnectionInterceptor);
            }
        };
    }

    @Override
    public TransportBinding createTransportBinding(String endpointUri, @Nullable CommunicationLogContext communicationLogContext) throws UnsupportedOperationException {
        String scheme = URI.create(endpointUri).getScheme();
        if (scheme.equalsIgnoreCase(SCHEME_SOAP_OVER_UDP)) {
            throw new UnsupportedOperationException("SOAP-over-UDP is currently not supported by the TransportBindingFactory");
        }
        if (scheme.equalsIgnoreCase(SCHEME_HTTP)) {
            return this.createHttpBinding(endpointUri, communicationLogContext);
        }
        if (scheme.equalsIgnoreCase(SCHEME_HTTPS)) {
            return this.createHttpBinding(endpointUri, communicationLogContext);
        }
        throw new UnsupportedOperationException(String.format("Unsupported transport binding requested: %s", scheme));
    }

    @Override
    public TransportBinding createHttpBinding(String endpointUri, @Nullable CommunicationLogContext communicationLogContext) throws UnsupportedOperationException {
        String scheme = URI.create(endpointUri).getScheme();
        if (scheme.toLowerCase().startsWith(SCHEME_HTTP)) {
            return this.clientTransportBindingFactory.create(this.client, endpointUri, this.marshalling, this.soapUtil, communicationLogContext);
        }
        throw new UnsupportedOperationException(String.format("Binding with scheme %s is currently not supported", scheme));
    }

    @Override
    public HttpClient createHttpClient() {
        return this.clientTransportBindingFactory.createHttpClient(this.client);
    }

    public org.apache.http.client.HttpClient getClient() {
        return this.client;
    }
}

