/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.http.apache.CommunicationLogEntity;
import org.somda.sdc.dpws.http.apache.helper.ApacheClientHelper;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.TransportInfo;

public class CommunicationLogHttpResponseInterceptor
implements HttpResponseInterceptor {
    private static final Logger LOG = LogManager.getLogger(CommunicationLogHttpResponseInterceptor.class);
    private final CommunicationLog commlog;
    private final Logger instanceLogger;

    CommunicationLogHttpResponseInterceptor(CommunicationLog communicationLog, String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.commlog = communicationLog;
    }

    public void process(HttpResponse response, HttpContext context) {
        this.instanceLogger.debug("Processing response");
        HttpHost target = (HttpHost)context.getAttribute("http.target_host");
        CommunicationLogContext communicationLogContext = (CommunicationLogContext)context.getAttribute("SDCri_Communication_Log_Context");
        HttpEntity oldMessageEntity = response.getEntity();
        Optional<Object> currentTransactionOpt = Optional.of(context.getAttribute(CommunicationLog.MessageType.REQUEST.name()));
        String currentTransactionId = (String)currentTransactionOpt.orElse("");
        HttpApplicationInfo requestHttpApplicationInfo = new HttpApplicationInfo(ApacheClientHelper.allHeadersToMultimap(response.getAllHeaders()), currentTransactionId, null);
        ArrayList<X509Certificate> x509certificates = new ArrayList<X509Certificate>();
        ManagedHttpClientConnection routedConnection = null;
        try {
            routedConnection = (ManagedHttpClientConnection)context.getAttribute("http.connection");
        }
        catch (ClassCastException e) {
            LOG.error("Error retrieving managed http client connection: {}", (Object)e.getMessage(), (Object)e);
        }
        if (routedConnection != null && routedConnection.isOpen()) {
            SSLSession sslSession = routedConnection.getSSLSession();
            try {
                if (sslSession != null && sslSession.getPeerCertificates() != null) {
                    x509certificates.addAll(Arrays.stream(sslSession.getPeerCertificates()).filter(certificate -> certificate instanceof X509Certificate).map(certificate -> (X509Certificate)certificate).toList());
                }
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.error("Error retrieving peer certificates: {} ", (Object)e.getMessage(), (Object)e);
            }
        }
        TransportInfo requestTransportInfo = new TransportInfo(target.getSchemeName(), null, null, target.getHostName(), target.getPort(), x509certificates);
        CommunicationContext requestCommContext = new CommunicationContext(requestHttpApplicationInfo, requestTransportInfo, communicationLogContext);
        OutputStream commlogStream = this.commlog.logMessage(CommunicationLog.Direction.INBOUND, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.RESPONSE, requestCommContext);
        response.setEntity((HttpEntity)new CommunicationLogEntity(oldMessageEntity, commlogStream));
        this.instanceLogger.debug("Processing response done");
    }
}

