/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.service;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.jvnet.jaxb.lang.CopyTo;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.JaxbCopyingKt;
import org.somda.sdc.dpws.model.LocalizedStringType;
import org.somda.sdc.dpws.model.ObjectFactory;
import org.somda.sdc.dpws.model.ThisDeviceType;
import org.somda.sdc.dpws.model.ThisModelType;
import org.somda.sdc.dpws.service.HostedService;
import org.somda.sdc.dpws.service.HostingService;
import org.somda.sdc.dpws.service.helper.MetadataSectionUtil;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryTargetService;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.Metadata;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.MetadataSection;

public class HostingServiceInterceptor
implements HostingService {
    private static final Logger LOG = LogManager.getLogger(HostingServiceInterceptor.class);
    private final WsDiscoveryTargetService targetService;
    private final WsAddressingUtil wsaUtil;
    private final MetadataSectionUtil metadataSectionUtil;
    private final List<HostedService> hostedServices;
    private final SoapUtil soapUtil;
    private final SoapFaultFactory soapFaultFactory;
    private final org.somda.sdc.dpws.soap.wsmetadataexchange.model.ObjectFactory mexFactory;
    private final ObjectFactory dpwsFactory;
    private final Logger instanceLogger;
    private ThisModelType thisModel;
    private ThisDeviceType thisDevice;

    @AssistedInject
    HostingServiceInterceptor(@Assisted WsDiscoveryTargetService targetService, SoapUtil soapUtil, SoapFaultFactory soapFaultFactory, org.somda.sdc.dpws.soap.wsmetadataexchange.model.ObjectFactory mexFactory, ObjectFactory dpwsFactory, WsAddressingUtil wsaUtil, MetadataSectionUtil metadataSectionUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.targetService = targetService;
        this.wsaUtil = wsaUtil;
        this.metadataSectionUtil = metadataSectionUtil;
        this.hostedServices = new ArrayList<HostedService>();
        this.soapUtil = soapUtil;
        this.soapFaultFactory = soapFaultFactory;
        this.mexFactory = mexFactory;
        this.dpwsFactory = dpwsFactory;
        this.thisModel = dpwsFactory.createThisModelType();
        LocalizedStringType manufacturer = dpwsFactory.createLocalizedStringType();
        manufacturer.setValue("Unknown Manufacturer");
        this.thisModel.getManufacturer().add(manufacturer);
        LocalizedStringType modelName = dpwsFactory.createLocalizedStringType();
        modelName.setValue("Unknown ModelName");
        this.thisModel.getModelName().add(modelName);
        this.thisDevice = dpwsFactory.createThisDeviceType();
        LocalizedStringType friendlyName = dpwsFactory.createLocalizedStringType();
        friendlyName.setValue("Unknown FriendlyName");
        this.thisDevice.getFriendlyName().add(friendlyName);
    }

    @Override
    public List<String> getXAddrs() {
        return this.targetService.getXAddrs();
    }

    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/09/transfer/Get", direction=Direction.REQUEST)
    void processGet(RequestResponseObject rrObj) throws SoapFaultException {
        if (!rrObj.getRequest().getOriginalEnvelope().getBody().getAny().isEmpty()) {
            throw new SoapFaultException(this.soapFaultFactory.createSenderFault(String.format("SOAP envelope body for action %s shall be empty", "http://schemas.xmlsoap.org/ws/2004/09/transfer/Get")), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
        }
        Metadata metadata = this.mexFactory.createMetadata();
        List metadataSection = metadata.getMetadataSection();
        metadataSection.add(this.createThisModel());
        metadataSection.add(this.createThisDevice());
        metadataSection.add(this.metadataSectionUtil.createRelationship(this.targetService.getEndpointReference(), this.targetService.getTypes(), this.hostedServices));
        metadata.setMetadataSection(metadataSection);
        rrObj.getResponse().getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType("http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse"));
        this.soapUtil.setBody(metadata, rrObj.getResponse());
    }

    private MetadataSection createThisModel() {
        MetadataSection metadataSection = this.mexFactory.createMetadataSection();
        metadataSection.setDialect("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/ThisModel");
        metadataSection.setAny((Object)this.dpwsFactory.createThisModel(this.getThisModel()));
        return metadataSection;
    }

    private MetadataSection createThisDevice() {
        MetadataSection metadataSection = this.mexFactory.createMetadataSection();
        metadataSection.setDialect("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/ThisDevice");
        metadataSection.setAny((Object)this.dpwsFactory.createThisDevice(this.getThisDevice()));
        return metadataSection;
    }

    @Override
    public String getEndpointReferenceAddress() {
        return this.targetService.getEndpointReference().getAddress().getValue();
    }

    @Override
    public ThisModelType getThisModel() {
        return (ThisModelType)JaxbCopyingKt.copyTyped((CopyTo)this.thisModel);
    }

    @Override
    public void setThisModel(ThisModelType thisModel) {
        this.thisModel = (ThisModelType)JaxbCopyingKt.copyTyped((CopyTo)thisModel);
        this.thisModel.setManufacturer(this.cutMaxFieldSize(thisModel.getManufacturer()));
        this.thisModel.setModelName(this.cutMaxFieldSize(thisModel.getModelName()));
        this.thisModel.setModelNumber(this.cutMaxFieldSize(thisModel.getModelNumber()));
        this.thisModel.setManufacturerUrl(this.cutMaxUriSize(thisModel.getManufacturerUrl()));
        this.thisModel.setPresentationUrl(this.cutMaxUriSize(thisModel.getPresentationUrl()));
        this.thisModel.setModelUrl(this.cutMaxUriSize(thisModel.getModelUrl()));
        this.targetService.setMetadataModified();
    }

    @Override
    public ThisDeviceType getThisDevice() {
        return (ThisDeviceType)JaxbCopyingKt.copyTyped((CopyTo)this.thisDevice);
    }

    @Override
    public void setThisDevice(ThisDeviceType thisDevice) {
        this.thisDevice = (ThisDeviceType)JaxbCopyingKt.copyTyped((CopyTo)thisDevice);
        this.thisDevice.setFriendlyName(this.cutMaxFieldSize(thisDevice.getFriendlyName()));
        this.thisDevice.setFirmwareVersion(this.cutMaxFieldSize(thisDevice.getFirmwareVersion()));
        this.thisDevice.setSerialNumber(this.cutMaxFieldSize(thisDevice.getSerialNumber()));
        this.targetService.setMetadataModified();
    }

    @Override
    public void addHostedService(HostedService hostedService) {
        this.hostedServices.add(hostedService);
        this.targetService.setMetadataModified();
    }

    @Override
    public List<HostedService> getHostedServices() {
        return new ArrayList<HostedService>(this.hostedServices);
    }

    public String toString() {
        Object str = this.getEndpointReferenceAddress();
        if (!this.getThisDevice().getFriendlyName().isEmpty()) {
            str = (String)str + " (" + ((LocalizedStringType)this.getThisDevice().getFriendlyName().get(0)).getValue() + ")";
        }
        return str;
    }

    private List<LocalizedStringType> cutMaxFieldSize(List<LocalizedStringType> texts) {
        ArrayList<LocalizedStringType> newList = new ArrayList<LocalizedStringType>(texts.size());
        for (LocalizedStringType text : texts) {
            LocalizedStringType localizedText = (LocalizedStringType)JaxbCopyingKt.copyTyped((CopyTo)text);
            localizedText.setValue(this.cutMaxFieldSize(text.getValue()));
            newList.add(localizedText);
        }
        return newList;
    }

    private String cutMaxFieldSize(@Nullable String text) {
        return this.cutSize(text, 256);
    }

    private String cutMaxUriSize(@Nullable String uri) {
        return this.cutSize(uri, 2048);
    }

    private String cutSize(@Nullable String text, int size) {
        if (text == null) {
            return null;
        }
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        if (textBytes.length >= size) {
            int maxLength = size - 1;
            String newText = new String(Arrays.copyOf(textBytes, maxLength), StandardCharsets.UTF_8);
            this.instanceLogger.warn("The following text was cut due to DPWS length violations (allowed: {} octets, actual: {} octets). '{}' is now '{}'", (Object)maxLength, (Object)textBytes.length, (Object)text, (Object)newText);
            return newText;
        }
        return text;
    }
}

