/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.Inject;
import java.util.Optional;
import org.somda.sdc.dpws.guice.DeviceSpecific;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapConstants;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorRegistry;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.interception.ServerDispatcher;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingConstants;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsaddressing.model.ProblemActionType;

public class RequestResponseServerImpl
implements RequestResponseServer {
    private final InterceptorRegistry interceptorRegistry;
    private final SoapFaultFactory soapFaultFactory;
    private final ObjectFactory wsaObjectFactory;
    private final WsAddressingUtil wsAddressingUtil;
    private final WsAddressingServerInterceptor wsaServerInterceptor;
    private final ServerDispatcher serverDispatcher;

    @Inject
    RequestResponseServerImpl(ServerDispatcher serverDispatcher, InterceptorRegistry interceptorRegistry, SoapFaultFactory soapFaultFactory, ObjectFactory wsaObjectFactory, WsAddressingUtil wsAddressingUtil, @DeviceSpecific WsAddressingServerInterceptor wsaServerInterceptor) {
        this.serverDispatcher = serverDispatcher;
        this.interceptorRegistry = interceptorRegistry;
        this.soapFaultFactory = soapFaultFactory;
        this.wsaObjectFactory = wsaObjectFactory;
        this.wsAddressingUtil = wsAddressingUtil;
        this.wsaServerInterceptor = wsaServerInterceptor;
        this.register(wsaServerInterceptor);
    }

    @Override
    public void register(Interceptor interceptor) {
        this.interceptorRegistry.addInterceptor(interceptor);
    }

    @Override
    public void receiveRequestResponse(SoapMessage request, SoapMessage response, CommunicationContext communicationContext) throws SoapFaultException {
        Optional<AttributedURIType> actionHeader = request.getWsAddressingHeader().getAction();
        if (actionHeader.isEmpty()) {
            throw new SoapFaultException(this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, WsAddressingConstants.MESSAGE_ADDRESSING_HEADER_REQUIRED, "A required header representing a Message Addressing Property is not present", this.wsaObjectFactory.createProblemHeaderQName(this.wsAddressingUtil.createAttributedQNameType(WsAddressingConstants.QNAME_ACTION))), request.getWsAddressingHeader().getMessageId().orElse(null));
        }
        String action = this.wsAddressingUtil.getAddressUriString(actionHeader.orElse(new AttributedURIType()));
        if (this.interceptorRegistry.getInterceptors(Direction.REQUEST, action).isEmpty() && this.interceptorRegistry.getInterceptors(Direction.ANY, action).isEmpty()) {
            ProblemActionType problemActionType = this.wsaObjectFactory.createProblemActionType();
            problemActionType.setAction(this.wsAddressingUtil.createAttributedURIType(action));
            throw new SoapFaultException(this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, WsAddressingConstants.ACTION_NOT_SUPPORTED, "The [action] cannot be processed at the receiver", this.wsaObjectFactory.createProblemAction(problemActionType)), request.getWsAddressingHeader().getMessageId().orElse(null));
        }
        RequestResponseObject rrObj = new RequestResponseObject(request, response, communicationContext);
        this.serverDispatcher.invokeDispatcher(Direction.REQUEST, this.interceptorRegistry, request, rrObj);
        rrObj = new RequestResponseObject(request, response, communicationContext);
        this.serverDispatcher.invokeDispatcher(Direction.RESPONSE, this.interceptorRegistry, response, rrObj);
    }
}

