/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.interception;

import com.google.inject.Inject;
import java.util.Optional;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.InterceptorCallbackType;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.interception.InterceptorProcessor;
import org.somda.sdc.dpws.soap.interception.InterceptorRegistry;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;

public class ClientDispatcher {
    private final InterceptorProcessor interceptorProcessor;

    @Inject
    ClientDispatcher(InterceptorProcessor interceptorProcessor) {
        this.interceptorProcessor = interceptorProcessor;
    }

    public void invokeDispatcher(Direction direction, InterceptorRegistry registry, SoapMessage soapMessage, InterceptorCallbackType interceptorCallbackObject) throws InterceptorException {
        Optional<AttributedURIType> action = soapMessage.getWsAddressingHeader().getAction();
        String actionUri = null;
        if (action.isPresent()) {
            actionUri = action.get().getValue();
        }
        this.interceptorProcessor.dispatch(direction, registry, actionUri, interceptorCallbackObject);
    }
}

