/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsdiscovery;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.somda.sdc.common.util.JaxbUtil;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryConstants;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryHeader;
import org.somda.sdc.dpws.soap.wsdiscovery.model.AppSequenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;

public class WsDiscoveryMapper {
    private final JaxbUtil jaxbUtil;
    private final ObjectFactory wsdFactory;

    @Inject
    WsDiscoveryMapper(JaxbUtil jaxbUtil, ObjectFactory wsdFactory) {
        this.jaxbUtil = jaxbUtil;
        this.wsdFactory = wsdFactory;
    }

    public void mapToJaxbSoapHeader(WsDiscoveryHeader src, List<Object> dest) {
        src.getAppSequence().ifPresent(appSequenceType -> dest.add(this.wsdFactory.createAppSequence(appSequenceType)));
    }

    public void mapFromJaxbSoapHeader(List<Object> src, WsDiscoveryHeader dest) {
        src.forEach(o -> {
            Optional appSeq = this.jaxbUtil.extractElement(o, WsDiscoveryConstants.APP_SEQUENCE);
            if (appSeq.isPresent() && dest.getAppSequence().isEmpty()) {
                dest.setAppSequence((AppSequenceType)appSeq.get());
            }
        });
    }
}

