/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.JaxbUtil;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.EventSourceDialectHandler;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.WsEventingConstants;
import org.somda.sdc.dpws.soap.wseventing.factory.SubscriptionManagerFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.SubscriptionRegistryFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.WsEventingFaultFactory;
import org.somda.sdc.dpws.soap.wseventing.helper.EventSourceUtil;
import org.somda.sdc.dpws.soap.wseventing.helper.SubscriptionRegistry;
import org.somda.sdc.dpws.soap.wseventing.model.FilterType;
import org.somda.sdc.dpws.soap.wseventing.model.GetStatus;
import org.somda.sdc.dpws.soap.wseventing.model.GetStatusResponse;
import org.somda.sdc.dpws.soap.wseventing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wseventing.model.Renew;
import org.somda.sdc.dpws.soap.wseventing.model.RenewResponse;
import org.somda.sdc.dpws.soap.wseventing.model.Subscribe;
import org.somda.sdc.dpws.soap.wseventing.model.SubscribeResponse;
import org.somda.sdc.dpws.soap.wseventing.model.Unsubscribe;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;

public class EventSourceInterceptorDispatcher
extends AbstractIdleService
implements Interceptor {
    private static final Logger LOG = LogManager.getLogger(EventSourceInterceptorDispatcher.class);
    private final SoapUtil soapUtil;
    private final WsEventingFaultFactory faultFactory;
    private final Map<String, SubscriptionRegistry> subscriptionRegistries;
    private final SubscriptionManagerFactory subscriptionManagerFactory;
    private final Map<String, EventSourceDialectHandler> eventSourceDialectHandlers;
    private final EventSourceUtil eventSourceUtil;
    private final JaxbUtil jaxbUtil;
    private final WsAddressingUtil wsaUtil;
    private final ObjectFactory wseFactory;
    private final Logger instanceLogger;

    @AssistedInject
    EventSourceInterceptorDispatcher(@Assisted Collection<EventSourceDialectHandler> eventSources, SoapUtil soapUtil, WsEventingFaultFactory faultFactory, EventSourceUtil eventSourceUtil, JaxbUtil jaxbUtil, WsAddressingUtil wsaUtil, ObjectFactory wseFactory, SubscriptionRegistryFactory subscriptionRegistryProvider, SubscriptionManagerFactory subscriptionManagerFactory, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.eventSourceDialectHandlers = eventSources.stream().collect(Collectors.toMap(EventSourceDialectHandler::getDialect, Function.identity()));
        this.eventSourceUtil = eventSourceUtil;
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.soapUtil = soapUtil;
        this.faultFactory = faultFactory;
        this.subscriptionRegistries = eventSources.stream().collect(Collectors.toMap(EventSourceDialectHandler::getDialect, subscriptionRegistryProvider::create));
        this.subscriptionManagerFactory = subscriptionManagerFactory;
        this.jaxbUtil = jaxbUtil;
        this.wsaUtil = wsaUtil;
        this.wseFactory = wseFactory;
    }

    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe", direction=Direction.REQUEST)
    void processSubscribe(RequestResponseObject rrObj) throws SoapFaultException {
        AttributedURIType requestMsgId = rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null);
        Supplier<SoapFaultException> soapFaultExceptionSupplier = () -> new SoapFaultException(this.eventSourceUtil.createInvalidMsg(rrObj, String.format("Subscribe request %s was not valid", requestMsgId)));
        Subscribe subscribe = this.soapUtil.getBody(rrObj.getRequest(), Subscribe.class).orElseThrow(soapFaultExceptionSupplier);
        String deliveryMode = Optional.ofNullable(subscribe.getDelivery().getMode()).orElse("http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push");
        if (!deliveryMode.equals("http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push")) {
            throw new SoapFaultException(this.faultFactory.createDeliveryModeRequestedUnavailable(), requestMsgId);
        }
        int deliveryEndpointCount = subscribe.getDelivery().getContent().size();
        if (deliveryEndpointCount != 1) {
            throw new SoapFaultException(this.eventSourceUtil.createInvalidMsg(rrObj, String.format("Expected exactly one delivery endpoint, found %s", deliveryEndpointCount)), requestMsgId);
        }
        EndpointReferenceType notifyTo = (EndpointReferenceType)this.jaxbUtil.extractElement(subscribe.getDelivery().getContent().get(0), WsEventingConstants.NOTIFY_TO, EndpointReferenceType.class).orElseThrow(soapFaultExceptionSupplier);
        this.wsaUtil.getAddressUri(notifyTo).orElseThrow(soapFaultExceptionSupplier);
        Duration grantedExpires = this.eventSourceUtil.grantExpires(subscribe.getExpires());
        TransportInfo transportInfo = rrObj.getCommunicationContext().getTransportInfo();
        EndpointReferenceType epr = this.eventSourceUtil.createSubscriptionManagerEprAndRegisterHttpHandler(transportInfo.getScheme(), transportInfo.getLocalAddress().orElseThrow(() -> new RuntimeException("Fatal error. Missing local address in transport information.")), transportInfo.getLocalPort().orElseThrow(() -> new RuntimeException("Fatal error. Missing local port in transport information.")), this);
        FilterType filterType = Optional.ofNullable(subscribe.getFilter()).orElseThrow(() -> new SoapFaultException(this.faultFactory.createEventSourceUnableToProcess("No filter given, but required."), requestMsgId));
        String filterDialect = Optional.ofNullable(filterType.getDialect()).orElse("http://www.w3.org/TR/1999/REC-xpath-19991116");
        EventSourceDialectHandler filterDialectHandler = this.eventSourceDialectHandlers.get(filterDialect);
        if (filterDialectHandler == null) {
            throw new SoapFaultException(this.faultFactory.createFilteringRequestedUnavailable(), requestMsgId);
        }
        SourceSubscriptionManager subMan = this.subscriptionManagerFactory.createSourceSubscriptionManager(epr, grantedExpires, notifyTo, subscribe.getEndTo(), epr.getAddress().getValue(), Collections.unmodifiableList(filterType.getContent()), filterDialect, this.soapUtil.determineRequestDistinguishedName(rrObj));
        filterDialectHandler.subscribe(subMan);
        subMan.startAsync().awaitRunning();
        this.subscriptionRegistries.get(filterDialect).addSubscription(subMan);
        SubscribeResponse subscribeResponse = this.wseFactory.createSubscribeResponse();
        subscribeResponse.setExpires(grantedExpires);
        subscribeResponse.setSubscriptionManager(subMan.getSubscriptionManagerEpr());
        this.soapUtil.setBody(subscribeResponse, rrObj.getResponse());
        this.soapUtil.setWsaAction(rrObj.getResponse(), "http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse");
        this.instanceLogger.info("Incoming subscribe request. Generated subscription id: {}. Notifications go to {}. Expiration in {} seconds", (Object)subMan.getSubscriptionId(), (Object)this.wsaUtil.getAddressUri(subMan.getNotifyTo()).orElse("<unknown>"), (Object)grantedExpires.getSeconds());
    }

    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew", direction=Direction.REQUEST)
    void processRenew(RequestResponseObject rrObj) throws SoapFaultException {
        Renew renew = this.eventSourceUtil.validateRequestBody(rrObj, Renew.class);
        Duration grantedExpires = this.eventSourceUtil.grantExpires(renew.getExpires());
        SourceSubscriptionManager subMan = this.eventSourceUtil.validateSubscriptionEpr(rrObj, this.getAllSubscriptions());
        subMan.renew(grantedExpires);
        RenewResponse renewResponse = this.wseFactory.createRenewResponse();
        renewResponse.setExpires(grantedExpires);
        this.soapUtil.setBody(renewResponse, rrObj.getResponse());
        this.soapUtil.setWsaAction(rrObj.getResponse(), "http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse");
        this.instanceLogger.info("Subscription {} is renewed. New expiration in {} seconds", (Object)subMan.getSubscriptionId(), (Object)grantedExpires.getSeconds());
    }

    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus", direction=Direction.REQUEST)
    void processGetStatus(RequestResponseObject rrObj) throws SoapFaultException {
        this.eventSourceUtil.validateRequestBody(rrObj, GetStatus.class);
        SourceSubscriptionManager subMan = this.eventSourceUtil.validateSubscriptionEpr(rrObj, this.getAllSubscriptions());
        Duration expires = Duration.between(Instant.now(), subMan.getExpiresTimeout());
        if (expires.isNegative() || expires.isZero()) {
            throw new SoapFaultException(this.eventSourceUtil.createInvalidMsg(rrObj, String.format("Subscription %s expired", subMan.getSubscriptionId())), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
        }
        GetStatusResponse getStatusResponse = this.wseFactory.createGetStatusResponse();
        getStatusResponse.setExpires(expires);
        this.soapUtil.setBody(getStatusResponse, rrObj.getResponse());
        this.soapUtil.setWsaAction(rrObj.getResponse(), "http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse");
    }

    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe", direction=Direction.REQUEST)
    void processUnsubscribe(RequestResponseObject rrObj) throws SoapFaultException {
        this.eventSourceUtil.validateRequestBody(rrObj, Unsubscribe.class);
        SourceSubscriptionManager subMan = this.eventSourceUtil.validateSubscriptionEpr(rrObj, this.getAllSubscriptions());
        subMan.stopAsync().awaitTerminated();
        this.eventSourceDialectHandlers.values().forEach(handler -> handler.unsubscribe(subMan));
        this.soapUtil.setWsaAction(rrObj.getResponse(), "http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse");
        this.instanceLogger.info("Unsubscribe {}. Invalidate subscription manager", (Object)subMan.getSubscriptionId());
    }

    public Map<String, SubscriptionManager> getActiveSubscriptions() {
        return this.getAllSubscriptions().values().stream().map(it -> it).collect(Collectors.toMap(SubscriptionManager::getSubscriptionId, Function.identity()));
    }

    protected void startUp() {
        this.eventSourceDialectHandlers.values().forEach(it -> it.init(this.subscriptionRegistries.get(it.getDialect())));
    }

    protected void shutDown() {
        this.getAllSubscriptions().values().forEach(subMan -> subMan.offerEndTo(WsEventingStatus.STATUS_SOURCE_SHUTTING_DOWN));
    }

    private Map<String, SourceSubscriptionManager> getAllSubscriptions() {
        return this.subscriptionRegistries.values().stream().flatMap(it -> it.getSubscriptions().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

