/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.wsdl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.http.ContentType;
import org.somda.sdc.dpws.http.HttpClient;
import org.somda.sdc.dpws.http.HttpResponse;
import org.somda.sdc.dpws.http.factory.HttpClientFactory;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ReferenceParametersType;
import org.somda.sdc.dpws.soap.wsmetadataexchange.GetMetadataClient;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.Metadata;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.MetadataSection;
import org.somda.sdc.dpws.soap.wstransfer.TransferGetClient;
import org.somda.sdc.dpws.wsdl.WsdlMarshalling;
import org.somda.sdc.dpws.wsdl.model.TDefinitions;

public class WsdlRetriever {
    private static final Logger LOG = LogManager.getLogger();
    private final Logger instanceLogger;
    private final TransportBindingFactory transportBindingFactory;
    private final RequestResponseClientFactory requestResponseClientFactory;
    private final GetMetadataClient getMetadataClient;
    private final TransferGetClient transferGetClient;
    private final HttpClientFactory httpClientFactory;
    private final Duration maxWait;
    private final WsdlMarshalling wsdlMarshalling;

    @Inject
    WsdlRetriever(TransportBindingFactory transportBindingFactory, RequestResponseClientFactory requestResponseClientFactory, GetMetadataClient getMetadataClient, TransferGetClient transferGetClient, HttpClientFactory httpClientFactory, WsdlMarshalling wsdlMarshalling, @Named(value="Dpws.MaxWaitForFutures") Duration maxWait, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.transportBindingFactory = transportBindingFactory;
        this.requestResponseClientFactory = requestResponseClientFactory;
        this.getMetadataClient = getMetadataClient;
        this.transferGetClient = transferGetClient;
        this.httpClientFactory = httpClientFactory;
        this.wsdlMarshalling = wsdlMarshalling;
        this.maxWait = maxWait;
    }

    public Map<String, List<String>> retrieveWsdls(HostingServiceProxy hostingServiceProxy) throws IOException, TransportException {
        this.instanceLogger.debug("Retrieving WSDLs for {}", (Object)hostingServiceProxy.getActiveXAddr());
        HashMap<String, List<String>> wsdlMap = new HashMap<String, List<String>>();
        Map<String, HostedServiceProxy> hostedServices = hostingServiceProxy.getHostedServices();
        for (Map.Entry<String, HostedServiceProxy> entry : hostedServices.entrySet()) {
            SoapMessage metadataResponse;
            String serviceName = entry.getKey();
            HostedServiceProxy hostedServiceProxy = entry.getValue();
            ListenableFuture<SoapMessage> metadataResponseFuture = null;
            LOG.debug("Retrieving WSDL for service {}", (Object)serviceName);
            try {
                metadataResponseFuture = this.getMetadataClient.sendGetMetadata(hostedServiceProxy.getRequestResponseClient());
                metadataResponse = (SoapMessage)metadataResponseFuture.get(this.maxWait.toSeconds(), TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException("Could not retrieve Metadata from device for service " + serviceName);
            }
            catch (TimeoutException e) {
                metadataResponseFuture.cancel(true);
                throw new IOException(String.format("Could not retrieve Metadata from device for service %s after %ss", serviceName, this.maxWait.toSeconds()));
            }
            List bodyElements = metadataResponse.getOriginalEnvelope().getBody().getAny();
            Metadata getMetadataResponse = (Metadata)bodyElements.get(0);
            try {
                List<String> wsdl = this.retrieveWsdlFromMetadata(getMetadataResponse);
                wsdlMap.put(serviceName, wsdl);
            }
            catch (IOException | TransportException e) {
                LOG.error("Could not retrieve WSDL for service {}", (Object)serviceName);
                LOG.trace("Could not retrieve WSDL for service {}", (Object)serviceName, (Object)e);
                throw e;
            }
        }
        return wsdlMap;
    }

    public List<String> retrieveWsdlFromMetadata(Metadata metadata) throws TransportException, IOException {
        List<MetadataSection> wsdlSections = metadata.getMetadataSection().stream().filter(section -> "http://schemas.xmlsoap.org/wsdl/".equals(section.getDialect())).toList();
        if (wsdlSections.isEmpty()) {
            throw new IOException("Metadata for service did not contain any wsdl references");
        }
        ArrayList<String> collectedWsdls = new ArrayList<String>();
        for (MetadataSection wsdlSection : wsdlSections) {
            boolean hasAny;
            String location = wsdlSection.getLocation();
            EndpointReferenceType reference = wsdlSection.getMetadataReference();
            Object any = wsdlSection.getAny();
            boolean hasLocation = location != null;
            boolean hasReference = reference != null;
            boolean bl = hasAny = any != null;
            if (!BooleanUtils.xor((boolean[])new boolean[]{hasLocation, hasReference, hasAny})) {
                throw new IOException("Metadata for service has too many possible wsdl locations. It had DialectSpecificElement: " + hasAny + " MetadataReference: " + hasReference + " Location: " + hasLocation + ". Only one is allowed.");
            }
            if (hasLocation) {
                LOG.debug("WSDL is stored at location {}", (Object)location);
                collectedWsdls.add(this.retrieveWsdlFromLocation(location));
                continue;
            }
            if (hasReference) {
                LOG.debug("WSDL stored as MetadataReference {}", (Object)reference);
                collectedWsdls.addAll(this.retrieveWsdlFromMetadataReference(reference));
                continue;
            }
            if (hasAny) {
                LOG.debug("WSDL is stored in metadata response");
                collectedWsdls.add(this.retrieveWsdlFromAny(any));
                continue;
            }
            throw new IOException("Unexpected error while trying to retrieve WSDL: No match for any method.");
        }
        return collectedWsdls;
    }

    private String retrieveWsdlFromAny(Object any) throws IOException {
        try {
            JAXBElement definition = (JAXBElement)any;
            return this.retrieveEmbeddedWsdlFromMetadata((TDefinitions)definition.getValue());
        }
        catch (ClassCastException e) {
            LOG.error("Any node in metadata was not of instance JAXBElement<TDefinitions>, was {} instead, cannot handle it", (Object)any.getClass().getSimpleName());
            throw new IOException("Any node in metadata was not of instance JAXBElement<TDefinitions>, cannot handle it");
        }
    }

    private String retrieveWsdlFromLocation(String location) throws TransportException {
        HttpClient client = this.httpClientFactory.createHttpClient();
        HttpResponse response = client.sendGet(location);
        if (response.getStatusCode() >= 300) {
            throw new TransportException("Unexpected HTTP status code. Was " + response.getStatusCode());
        }
        return this.convertResponseToString(response);
    }

    String convertResponseToString(HttpResponse response) {
        Charset charset = null;
        Optional<ContentType> contentTypeOpt = ContentType.fromListMultimap(response.getHeader());
        if (contentTypeOpt.isPresent() && contentTypeOpt.get().getCharset() != null) {
            charset = contentTypeOpt.get().getCharset();
        }
        if (charset == null) {
            try {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(new ByteArrayInputStream(response.getBody()));
                String encoding = xmlStreamReader.getCharacterEncodingScheme();
                if (encoding != null) {
                    charset = Charset.forName(encoding);
                }
            }
            catch (UnsupportedCharsetException | XMLStreamException e) {
                LOG.warn("Could not determine XML encoding scheme");
                LOG.trace("Could not determine XML encoding scheme", (Throwable)e);
            }
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return new String(response.getBody(), charset);
    }

    private List<String> retrieveWsdlFromMetadataReference(EndpointReferenceType reference) throws TransportException, IOException {
        SoapMessage getResponse;
        String address = reference.getAddress().getValue();
        ReferenceParametersType referenceParameters = reference.getReferenceParameters();
        TransportBinding transportBinding = this.transportBindingFactory.createTransportBinding(address, null);
        RequestResponseClient rrClient = this.requestResponseClientFactory.createRequestResponseClient(transportBinding);
        ListenableFuture<SoapMessage> getResponseFuture = null;
        try {
            getResponseFuture = referenceParameters != null ? this.transferGetClient.sendTransferGet(rrClient, address, referenceParameters) : this.transferGetClient.sendTransferGet(rrClient, address);
            getResponse = (SoapMessage)getResponseFuture.get(this.maxWait.toSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            this.instanceLogger.error("Could not retrieve Metadata from device. Message: {}", (Object)e.getMessage());
            this.instanceLogger.trace("Could not retrieve Metadata from device", (Throwable)e);
            throw new TransportException("Could not retrieve Metadata from device", e);
        }
        catch (TimeoutException e) {
            getResponseFuture.cancel(true);
            this.instanceLogger.error("Could not retrieve Metadata from device after {}s. Message: {}", (Object)this.maxWait.toSeconds(), (Object)e.getMessage());
            this.instanceLogger.trace("Could not retrieve Metadata from device after {}s", (Object)this.maxWait.toSeconds(), (Object)e);
            throw new TransportException(String.format("Could not retrieve Metadata from device after %ss", this.maxWait.toSeconds()), e);
        }
        List bodyElements = getResponse.getOriginalEnvelope().getBody().getAny();
        Metadata getMetadataResponse = (Metadata)bodyElements.get(0);
        return this.retrieveWsdlFromMetadata(getMetadataResponse);
    }

    private String retrieveEmbeddedWsdlFromMetadata(TDefinitions wsdlNode) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.wsdlMarshalling.marshal(wsdlNode, output);
        }
        catch (JAXBException e) {
            this.instanceLogger.error("Error while marshalling embedded wsdl. Message: {}", (Object)(e.getLinkedException() != null ? e.getLinkedException().getMessage() : e.toString()));
            this.instanceLogger.error("Error while marshalling embedded wsdl", (Throwable)e);
            throw new IOException("Error while marshalling embedded wsdl", e);
        }
        return output.toString(StandardCharsets.UTF_8);
    }
}

