/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.services.helper;

import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.biceps.common.MdibEntity;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.common.event.AlertStateModificationMessage;
import org.somda.sdc.biceps.common.event.ComponentStateModificationMessage;
import org.somda.sdc.biceps.common.event.ContextStateModificationMessage;
import org.somda.sdc.biceps.common.event.DescriptionModificationMessage;
import org.somda.sdc.biceps.common.event.MetricStateModificationMessage;
import org.somda.sdc.biceps.common.event.OperationStateModificationMessage;
import org.somda.sdc.biceps.common.event.WaveformStateModificationMessage;
import org.somda.sdc.biceps.model.message.AbstractReport;
import org.somda.sdc.biceps.model.message.AbstractReportPart;
import org.somda.sdc.biceps.model.message.DescriptionModificationReport;
import org.somda.sdc.biceps.model.message.DescriptionModificationType;
import org.somda.sdc.biceps.model.message.EpisodicAlertReport;
import org.somda.sdc.biceps.model.message.EpisodicComponentReport;
import org.somda.sdc.biceps.model.message.EpisodicContextReport;
import org.somda.sdc.biceps.model.message.EpisodicMetricReport;
import org.somda.sdc.biceps.model.message.EpisodicOperationalStateReport;
import org.somda.sdc.biceps.model.message.ObjectFactory;
import org.somda.sdc.biceps.model.message.WaveformStream;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.biceps.model.participant.RealTimeSampleArrayMetricState;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.device.EventSourceAccess;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.glue.common.MdibVersionUtil;
import org.somda.sdc.glue.common.ReportMappings;

public class ReportGenerator
implements MdibAccessObserver {
    private static final Logger LOG = LogManager.getLogger(ReportGenerator.class);
    private static final String REFLECTION_ERROR_STRING = "Reflection error caught. Sending of notification aborted.";
    private final EventSourceAccess eventSourceAccess;
    private final ObjectFactory bicepsMessageFactory;
    private final ReportMappings reportMappings;
    private final MdibVersionUtil mdibVersionUtil;
    private final Logger instanceLogger;

    @AssistedInject
    ReportGenerator(@Assisted EventSourceAccess eventSourceAccess, ObjectFactory bicepsMessageFactory, ReportMappings reportMappings, MdibVersionUtil mdibVersionUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.eventSourceAccess = eventSourceAccess;
        this.bicepsMessageFactory = bicepsMessageFactory;
        this.reportMappings = reportMappings;
        this.mdibVersionUtil = mdibVersionUtil;
    }

    public <T extends AbstractState> void sendPeriodicStateReport(Map<String, List<T>> states, MdibVersion mdibVersion) {
        if (states.isEmpty()) {
            return;
        }
        Class<? extends AbstractReport> reportClass = this.reportMappings.getPeriodicReportClass(((AbstractState)states.values().stream().findFirst().orElseThrow().get(0)).getClass());
        this.sendStateChange(mdibVersion, states, reportClass);
    }

    @Subscribe
    void onAlertChange(AlertStateModificationMessage modificationMessage) {
        this.sendStateChange(modificationMessage.getMdibAccess().getMdibVersion(), modificationMessage.getStates(), EpisodicAlertReport.class);
    }

    @Subscribe
    void onComponentChange(ComponentStateModificationMessage modificationMessage) {
        this.sendStateChange(modificationMessage.getMdibAccess().getMdibVersion(), modificationMessage.getStates(), EpisodicComponentReport.class);
    }

    @Subscribe
    void onContextChange(ContextStateModificationMessage modificationMessage) {
        this.sendStateChange(modificationMessage.getMdibAccess().getMdibVersion(), modificationMessage.getStates(), EpisodicContextReport.class);
    }

    @Subscribe
    void onMetricChange(MetricStateModificationMessage modificationMessage) {
        this.sendStateChange(modificationMessage.getMdibAccess().getMdibVersion(), modificationMessage.getStates(), EpisodicMetricReport.class);
    }

    @Subscribe
    void onOperationChange(OperationStateModificationMessage modificationMessage) {
        this.sendStateChange(modificationMessage.getMdibAccess().getMdibVersion(), modificationMessage.getStates(), EpisodicOperationalStateReport.class);
    }

    @Subscribe
    void onDescriptionChange(DescriptionModificationMessage modificationMessage) {
        DescriptionModificationReport report = this.bicepsMessageFactory.createDescriptionModificationReport();
        this.appendReport(report, DescriptionModificationType.DEL, modificationMessage.getDeletedEntities());
        this.appendReport(report, DescriptionModificationType.CRT, modificationMessage.getInsertedEntities());
        this.appendReport(report, DescriptionModificationType.UPT, modificationMessage.getUpdatedEntities());
        try {
            this.mdibVersionUtil.setMdibVersion(modificationMessage.getMdibAccess().getMdibVersion(), (AbstractReport)report);
            this.eventSourceAccess.sendNotification("http://standards.ieee.org/downloads/11073/11073-20701-2018/DescriptionEventService/DescriptionModificationReport", (Object)report);
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn("Could not marshal message for description modification report with version {}: {}", (Object)modificationMessage.getMdibAccess().getMdibVersion(), (Object)e.getMessage());
            this.instanceLogger.trace("Could not marshal message for description modification report", (Throwable)e);
        }
        catch (TransportException e) {
            this.instanceLogger.info("Failed to deliver notification for description modification report with version {}: {}", (Object)modificationMessage.getMdibAccess().getMdibVersion(), (Object)e.getMessage());
            this.instanceLogger.trace("Failed to deliver notification for description modification report", (Throwable)e);
        }
    }

    @Subscribe
    void onWaveformChange(WaveformStateModificationMessage modificationMessage) {
        this.sendWaveformChange(modificationMessage.getMdibAccess().getMdibVersion(), modificationMessage.getStates());
    }

    private void collectStates(Map<Class<? extends AbstractReport>, Map<String, List<AbstractState>>> classifiedStates, List<MdibEntity> entities) {
        for (MdibEntity entity : entities) {
            Map stateMap = classifiedStates.computeIfAbsent(this.reportMappings.getEpisodicReportClass(entity.getStateClass()), s -> new HashMap());
            stateMap.computeIfAbsent(entity.getParentMds(), s -> new ArrayList()).addAll(entity.getStates());
        }
    }

    private void appendReport(DescriptionModificationReport report, DescriptionModificationType modType, List<MdibEntity> entities) {
        for (MdibEntity entity : entities) {
            DescriptionModificationReport.ReportPart reportPart = this.bicepsMessageFactory.createDescriptionModificationReportReportPart();
            reportPart.getDescriptor().add(entity.getDescriptor());
            if (modType != DescriptionModificationType.DEL) {
                reportPart.getState().addAll(entity.getStates());
            }
            reportPart.setParentDescriptor((String)entity.getParent().orElse(null));
            reportPart.setModificationType(modType);
            report.getReportPart().add(reportPart);
        }
    }

    private void sendWaveformChange(MdibVersion mdibVersion, Map<String, List<RealTimeSampleArrayMetricState>> states) {
        if (states.isEmpty()) {
            return;
        }
        List flatStates = states.values().stream().flatMap(it -> it.stream()).collect(Collectors.toList());
        try {
            WaveformStream waveformStream = new WaveformStream();
            this.mdibVersionUtil.setMdibVersion(mdibVersion, (AbstractReport)waveformStream);
            waveformStream.setState(flatStates);
            this.eventSourceAccess.sendNotification("http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream", (Object)waveformStream);
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn("Could not marshal message for state action {} with version: {}. {}", (Object)"http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream", (Object)mdibVersion, (Object)e.getMessage());
            this.instanceLogger.trace("Could not marshal message for state action {}", (Object)"http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream", (Object)e);
        }
        catch (TransportException e) {
            this.instanceLogger.info("Failed to deliver notification for state action {} with version: {}. {}", (Object)"http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream", (Object)mdibVersion, (Object)e.getMessage());
            this.instanceLogger.trace("Failed to deliver notification for state action {}", (Object)"http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream", (Object)e);
        }
    }

    private <T, V extends AbstractReport> void sendStateChange(MdibVersion mdibVersion, Map<String, List<T>> states, Class<V> reportClass) {
        AbstractReport report;
        if (states.isEmpty()) {
            return;
        }
        try {
            Constructor<V> reportCtor = reportClass.getConstructor(new Class[0]);
            report = (AbstractReport)reportCtor.newInstance(new Object[0]);
            this.mdibVersionUtil.setMdibVersion(mdibVersion, report);
            Object reportParts = this.findGetReportPartMethod(reportClass).invoke((Object)report, new Object[0]);
            if (!List.class.isAssignableFrom(reportParts.getClass())) {
                throw new NoSuchMethodException(String.format("Returned report parts was not a list, it was of type %s", reportParts.getClass()));
            }
            for (Map.Entry<String, List<T>> entry : states.entrySet()) {
                Class<?> reportPartClass = this.findReportPartClass(reportClass);
                Constructor<?> reportPartCtor = reportPartClass.getConstructor(new Class[0]);
                AbstractReportPart reportPart = (AbstractReportPart)reportPartCtor.newInstance(new Object[0]);
                this.findSetStateMethod(reportPartClass).invoke((Object)reportPart, entry.getValue());
                reportPart.setSourceMds(entry.getKey());
                ((List)reportParts).add(reportPart);
            }
        }
        catch (ReflectiveOperationException e) {
            this.instanceLogger.warn(REFLECTION_ERROR_STRING, (Throwable)e);
            return;
        }
        String action = this.reportMappings.getAction(reportClass);
        try {
            this.eventSourceAccess.sendNotification(action, (Object)report);
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn("Could not marshal message for state action {} with version: {}. {}", (Object)action, (Object)mdibVersion, (Object)e.getMessage());
            this.instanceLogger.trace("Could not marshal message for state action {}", (Object)action, (Object)e);
        }
        catch (TransportException e) {
            this.instanceLogger.info("Failed to deliver notification for state action {} with version: {}. {}", (Object)action, (Object)mdibVersion, (Object)e.getMessage());
            this.instanceLogger.trace("Failed to deliver notification for state action {}", (Object)action, (Object)e);
        }
    }

    private Class<?> findReportPartClass(Class<?> reportClass) throws NoSuchFieldException {
        Class<?>[] classes = reportClass.getClasses();
        return Arrays.stream(classes).filter(it -> it.getName().endsWith("$ReportPart")).findFirst().orElseThrow(() -> new NoSuchFieldException(String.format("ReportPart inner class not found in %s", reportClass.getName())));
    }

    private Method findGetReportPartMethod(Class<?> reportPartClass) throws NoSuchMethodException {
        return reportPartClass.getMethod("getReportPart", new Class[0]);
    }

    private Method findSetStateMethod(Class<?> reportPartClass) throws NoSuchMethodException {
        for (Method method : reportPartClass.getMethods()) {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1 || !List.class.isAssignableFrom(parameters[0])) continue;
            return method;
        }
        throw new NoSuchMethodException(String.format("No get-states function found on report part class %s", reportPartClass.getName()));
    }
}

