/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.collections;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.analyzer.commons.collections.AVLTree;
import org.sonarsource.analyzer.commons.collections.TreeIterator;

class MapEntriesIterable<K, V>
implements Iterable<Map.Entry<K, V>> {
    private final AVLTree<K, V> map;

    public MapEntriesIterable(AVLTree<K, V> map) {
        this.map = map;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> iterator() {
        return new MapEntriesIterator<K, V>(new TreeIterator<K, V>(this.map));
    }

    private static class MapEntriesIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final TreeIterator<K, V> treeIterator;

        public MapEntriesIterator(TreeIterator<K, V> treeIterator) {
            this.treeIterator = treeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.treeIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Object next = this.treeIterator.next();
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(((AVLTree)next).key(), ((AVLTree)next).value());
        }
    }
}

