/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.recognizers;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonarsource.analyzer.recognizers.Detector;

public class ContainsDetector
extends Detector {
    private final List<String> strs;

    public ContainsDetector(double probability, String ... strs) {
        super(probability);
        this.strs = Arrays.asList(strs);
    }

    @Override
    public int scan(String line) {
        String lineWithoutWhitespaces = StringUtils.deleteWhitespace((String)line);
        int matchers = 0;
        for (String str : this.strs) {
            matchers += StringUtils.countMatches((String)lineWithoutWhitespaces, (String)str);
        }
        return matchers;
    }
}

