/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.coverage;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public final class UtilityClass {
    private UtilityClass() {
    }

    public static void assertGoodPractice(Class<?> utilityClass) throws ReflectiveOperationException {
        if (!Modifier.isFinal(utilityClass.getModifiers())) {
            throw new IllegalStateException("Utility class " + utilityClass.getSimpleName() + " should be 'final'");
        }
        Constructor<?>[] constructors = utilityClass.getDeclaredConstructors();
        if (constructors.length != 1) {
            throw new IllegalStateException("Utility class " + utilityClass.getSimpleName() + " should only have one constructor.");
        }
        Constructor<?> constructor = constructors[0];
        if (!Modifier.isPrivate(constructor.getModifiers())) {
            throw new IllegalStateException(utilityClass.getSimpleName() + " constructor should be private.");
        }
        constructor.setAccessible(true);
        constructor.newInstance(new Object[0]);
    }
}

