/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.verifier.internal;

import java.nio.file.Path;

public interface IssueLocation {
    public Path getSourcePath();

    public Type getType();

    public static class Range
    extends Line {
        private final int column;
        private final int endLine;
        private final int endColumn;

        public Range(Path sourcePath, int line, int column, int endLine, int endColumn) {
            super(sourcePath, line);
            this.column = column;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        public int getColumn() {
            return this.column;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getEndColumn() {
            return this.endColumn;
        }

        @Override
        public Type getType() {
            return Type.RANGE;
        }
    }

    public static class Line
    extends File {
        private final int lineNumber;

        public Line(Path sourcePath, int lineNumber) {
            super(sourcePath);
            this.lineNumber = lineNumber;
        }

        public int getLine() {
            return this.lineNumber;
        }

        @Override
        public Type getType() {
            return Type.LINE;
        }
    }

    public static class File
    implements IssueLocation {
        private final Path sourcePath;

        public File(Path sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public Type getType() {
            return Type.FILE;
        }
    }

    public static enum Type {
        FILE,
        LINE,
        RANGE;

    }
}

