/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.checks.verifier.internal.Comment;
import org.sonarsource.analyzer.commons.checks.verifier.internal.FlowLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.LineIssues;
import org.sonarsource.analyzer.commons.checks.verifier.internal.NoncompliantCommentParser;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PreciseLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PreciseLocationParser;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PrimaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.Report;
import org.sonarsource.analyzer.commons.checks.verifier.internal.ReportDiff;
import org.sonarsource.analyzer.commons.checks.verifier.internal.SecondaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.TestFile;

public class FileIssues {
    private static final Pattern LINE_NUMBER = Pattern.compile("\n(\\d{3}):");
    public final TestFile testFile;
    private final Map<Integer, LineIssues> expectedIssueMap = new TreeMap<Integer, LineIssues>();
    private final Map<Integer, LineIssues> actualIssueMap = new TreeMap<Integer, LineIssues>();
    @Nullable
    private PrimaryLocation currentPrimary = null;
    private final List<SecondaryLocation> orphanSecondaryOrFlowLocations = new ArrayList<SecondaryLocation>();

    public FileIssues(TestFile testFile, List<Comment> comments) {
        this.testFile = testFile;
        for (Comment comment : comments) {
            LineIssues lineIssues = NoncompliantCommentParser.parse(testFile, comment.line, comment.content);
            if (lineIssues != null) {
                testFile.addNoncompliantComment(comment);
                LineIssues existingLineIssues = this.expectedIssueMap.get(lineIssues.line);
                if (existingLineIssues != null) {
                    existingLineIssues.merge(lineIssues);
                    continue;
                }
                this.expectedIssueMap.put(lineIssues.line, lineIssues);
                continue;
            }
            List<PreciseLocation> locations = PreciseLocationParser.parse(comment.line, comment.contentColumn, comment.content);
            if (locations.isEmpty()) continue;
            testFile.addNoncompliantComment(comment);
            locations.forEach(this::addLocation);
        }
    }

    private void addLocation(PreciseLocation location) {
        if (location instanceof PrimaryLocation) {
            this.addPrimary((PrimaryLocation)location);
        } else {
            this.addSecondary((SecondaryLocation)location);
        }
    }

    private void addPrimary(PrimaryLocation primary) {
        LineIssues lineIssues = this.expectedIssueMap.get(primary.range.line);
        if (lineIssues == null) {
            throw new IllegalStateException("Primary location does not have a related issue at " + primary.range.toString());
        }
        if (lineIssues.primaryLocation != null) {
            throw new IllegalStateException("Primary location conflicts with another primary location at " + primary.range.toString());
        }
        this.orphanSecondaryOrFlowLocations.forEach(secondary -> FileIssues.addSecondaryTo(secondary, primary));
        this.orphanSecondaryOrFlowLocations.clear();
        lineIssues.primaryLocation = primary;
        this.currentPrimary = primary;
    }

    private void addSecondary(SecondaryLocation secondary) {
        if (secondary.primaryIsBefore) {
            if (this.currentPrimary == null) {
                throw new IllegalStateException("Secondary location '<' without previous primary location at " + secondary.range.toString());
            }
            FileIssues.addSecondaryTo(secondary, this.currentPrimary);
        } else {
            this.orphanSecondaryOrFlowLocations.add(secondary);
        }
    }

    private static void addSecondaryTo(SecondaryLocation secondary, PrimaryLocation primary) {
        if (secondary instanceof FlowLocation) {
            FlowLocation flow = (FlowLocation)secondary;
            for (int flowId = primary.flowLocations.size(); flowId <= flow.flowIndex; ++flowId) {
                primary.flowLocations.add(new ArrayList());
            }
            List<FlowLocation> flowList = primary.flowLocations.get(flow.flowIndex);
            for (int indexInTheFlow = flowList.size(); indexInTheFlow < flow.indexInTheFlow; ++indexInTheFlow) {
                flowList.add(null);
            }
            flowList.set(flow.indexInTheFlow - 1, flow);
        } else {
            primary.secondaryLocations.add(secondary);
        }
    }

    public void addActualIssue(int line, String message, @Nullable PrimaryLocation preciseLocation) {
        this.addActualIssue(line, message, preciseLocation, null);
    }

    public void addActualIssue(int line, String message, @Nullable PrimaryLocation preciseLocation, @Nullable Double effortToFix) {
        LineIssues lineIssues = this.actualIssueMap.computeIfAbsent(line, key -> LineIssues.at(this.testFile, line, preciseLocation));
        lineIssues.add(message, effortToFix);
    }

    public Report report() {
        if (!this.orphanSecondaryOrFlowLocations.isEmpty()) {
            SecondaryLocation orphanSecondary = this.orphanSecondaryOrFlowLocations.get(0);
            throw new IllegalStateException("Secondary location '>' without next primary location at " + orphanSecondary.range.toString());
        }
        Report report = new Report();
        report.setExpectedIssueCount(this.expectedIssueMap.values().stream().mapToInt(issues -> issues.messages.size()).sum());
        String testFileName = "<" + this.testFile.getName() + ">";
        report.appendExpected(testFileName + "\n" + this.expectedIssueMap.values().stream().map(LineIssues::validateExpected).map(LineIssues::toString).collect(Collectors.joining("\n")));
        report.setActualIssueCount(this.actualIssueMap.values().stream().mapToInt(issues -> issues.messages.size()).sum());
        report.appendActual(testFileName + "\n" + this.actualIssueMap.values().stream().map(lineIssues -> lineIssues.dropUntestedAttributes(this.expectedIssueMap.get(lineIssues.line))).map(LineIssues::toString).collect(Collectors.joining("\n")));
        int line = FileIssues.firstDiffLine(report.getExpected(), report.getActual());
        String diff = "[----------------------------------------------------------------------]\n[ '-' means expected but not raised, '+' means raised but not expected ]\n" + ReportDiff.diff(report.getExpected(), report.getActual()) + "[----------------------------------------------------------------------]\n";
        report.appendContext("In file (" + this.testFile.getName() + ":" + line + ")\n" + diff);
        return report;
    }

    private static int firstDiffLine(String expected, String actual) {
        int offset;
        for (offset = 0; offset < expected.length() && offset < actual.length() && expected.charAt(offset) == actual.charAt(offset); ++offset) {
        }
        int line = 1;
        Matcher matcher = LINE_NUMBER.matcher(expected);
        while (matcher.find() && matcher.start() <= offset) {
            line = Integer.parseInt(matcher.group(1));
        }
        return line;
    }
}

