/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PerLineLocationWriter;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PreciseLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PrimaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.SecondaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.TestFile;

public class LineIssues {
    public static final String COMMENT_PREFIX = "Noncompliant";
    private static final String EFFORT_TO_FIX = "effortToFix";
    public final TestFile testFile;
    public final int line;
    public final List<String> messages;
    public final Map<String, String> params;
    @Nullable
    public PrimaryLocation primaryLocation;

    public LineIssues(TestFile testFile, int line, String[] messages, Map<String, String> params, @Nullable PrimaryLocation primaryLocation) {
        this.testFile = testFile;
        this.line = line;
        this.messages = new ArrayList<String>(Arrays.asList(messages));
        this.params = params;
        this.primaryLocation = primaryLocation;
    }

    void merge(LineIssues other) {
        this.messages.addAll(other.messages);
        this.params.putAll(other.params);
        if (this.primaryLocation == null) {
            this.primaryLocation = other.primaryLocation;
        }
    }

    public static LineIssues at(TestFile testFile, int line, @Nullable PrimaryLocation primaryLocation) {
        return new LineIssues(testFile, line, new String[0], new HashMap<String, String>(), primaryLocation);
    }

    public void add(String message, @Nullable Double effortToFix) {
        if (!this.messages.isEmpty() && !Objects.equals(effortToFix, this.effortToFix())) {
            throw new IllegalStateException("At line " + this.line + " several issues with different 'effortToFix'.");
        }
        this.messages.add(message);
        if (effortToFix != null) {
            this.params.put(EFFORT_TO_FIX, effortToFix.toString());
        }
    }

    @Nullable
    public Double effortToFix() {
        String value = this.params.get(EFFORT_TO_FIX);
        return value == null ? null : Double.valueOf(value);
    }

    public LineIssues validateExpected() {
        if (this.primaryLocation != null) {
            int additionalCount = this.primaryLocation.secondaryAndFlowLocationCount();
            if (this.primaryLocation.expectedAdditionalCount == null && additionalCount > 0) {
                this.primaryLocation.expectedAdditionalCount = additionalCount;
            }
        }
        return this;
    }

    public LineIssues dropUntestedAttributes(@Nullable LineIssues other) {
        if (other == null) {
            return this;
        }
        if (other.messages.get(0) == null) {
            for (int i = 0; i < this.messages.size(); ++i) {
                this.messages.set(i, null);
            }
        }
        if (other.primaryLocation == null) {
            this.primaryLocation = null;
        } else if (this.primaryLocation != null) {
            if (other.primaryLocation.expectedAdditionalCount == null) {
                this.primaryLocation.expectedAdditionalCount = null;
            }
            LineIssues.dropUntestedAttributes(this.primaryLocation.secondaryLocations, other.primaryLocation.secondaryLocations);
        }
        if (other.effortToFix() == null) {
            this.params.remove(EFFORT_TO_FIX);
        }
        return this;
    }

    private static void dropUntestedAttributes(List<SecondaryLocation> thisSecondaryLocations, List<SecondaryLocation> otherSecondaryLocations) {
        boolean secondaryWithoutIndex;
        boolean bl = secondaryWithoutIndex = !otherSecondaryLocations.isEmpty() && otherSecondaryLocations.stream().allMatch(secondary -> secondary.index == null);
        if (secondaryWithoutIndex) {
            thisSecondaryLocations.forEach(secondary -> {
                secondary.index = null;
            });
        }
        for (int i = 0; i < otherSecondaryLocations.size(); ++i) {
            SecondaryLocation thisLocation;
            SecondaryLocation otherLocation = otherSecondaryLocations.get(i);
            SecondaryLocation secondaryLocation = thisLocation = i < thisSecondaryLocations.size() ? thisSecondaryLocations.get(i) : null;
            if (thisLocation == null || otherLocation.message != null) continue;
            thisLocation.message = null;
        }
    }

    public String toString() {
        boolean oneMessageIsMissing;
        if (this.messages.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        this.appendLineNumber(out, this.line);
        out.append(COMMENT_PREFIX);
        boolean bl = oneMessageIsMissing = this.messages.stream().filter(Objects::isNull).count() > 0L;
        if (oneMessageIsMissing && this.messages.size() > 1) {
            out.append(" ").append(this.messages.size());
        }
        this.messages.stream().filter(Objects::nonNull).sorted().forEach(message -> out.append(" {{").append((String)message).append("}}"));
        Double effort = this.effortToFix();
        if (effort != null) {
            DecimalFormat effortToFixFormat = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.ENGLISH));
            out.append(" [[effortToFix=").append(effortToFixFormat.format(effort)).append("]]");
        }
        out.append("\n");
        this.appendLocations(out);
        return out.toString();
    }

    private void appendLineNumber(StringBuilder out, int lineNumber) {
        out.append(this.testFile.linePrefix(lineNumber));
    }

    private void appendLocations(StringBuilder out) {
        if (this.primaryLocation != null) {
            ArrayList<PreciseLocation> locations = new ArrayList<PreciseLocation>();
            locations.add(this.primaryLocation);
            if (this.primaryLocation.expectedAdditionalCount != null) {
                locations.addAll(this.primaryLocation.secondaryLocations);
                this.primaryLocation.flowLocations.forEach(locations::addAll);
                locations.sort(Comparator.comparing(location -> location.range));
            }
            TreeMap<Integer, PerLineLocationWriter> writerPerLine = new TreeMap<Integer, PerLineLocationWriter>();
            for (PreciseLocation location2 : locations) {
                writerPerLine.computeIfAbsent(location2.range.line, key -> new PerLineLocationWriter(this.testFile.linePrefix((int)key), this.reportLineAt((int)key))).add(location2);
            }
            writerPerLine.values().forEach(writer -> writer.write(out, this.primaryLocation.range));
        } else {
            this.appendLineNumber(out, this.line);
            out.append(this.reportLineAt(this.line));
        }
        out.append("\n");
    }

    private String reportLineAt(int lineNumber) {
        if (lineNumber < 0 || lineNumber > this.testFile.getLines().length) {
            return "ERROR, no line " + lineNumber + " in " + this.testFile.getName();
        }
        if (lineNumber == 0) {
            return "<issue on file " + this.testFile.getName() + ">";
        }
        return this.testFile.lineWithoutNoncompliantComment(lineNumber);
    }
}

