/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ReportDiff {
    public static String diff(String expected, String actual) {
        StringBuilder out = new StringBuilder();
        List<DiffBlock> blocks = ReportDiff.diff(new LineBlock(expected), new LineBlock(actual));
        for (int i = 0; i < blocks.size(); ++i) {
            boolean isLastBlock = i == blocks.size() - 1;
            blocks.get(i).print(out, isLastBlock);
        }
        return out.toString();
    }

    private static List<DiffBlock> diff(LineBlock expected, LineBlock actual) {
        if (expected.lines.isEmpty() && actual.lines.isEmpty()) {
            return Collections.emptyList();
        }
        if (actual.lines.isEmpty()) {
            return Collections.singletonList(new DiffBlock(DiffType.DELETE, expected.lines));
        }
        if (expected.lines.isEmpty()) {
            return Collections.singletonList(new DiffBlock(DiffType.INSERT, actual.lines));
        }
        if (expected.lines.equals(actual.lines)) {
            return Collections.singletonList(new DiffBlock(DiffType.EQUAL, actual.lines));
        }
        CommonBlock commonBlock = ReportDiff.largestCommonBlock(expected, actual);
        if (commonBlock == null) {
            return Arrays.asList(new DiffBlock(DiffType.DELETE, expected.lines), new DiffBlock(DiffType.INSERT, actual.lines));
        }
        ArrayList<DiffBlock> result = new ArrayList<DiffBlock>();
        result.addAll(ReportDiff.diff(commonBlock.left.before(), commonBlock.right.before()));
        result.add(new DiffBlock(DiffType.EQUAL, commonBlock.lines()));
        result.addAll(ReportDiff.diff(commonBlock.left.after(), commonBlock.right.after()));
        return result;
    }

    @Nullable
    private static CommonBlock largestCommonBlock(LineBlock left, LineBlock right) {
        CommonBlock largestCommon = null;
        for (int startLeft = 0; startLeft < left.lines.size(); ++startLeft) {
            for (int startRight = 0; startRight < right.lines.size(); ++startRight) {
                CommonBlock common = ReportDiff.commonBlock(startLeft, left, startRight, right);
                if (largestCommon != null && (common == null || largestCommon.size() >= common.size())) continue;
                largestCommon = common;
            }
        }
        return largestCommon;
    }

    @Nullable
    private static CommonBlock commonBlock(int startLeft, LineBlock left, int startRight, LineBlock right) {
        int size = 0;
        while (startLeft + size < left.lines.size() && startRight + size < right.lines.size() && left.lines.get(startLeft + size).equals(right.lines.get(startRight + size))) {
            ++size;
        }
        if (size == 0) {
            return null;
        }
        return new CommonBlock(new SubLineBlock(left, startLeft, size), new SubLineBlock(right, startRight, size));
    }

    static class LineBlock {
        final List<String> lines;

        LineBlock(String text) {
            this.lines = Arrays.asList(text.split("\n"));
        }

        LineBlock(List<String> lines) {
            this.lines = lines;
        }
    }

    static class DiffBlock
    extends LineBlock {
        final DiffType type;

        DiffBlock(DiffType type, List<String> lines) {
            super(lines);
            this.type = type;
        }

        void print(StringBuilder out, boolean isLastBlock) {
            if (this.type == DiffType.EQUAL && !this.lines.isEmpty()) {
                String lastLine = (String)this.lines.get(this.lines.size() - 1);
                if (!isLastBlock && !lastLine.trim().isEmpty()) {
                    this.print(out, lastLine);
                }
            } else {
                this.lines.forEach(line -> this.print(out, (String)line));
            }
        }

        void print(StringBuilder out, String line) {
            out.append(this.type.prefix).append(line).append('\n');
        }
    }

    static enum DiffType {
        EQUAL("  "),
        INSERT("+ "),
        DELETE("- ");

        final String prefix;

        private DiffType(String prefix) {
            this.prefix = prefix;
        }
    }

    static class CommonBlock {
        private final SubLineBlock left;
        private final SubLineBlock right;

        CommonBlock(SubLineBlock left, SubLineBlock right) {
            this.left = left;
            this.right = right;
        }

        List<String> lines() {
            return this.left.block.lines.subList(this.left.start, this.left.start + this.left.size);
        }

        int size() {
            return this.left.size;
        }
    }

    static class SubLineBlock {
        final LineBlock block;
        final int start;
        final int size;

        SubLineBlock(LineBlock block, int start, int size) {
            this.block = block;
            this.start = start;
            this.size = size;
        }

        LineBlock before() {
            return new LineBlock(this.block.lines.subList(0, this.start));
        }

        LineBlock after() {
            return new LineBlock(this.block.lines.subList(this.start + this.size, this.block.lines.size()));
        }
    }
}

