/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileContent {
    private final Path path;
    private final String content;
    private String[] lines = null;

    public FileContent(Path path) {
        this(path, StandardCharsets.UTF_8);
    }

    public FileContent(Path path, Charset charset) {
        this(path, FileContent.read(path, charset));
    }

    public FileContent(Path path, String content) {
        this.path = path;
        this.content = content;
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public Path getPath() {
        return this.path;
    }

    public File getFile() {
        return this.path.toFile();
    }

    public String getContent() {
        return this.content;
    }

    public String[] getLines() {
        if (this.lines == null) {
            this.lines = this.content.split("\r?\n|\r", -1);
        }
        return this.lines;
    }

    private static String read(Path path, Charset charset) {
        try {
            return new String(Files.readAllBytes(path), charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read '" + String.valueOf(path) + "': " + e.getMessage(), e);
        }
    }
}

