/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.sonarsource.analyzer.commons.checks.verifier.FileContent;
import org.sonarsource.analyzer.commons.checks.verifier.MultiFileVerifier;
import org.sonarsource.analyzer.commons.checks.verifier.SingleFileVerifier;
import org.sonarsource.analyzer.commons.checks.verifier.internal.Comment;
import org.sonarsource.analyzer.commons.checks.verifier.internal.FileIssues;
import org.sonarsource.analyzer.commons.checks.verifier.internal.InternalIssue;
import org.sonarsource.analyzer.commons.checks.verifier.internal.IssueLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.PrimaryLocation;
import org.sonarsource.analyzer.commons.checks.verifier.internal.Report;
import org.sonarsource.analyzer.commons.checks.verifier.internal.TestFile;
import org.sonarsource.analyzer.commons.checks.verifier.internal.UnderlinedRange;

public class InternalIssueVerifier
implements MultiFileVerifier,
SingleFileVerifier {
    private final Path mainSourceFilePath;
    private Set<Path> filesToVerify = new LinkedHashSet<Path>();
    private Map<Path, List<Comment>> comments = new HashMap<Path, List<Comment>>();
    private Map<Path, List<InternalIssue>> actualIssues = new HashMap<Path, List<InternalIssue>>();
    private Charset encoding;
    private boolean verifyQuickFixes = true;

    public InternalIssueVerifier(Path mainSourceFilePath, Charset encoding) {
        this.mainSourceFilePath = mainSourceFilePath.toAbsolutePath();
        this.encoding = encoding;
        this.filesToVerify.add(this.mainSourceFilePath);
    }

    void addComments(List<Comment> commentList) {
        for (Comment comment : commentList) {
            this.filesToVerify.add(comment.path);
            this.comments.computeIfAbsent(comment.path, key -> new ArrayList()).add(comment);
        }
    }

    @Override
    public InternalIssueVerifier addComment(Path path, int line, int column, String content, int prefixLength, int suffixLength) {
        Path absolutePath = path.toAbsolutePath();
        this.filesToVerify.add(absolutePath);
        int contentColumn = column + prefixLength;
        String commentContent = content.substring(prefixLength, content.length() - suffixLength);
        this.comments.computeIfAbsent(absolutePath, key -> new ArrayList()).add(new Comment(absolutePath, line, column, contentColumn, commentContent));
        return this;
    }

    @Override
    public InternalIssueVerifier addComment(int line, int column, String content, int prefixLength, int suffixLength) {
        return this.addComment(this.mainSourceFilePath, line, column, content, prefixLength, suffixLength);
    }

    @Override
    public InternalIssueVerifier withoutQuickFixes() {
        this.verifyQuickFixes = false;
        return this;
    }

    @Override
    public InternalIssue reportIssue(Path path, String message) {
        Path absolutePath = path.toAbsolutePath();
        this.filesToVerify.add(absolutePath);
        InternalIssue issue = new InternalIssue(absolutePath, message);
        this.actualIssues.computeIfAbsent(absolutePath, key -> new ArrayList()).add(issue);
        return issue;
    }

    @Override
    public InternalIssue reportIssue(String message) {
        return this.reportIssue(this.mainSourceFilePath, message);
    }

    Report buildReport() {
        Report report = new Report();
        for (Path path : this.filesToVerify) {
            TestFile testFile = new TestFile(new FileContent(path, this.encoding));
            FileIssues fileIssues = new FileIssues(testFile, this.comments.computeIfAbsent(path, key -> Collections.emptyList()));
            InternalIssueVerifier.addActualIssues(fileIssues, this.actualIssues.computeIfAbsent(path, key -> Collections.emptyList()));
            report.append(fileIssues.report());
        }
        return report;
    }

    private static void addActualIssues(FileIssues fileIssues, List<InternalIssue> issues) {
        for (InternalIssue issue : issues) {
            int line;
            if (issue.location == null) {
                throw new IllegalStateException("Missing location, use 'onFile()', 'onLine(...)', 'onRange(...)'");
            }
            PrimaryLocation preciseLocation = null;
            switch (issue.location.getType()) {
                case FILE: {
                    line = 0;
                    break;
                }
                case LINE: {
                    line = ((IssueLocation.Line)issue.location).getLine();
                    break;
                }
                case RANGE: {
                    IssueLocation.Range range = (IssueLocation.Range)issue.location;
                    line = range.getLine();
                    preciseLocation = new PrimaryLocation(new UnderlinedRange(range.getLine(), range.getColumn(), range.getEndLine(), range.getEndColumn()), issue.secondaries.size());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported " + String.valueOf((Object)issue.location.getType()));
                }
            }
            if (preciseLocation != null) {
                for (InternalIssue.Secondary secondary : issue.secondaries) {
                    IssueLocation.Range range = secondary.range;
                    preciseLocation.addSecondary(new UnderlinedRange(range.getLine(), range.getColumn(), range.getEndLine(), range.getEndColumn()), secondary.message);
                }
            }
            fileIssues.addActualIssue(line, issue.message, preciseLocation, issue.gap, issue.quickFixes);
        }
    }

    @Override
    public void assertOneOrMoreIssues() {
        this.assertIssues(true);
    }

    @Override
    public void assertNoIssuesRaised() {
        Report report = this.buildReport();
        Assert.assertEquals((String)"ERROR: No issues were expected, but some were found.", (long)0L, (long)report.getActualIssueCount());
    }

    @Override
    public void assertNoIssues() {
        this.assertIssues(false);
    }

    private void assertIssues(boolean expectsIssues) {
        Report report = this.buildReport();
        Object error = null;
        if (!expectsIssues && report.getExpectedIssueCount() != 0) {
            error = "ERROR: 'assertNoIssues()' is called but there's some 'Noncompliant' comments.";
            report.prependExpected((String)error + "\n");
        } else if (expectsIssues && report.getExpectedIssueCount() == 0) {
            error = "ERROR: 'assertOneOrMoreIssues()' is called but there's no 'Noncompliant' comments.";
            report.prependExpected((String)error + "\n");
        } else if (!expectsIssues && report.getActualIssueCount() != 0) {
            error = "ERROR: Found " + report.getActualIssueCount() + " unexpected issues.";
            report.prependActual((String)error + "\n");
        } else if (expectsIssues && report.getActualIssueCount() == 0) {
            error = "ERROR: Expect some issues, but there's none.";
            report.prependActual((String)error + "\n");
        } else if (report.getExpectedIssueCount() != report.getActualIssueCount()) {
            error = "ERROR: Expect " + report.getExpectedIssueCount() + " issues instead of " + report.getActualIssueCount() + ".";
        } else if (this.verifyQuickFixes && report.getExpectedQuickfixCount() <= report.getActualQuickfixCount()) {
            error = "ERROR: Expect " + report.getExpectedQuickfixCount() + " quickfixes instead of " + report.getActualQuickfixCount() + ".";
        }
        if (error != null) {
            report.prependContext((String)error + " ");
        }
        Assert.assertEquals((String)report.getContext(), (Object)report.getExpected(), (Object)report.getActual());
        if (this.verifyQuickFixes && !report.getQuickfixContext().isEmpty()) {
            throw new AssertionError((Object)report.getQuickfixContext());
        }
    }
}

