/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.performance.measure.log;

import java.util.function.Function;
import java.util.function.Supplier;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonarsource.performance.measure.log.JavaLoggerBridge;
import org.sonarsource.performance.measure.log.SonarSourceLoggerBridge;

public abstract class Logger {
    public static final String DEFAULT_SONAR_API_LOGGER = "org.sonar.api.utils.log.Loggers";
    private static String sonarApiLogger = "org.sonar.api.utils.log.Loggers";
    public static final Function<Class<?>, Logger> DEFAULT_FACTORY = cls -> {
        try {
            Class.forName(sonarApiLogger);
            return new SonarSourceLoggerBridge((Class<?>)cls);
        }
        catch (ClassNotFoundException e) {
            return new JavaLoggerBridge((Class<?>)cls);
        }
    };
    private static Function<Class<?>, Logger> factory = DEFAULT_FACTORY;

    public abstract void debug(Supplier<String> var1);

    public abstract void info(Supplier<String> var1);

    public abstract void warning(Supplier<String> var1);

    public abstract void error(Supplier<String> var1);

    public static Logger get(Class<?> cls) {
        return factory.apply(cls);
    }

    @VisibleForTesting
    public static void overrideFactory(Function<Class<?>, Logger> factory, String sonarLoggerClass) {
        Logger.factory = factory;
        sonarApiLogger = sonarLoggerClass;
    }
}

