/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.performance.measure;

import javax.annotation.CheckForNull;
import org.sonarsource.performance.measure.DurationMeasure;

public class MeasurementCost {
    public static final String MEASUREMENT_COST_NAME = "#MeasurementCost_v1";
    public static final String SUBTRACTED_MEASUREMENT_COST_NAME = "#MeasurementCost_subtracted_v1";
    public final long createChild;
    public final long incrementChild;
    public final long nanoTime;
    public final long observationCost;

    public MeasurementCost(DurationMeasure measurementCost) {
        this.createChild = MeasurementCost.averageDuration(measurementCost, "createChild");
        this.incrementChild = MeasurementCost.averageDuration(measurementCost, "incrementChild");
        this.nanoTime = MeasurementCost.averageDuration(measurementCost, "nanoTime");
        this.observationCost = MeasurementCost.averageDuration(measurementCost, "observationCost");
    }

    @CheckForNull
    public static MeasurementCost observationCostOf(DurationMeasure measure) {
        DurationMeasure costMeasure = measure.get(MEASUREMENT_COST_NAME);
        if (costMeasure == null) {
            costMeasure = measure.get(SUBTRACTED_MEASUREMENT_COST_NAME);
        }
        return costMeasure != null ? new MeasurementCost(costMeasure) : null;
    }

    public static DurationMeasure subtractObservationCost(DurationMeasure measure) {
        DurationMeasure measureCopy = measure.copy();
        DurationMeasure measurementCostNode = measureCopy.remove(MEASUREMENT_COST_NAME);
        if (measurementCostNode != null) {
            MeasurementCost measurementCost = new MeasurementCost(measurementCostNode);
            measurementCost.recursiveSubtractObservationCost(measureCopy);
            measurementCostNode.rename(SUBTRACTED_MEASUREMENT_COST_NAME);
            measureCopy.addOrMerge(measurementCostNode);
        }
        return measureCopy;
    }

    static long averageDuration(DurationMeasure measurementCost, String name) {
        DurationMeasure measure = measurementCost.get(name);
        if (measure == null) {
            throw new IllegalStateException("Missing " + name);
        }
        return measure.calls() == 0L ? 0L : measure.durationNanos() / measure.calls();
    }

    ChildCounter recursiveSubtractObservationCost(DurationMeasure measure) {
        ChildCounter childCounter = ChildCounter.ZERO;
        for (DurationMeasure child : measure.children()) {
            childCounter = childCounter.add(this.recursiveSubtractObservationCost(child));
        }
        long cost = this.observationCost * measure.calls() + childCounter.cost(this);
        measure.subtractDuration(Math.min(cost, measure.durationNanos()));
        return childCounter.add(ChildCounter.of(measure));
    }

    static class ChildCounter {
        static final ChildCounter ZERO = new ChildCounter(0L, 0L);
        long createChildCount;
        long incrementChildCount;

        public ChildCounter(long createChildCount, long incrementChildCount) {
            this.createChildCount = createChildCount;
            this.incrementChildCount = incrementChildCount;
        }

        static ChildCounter of(DurationMeasure measure) {
            long count = measure.calls();
            if (count == 0L) {
                return ZERO;
            }
            return new ChildCounter(1L, count - 1L);
        }

        ChildCounter add(ChildCounter other) {
            return new ChildCounter(this.createChildCount + other.createChildCount, this.incrementChildCount + other.incrementChildCount);
        }

        long cost(MeasurementCost measurementCost) {
            return this.createChildCount * measurementCost.createChild + this.incrementChildCount * measurementCost.incrementChild;
        }
    }
}

