/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import org.sonarsource.analyzer.commons.regex.MatchType;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.FinalState;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.helpers.RegexTreeHelper;
import org.sonarsource.analyzer.commons.regex.helpers.SubAutomaton;

public class FailingLookaheadFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Remove or fix this lookahead assertion that can never be true.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private final FinalState finalState;
    private final MatchType matchType;

    public FailingLookaheadFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter, FinalState finalState) {
        this(regexElementIssueReporter, finalState, MatchType.NOT_SUPPORTED);
    }

    public FailingLookaheadFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter, FinalState finalState, MatchType matchType) {
        this.regexElementIssueReporter = regexElementIssueReporter;
        this.finalState = finalState;
        this.matchType = matchType;
    }

    @Override
    public void visitLookAround(LookAroundTree tree) {
        if (tree.getDirection() == LookAroundTree.Direction.AHEAD && this.doesLookaheadContinuationAlwaysFail(tree)) {
            this.regexElementIssueReporter.report(tree, MESSAGE, null, Collections.emptyList());
        }
        super.visitLookAround(tree);
    }

    private boolean doesLookaheadContinuationAlwaysFail(LookAroundTree lookAround) {
        RegexTree lookAroundElement = lookAround.getElement();
        SubAutomaton continuationSubAutomaton = new SubAutomaton(lookAround.continuation(), this.finalState, true);
        if (lookAround.getPolarity() == LookAroundTree.Polarity.NEGATIVE) {
            SubAutomaton lookAroundSubAutomaton = new SubAutomaton(lookAroundElement, lookAroundElement.continuation(), false);
            return RegexTreeHelper.supersetOf(lookAroundSubAutomaton, continuationSubAutomaton, false);
        }
        boolean canLookAroundBeAPrefix = this.matchType != MatchType.FULL;
        SubAutomaton lookAroundSubAutomaton = new SubAutomaton(lookAroundElement, lookAroundElement.continuation(), canLookAroundBeAPrefix);
        return !RegexTreeHelper.intersects(lookAroundSubAutomaton, continuationSubAutomaton, true);
    }
}

