/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.php;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.regex.CharacterParser;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public abstract class PhpStringCharacterParser
implements CharacterParser {
    final String sourceText;
    final int textLength;
    protected final RegexSource source;
    protected int index = 0;
    @Nullable
    private SourceCharacter current;

    private PhpStringCharacterParser(RegexSource source) {
        this.source = source;
        this.sourceText = source.getSourceText();
        this.textLength = this.sourceText.length();
        this.moveNext();
    }

    public static CharacterParser forSingleQuotedString(RegexSource source) {
        return new SingleQuotedStringCharacterParser(source);
    }

    public static CharacterParser forDoubleQuotedString(RegexSource source) {
        return new DoubleQuotedStringCharacterParser(source);
    }

    @Override
    public void resetTo(int index) {
        this.index = index;
        this.moveNext();
    }

    @Override
    public void moveNext() {
        if (this.index >= this.textLength) {
            this.current = null;
            return;
        }
        this.current = this.parsePhpCharacter();
    }

    @Override
    @Nonnull
    public SourceCharacter getCurrent() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    @Override
    public boolean isAtEnd() {
        return this.current == null;
    }

    @CheckForNull
    private SourceCharacter parsePhpCharacter() {
        char ch = this.sourceText.charAt(this.index);
        if (ch == '\\') {
            if (this.index + 1 >= this.textLength) {
                return this.createCharAndUpdateIndex('\\', 1);
            }
            return this.parsePhpEscapeSequence();
        }
        return this.createCharAndUpdateIndex(ch, 1);
    }

    abstract SourceCharacter parsePhpEscapeSequence();

    SourceCharacter createCharAndUpdateIndex(char ch, int length) {
        int startIndex = this.index;
        this.index += length;
        return new SourceCharacter(this.source, new IndexRange(startIndex, this.index), ch, length > 1);
    }

    private static class DoubleQuotedStringCharacterParser
    extends PhpStringCharacterParser {
        private static final Pattern UNICODE_PATTERN = Pattern.compile("\\Au\\{([0-9A-Fa-f]+)}");
        private static final Pattern HEX_PATTERN = Pattern.compile("\\Ax([0-9A-Fa-f]{1,2})");
        private static final Pattern OCTAL_PATTERN = Pattern.compile("\\A([0-7]{1,3})");

        private DoubleQuotedStringCharacterParser(RegexSource source) {
            super(source);
        }

        @Override
        SourceCharacter parsePhpEscapeSequence() {
            char charAfterBackslash = this.sourceText.charAt(this.index + 1);
            switch (charAfterBackslash) {
                case '\\': {
                    return this.createCharAndUpdateIndex('\\', 2);
                }
                case '\"': {
                    return this.createCharAndUpdateIndex('\"', 2);
                }
                case 'n': {
                    return this.createCharAndUpdateIndex('\n', 2);
                }
                case 'r': {
                    return this.createCharAndUpdateIndex('\r', 2);
                }
                case 't': {
                    return this.createCharAndUpdateIndex('\t', 2);
                }
                case 'f': {
                    return this.createCharAndUpdateIndex('\f', 2);
                }
                case 'e': {
                    return this.createCharAndUpdateIndex('\u001b', 2);
                }
                case 'v': {
                    return this.createCharAndUpdateIndex('\u000b', 2);
                }
                case '$': {
                    return this.createCharAndUpdateIndex('$', 2);
                }
                case 'u': {
                    Matcher unicodeMatcher = UNICODE_PATTERN.matcher(this.sourceText.substring(this.index + 1));
                    if (unicodeMatcher.find()) {
                        String hexValue = unicodeMatcher.group(1);
                        return this.createCharAndUpdateIndex((char)Integer.parseInt(hexValue, 16), hexValue.length() + 4);
                    }
                    return this.createCharAndUpdateIndex('\\', 1);
                }
                case 'x': {
                    Matcher hexMatcher = HEX_PATTERN.matcher(this.sourceText.substring(this.index + 1));
                    if (hexMatcher.find()) {
                        String hexValue = hexMatcher.group(1);
                        return this.createCharAndUpdateIndex((char)Integer.parseInt(hexValue, 16), hexValue.length() + 2);
                    }
                    return this.createCharAndUpdateIndex('\\', 1);
                }
            }
            Matcher octalMatcher = OCTAL_PATTERN.matcher(this.sourceText.substring(this.index + 1));
            if (octalMatcher.find()) {
                String octalValue = octalMatcher.group(1);
                return this.createCharAndUpdateIndex((char)Integer.parseInt(octalValue, 8), octalValue.length() + 1);
            }
            return this.createCharAndUpdateIndex('\\', 1);
        }
    }

    private static class SingleQuotedStringCharacterParser
    extends PhpStringCharacterParser {
        private SingleQuotedStringCharacterParser(RegexSource source) {
            super(source);
        }

        @Override
        SourceCharacter parsePhpEscapeSequence() {
            char charAfterBackslash = this.sourceText.charAt(this.index + 1);
            if (charAfterBackslash == '\'') {
                return this.createCharAndUpdateIndex('\'', 2);
            }
            if (charAfterBackslash == '\\') {
                return this.createCharAndUpdateIndex('\\', 2);
            }
            return this.createCharAndUpdateIndex('\\', 1);
        }
    }
}

