/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public class GraphemeHelper {
    private static final Pattern MARK_PATTERN = Pattern.compile("\\p{M}");

    private GraphemeHelper() {
    }

    public static List<RegexIssueLocation> getGraphemeInList(List<? extends RegexSyntaxElement> trees) {
        ArrayList<RegexIssueLocation> result = new ArrayList<RegexIssueLocation>();
        ArrayList<RegexSyntaxElement> codePoints = new ArrayList<RegexSyntaxElement>();
        for (RegexSyntaxElement regexSyntaxElement : trees) {
            CharacterTree currentCharacter;
            if (regexSyntaxElement instanceof CharacterTree && !(currentCharacter = (CharacterTree)regexSyntaxElement).isEscapeSequence()) {
                if (!GraphemeHelper.isMark(currentCharacter)) {
                    GraphemeHelper.addCurrentGrapheme(result, codePoints);
                    codePoints.clear();
                    codePoints.add(currentCharacter);
                    continue;
                }
                if (codePoints.isEmpty()) continue;
                codePoints.add(currentCharacter);
                continue;
            }
            GraphemeHelper.addCurrentGrapheme(result, codePoints);
            codePoints.clear();
        }
        GraphemeHelper.addCurrentGrapheme(result, codePoints);
        return result;
    }

    private static boolean isMark(CharacterTree currentChar) {
        return MARK_PATTERN.matcher(currentChar.characterAsString()).matches();
    }

    private static void addCurrentGrapheme(List<RegexIssueLocation> result, List<RegexSyntaxElement> codePoints) {
        if (codePoints.size() > 1) {
            result.add(new RegexIssueLocation(codePoints, ""));
        }
    }
}

