/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AbstractRegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;

public class CharacterClassUnionTree
extends AbstractRegexSyntaxElement
implements CharacterClassElementTree {
    private final List<CharacterClassElementTree> characterClasses;
    private final FlagSet activeFlags;

    public CharacterClassUnionTree(RegexSource source, IndexRange range, List<CharacterClassElementTree> characterClasses, FlagSet activeFlags) {
        super(source, range);
        this.characterClasses = Collections.unmodifiableList(characterClasses);
        this.activeFlags = activeFlags;
    }

    public List<CharacterClassElementTree> getCharacterClasses() {
        return this.characterClasses;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitCharacterClassUnion(this);
    }

    @Override
    @Nonnull
    public CharacterClassElementTree.Kind characterClassElementKind() {
        return CharacterClassElementTree.Kind.UNION;
    }

    @Override
    @Nonnull
    public FlagSet activeFlags() {
        return this.activeFlags;
    }
}

