/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class EmptyAlternativeFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Remove this empty alternative.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private final Deque<RegexTree> hierarchyStack = new LinkedList<RegexTree>();

    public EmptyAlternativeFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitGroup(GroupTree tree) {
        this.hierarchyStack.addLast(tree);
        super.visitGroup(tree);
        this.hierarchyStack.removeLast();
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        this.hierarchyStack.addLast(tree);
        super.visitRepetition(tree);
        this.hierarchyStack.removeLast();
    }

    @Override
    public void visitDisjunction(DisjunctionTree tree) {
        List<RegexTree> alternatives = tree.getAlternatives();
        int nAlternatives = alternatives.size();
        boolean firstIsEmpty = false;
        boolean lastIsEmpty = false;
        for (int i = 0; i < nAlternatives; ++i) {
            if (!EmptyAlternativeFinder.isEmptyAlternative(alternatives.get(i))) continue;
            firstIsEmpty |= i == 0;
            lastIsEmpty |= i == nAlternatives - 1;
            if (this.parentIsGroup() && !this.parentIsQuantified() && (0 >= i || i >= nAlternatives - 1)) continue;
            SourceCharacter orOperator = tree.getOrOperators().get(i < nAlternatives - 1 ? i : i - 1);
            this.regexElementIssueReporter.report(orOperator, MESSAGE, null, Collections.emptyList());
        }
        if (this.parentIsGroup() && firstIsEmpty && lastIsEmpty) {
            this.regexElementIssueReporter.report(tree.getOrOperators().get(0), MESSAGE, null, Collections.emptyList());
        }
        super.visitDisjunction(tree);
    }

    private boolean parentIsGroup() {
        return this.hierarchyStack.peekLast() instanceof GroupTree;
    }

    private boolean parentIsQuantified() {
        RegexTree lastElement = this.hierarchyStack.pollLast();
        boolean parentIsQuantified = this.hierarchyStack.peekLast() instanceof RepetitionTree;
        this.hierarchyStack.addLast(lastElement);
        return parentIsQuantified;
    }

    private static boolean isEmptyAlternative(RegexTree alternative) {
        return alternative.is(RegexTree.Kind.SEQUENCE) && ((SequenceTree)alternative).getItems().isEmpty();
    }
}

