/*
 * SonarSource Analyzers Regex Parsing Commons
 * Copyright (C) 2009-2025 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonarsource.analyzer.commons.regex.ast;

import javax.annotation.Nonnull;

public class EndOfLookaroundState extends ActiveFlagsState {

  private final LookAroundTree parent;

  public EndOfLookaroundState(LookAroundTree parent, FlagSet activeFlags) {
    super(activeFlags);
    this.parent = parent;
  }

  @Nonnull
  @Override
  public AutomatonState continuation() {
    return parent.continuation();
  }

  @Nonnull
  @Override
  public TransitionType incomingTransitionType() {
    if (parent.getDirection() == LookAroundTree.Direction.BEHIND) {
      return TransitionType.EPSILON;
    } else {
      return TransitionType.LOOKAROUND_BACKTRACKING;
    }
  }
}
