/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.xml;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

class XmlFilePosition {
    private final String content;
    private final int line;
    private final int column;
    private final int characterOffset;
    private static Map<State, Map<Character, State>> statesMap = new EnumMap<State, Map<Character, State>>(State.class);

    XmlFilePosition(String content) {
        this(content, 1, 1, 0);
    }

    XmlFilePosition(String content, Location location) {
        this(content, location.getLineNumber(), location.getColumnNumber(), location.getCharacterOffset());
    }

    private XmlFilePosition(String content, int line, int column, int characterOffset) {
        this.content = content;
        this.line = line;
        this.column = column;
        this.characterOffset = characterOffset;
    }

    XmlFilePosition shift(int nbChar) throws XMLStreamException {
        if (this.characterOffset + nbChar > this.content.length()) {
            throw new XMLStreamException("Cannot shift by " + nbChar + "characters");
        }
        XmlFilePosition res = this;
        for (int i = 0; i < nbChar; ++i) {
            res = res.shift(res.readChar());
        }
        return res;
    }

    XmlFilePosition moveBackward() throws XMLStreamException {
        if (this.column == 1) {
            throw new XMLStreamException("Cannot move backward from column 1");
        }
        return new XmlFilePosition(this.content, this.line, this.column - 1, this.characterOffset - 1);
    }

    char readChar() {
        return this.content.charAt(this.characterOffset);
    }

    private XmlFilePosition shift(char c) {
        int newOffset = this.characterOffset + 1;
        if (c == '\n' || c == '\r' && !this.isCRLF()) {
            return new XmlFilePosition(this.content, this.line + 1, 1, newOffset);
        }
        return new XmlFilePosition(this.content, this.line, this.column + 1, newOffset);
    }

    private boolean isCRLF() {
        return this.characterOffset + 1 <= this.content.length() && this.content.charAt(this.characterOffset + 1) == '\n';
    }

    boolean startsWith(String prefix) {
        return this.content.startsWith(prefix, this.characterOffset);
    }

    XmlFilePosition moveAfter(String substring) throws XMLStreamException {
        return this.moveBefore(substring).shift(substring.length());
    }

    XmlFilePosition moveAfterClosingBracket() throws XMLStreamException {
        State state = State.START;
        for (int i = this.characterOffset + 1; i < this.content.length(); ++i) {
            char currentChar = this.content.charAt(i);
            if ((state = statesMap.get((Object)state).getOrDefault(Character.valueOf(currentChar), state)) != State.FINISH) continue;
            return this.shift(i - this.characterOffset + 1);
        }
        throw new IllegalStateException("Failed to find closing bracket '>'.");
    }

    XmlFilePosition moveBefore(String substring) throws XMLStreamException {
        int index = this.content.indexOf(substring, this.characterOffset);
        if (index == -1) {
            throw new XMLStreamException("Cannot find " + substring + " in " + this.content.substring(this.characterOffset));
        }
        return this.shift(index - this.characterOffset);
    }

    String textUntil(XmlFilePosition endLocation) {
        return this.content.substring(this.characterOffset, endLocation.characterOffset);
    }

    XmlFilePosition moveAfterWhitespaces() throws XMLStreamException {
        XmlFilePosition res = this;
        while (Character.isWhitespace(res.readChar())) {
            res = res.shift(1);
        }
        return res;
    }

    boolean has(String substring, XmlFilePosition max) throws XMLStreamException {
        XmlFilePosition location = this;
        while (location.characterOffset < max.characterOffset) {
            if (location.startsWith(substring)) {
                return true;
            }
            location = location.shift(1);
        }
        return false;
    }

    int computeSqColumn(XmlFilePosition xmlStartLocation) {
        int columnOffset = this.line == xmlStartLocation.line || this.line == 1 ? xmlStartLocation.column - 1 : 0;
        return this.column + columnOffset - 1;
    }

    int computeSqLine(XmlFilePosition xmlStartLocation) {
        return this.line + xmlStartLocation.line - 1;
    }

    static {
        Arrays.stream(State.values()).forEach(s -> statesMap.put((State)((Object)s), new HashMap()));
        statesMap.get((Object)State.START).put(Character.valueOf('>'), State.FINISH);
        statesMap.get((Object)State.START).put(Character.valueOf('<'), State.INSIDE_NESTED_ELEMENT);
        statesMap.get((Object)State.START).put(Character.valueOf('\''), State.INSIDE_SINGLE_QUOTE);
        statesMap.get((Object)State.START).put(Character.valueOf('\"'), State.INSIDE_DOUBLE_QUOTE);
        statesMap.get((Object)State.INSIDE_NESTED_ELEMENT).put(Character.valueOf('>'), State.START);
        statesMap.get((Object)State.INSIDE_NESTED_ELEMENT).put(Character.valueOf('\''), State.INSIDE_SINGLE_QUOTE_NESTED_ELEMENT);
        statesMap.get((Object)State.INSIDE_NESTED_ELEMENT).put(Character.valueOf('\"'), State.INSIDE_DOUBLE_QUOTE_NESTED_ELEMENT);
        statesMap.get((Object)State.INSIDE_SINGLE_QUOTE).put(Character.valueOf('\''), State.START);
        statesMap.get((Object)State.INSIDE_DOUBLE_QUOTE).put(Character.valueOf('\"'), State.START);
        statesMap.get((Object)State.INSIDE_SINGLE_QUOTE_NESTED_ELEMENT).put(Character.valueOf('\''), State.INSIDE_NESTED_ELEMENT);
        statesMap.get((Object)State.INSIDE_DOUBLE_QUOTE_NESTED_ELEMENT).put(Character.valueOf('\"'), State.INSIDE_NESTED_ELEMENT);
    }

    private static enum State {
        FINISH,
        START,
        INSIDE_NESTED_ELEMENT,
        INSIDE_SINGLE_QUOTE,
        INSIDE_DOUBLE_QUOTE,
        INSIDE_SINGLE_QUOTE_NESTED_ELEMENT,
        INSIDE_DOUBLE_QUOTE_NESTED_ELEMENT;

    }
}

