/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.xml.checks;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SimpleXPathBasedCheck
extends SonarXmlCheck {
    private static final Logger LOG = Loggers.get(SimpleXPathBasedCheck.class);
    private final XPath xpath = XPathFactory.newInstance().newXPath();

    public XPathExpression getXPathExpression(String expression) {
        try {
            return this.xpath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(String.format("[%s] Fail to compile XPath expression '%s'.", this.ruleKey(), expression), e);
        }
    }

    @CheckForNull
    public NodeList evaluate(XPathExpression expression, Node node) {
        try {
            return (NodeList)expression.evaluate(node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error(String.format("[%s] Unable to evaluate XPath expression on file %s", this.ruleKey(), this.inputFile()), (Throwable)e);
            }
            return null;
        }
    }

    public List<Node> evaluateAsList(XPathExpression expression, Node node) {
        return XmlFile.asList(this.evaluate(expression, node));
    }
}

