/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.xml.checks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.SensorContextTester;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.analyzer.commons.checks.verifier.SingleFileVerifier;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public class SonarXmlCheckVerifier {
    private static final Path BASE_DIR = Paths.get("src/test/resources/checks/", new String[0]);
    private static final RuleKey RULE_KEY = RuleKey.of((String)"repoKey", (String)"ruleKey");
    private final Collection<Issue> issues;
    private final XmlFile file;

    private SonarXmlCheckVerifier(XmlFile file, Collection<Issue> issues) {
        this.file = file;
        this.issues = issues;
    }

    public static void verifyIssueOnFile(String relativePath, SonarXmlCheck check, String expectedIssueMessage, int ... secondaryLines) {
        SonarXmlCheckVerifier.createVerifier(relativePath, check).checkIssueOnFile(expectedIssueMessage, secondaryLines);
    }

    public static void verifyIssues(String relativePath, SonarXmlCheck check) {
        SonarXmlCheckVerifier.createVerifier(relativePath, check).checkIssues();
    }

    public static void verifyNoIssue(String relativePath, SonarXmlCheck check) {
        SonarXmlCheckVerifier.createVerifier(relativePath, check).checkNoIssues();
    }

    private static SonarXmlCheckVerifier createVerifier(String fileName, SonarXmlCheck check) {
        XmlFile xmlFile;
        String content;
        File file = new File(new File(BASE_DIR.toFile(), check.getClass().getSimpleName()), fileName);
        SensorContextTester context = SensorContextTester.create((Path)BASE_DIR);
        String filePath = file.getPath();
        try (Stream<String> lines = Files.lines(file.toPath());){
            content = lines.collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to load content of file %s", filePath), e);
        }
        DefaultInputFile defaultInputFile = TestInputFileBuilder.create((String)"", (String)filePath).setType(InputFile.Type.MAIN).initMetadata(content).setLanguage("xml").setCharset(StandardCharsets.UTF_8).build();
        context.fileSystem().add((InputFile)defaultInputFile);
        try {
            xmlFile = XmlFile.create((InputFile)defaultInputFile);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to scan xml file %s", filePath), e);
        }
        check.scanFile((SensorContext)context, RULE_KEY, xmlFile);
        return new SonarXmlCheckVerifier(xmlFile, context.allIssues());
    }

    private void checkIssues() {
        SingleFileVerifier fileVerifier = SingleFileVerifier.create((Path)this.file.getInputFile().path(), (Charset)StandardCharsets.UTF_8);
        SonarXmlCheckVerifier.addComments(fileVerifier, this.file.getDocument());
        this.issues.forEach(issue -> {
            IssueLocation loc = issue.primaryLocation();
            TextRange textRange = loc.textRange();
            SingleFileVerifier.Issue actualIssue = fileVerifier.reportIssue(loc.message()).onRange(textRange.start().line(), textRange.start().lineOffset() + 1, textRange.end().line(), textRange.end().lineOffset());
            issue.flows().forEach(flow -> {
                IssueLocation secondaryLocation = (IssueLocation)flow.locations().get(0);
                TextRange secondaryRange = secondaryLocation.textRange();
                actualIssue.addSecondary(secondaryRange.start().line(), secondaryRange.start().lineOffset() + 1, secondaryRange.end().line(), secondaryRange.end().lineOffset(), secondaryLocation.message());
            });
        });
        fileVerifier.assertOneOrMoreIssues();
    }

    private static void addComments(SingleFileVerifier fileVerifier, Node node) {
        if (node.getNodeType() == 8) {
            Comment comment = (Comment)node;
            XmlTextRange range = XmlFile.nodeLocation((Node)node);
            fileVerifier.addComment(range.getStartLine(), range.getStartColumn() + "<!--".length() + 1, comment.getNodeValue(), 0, 0);
        }
        XmlFile.children((Node)node).forEach(child -> SonarXmlCheckVerifier.addComments(fileVerifier, child));
    }

    private void checkIssueOnFile(String expectedIssueMessage, int ... secondaryLines) {
        SonarXmlCheckVerifier.reportProblem(this.issues.size() != 1, "Expected a single issue to be reported, but got %d.", this.issues.size());
        Issue issue = this.issues.iterator().next();
        String msg = issue.primaryLocation().message();
        SonarXmlCheckVerifier.reportProblem(!expectedIssueMessage.equals(msg), "Expected issue message to be \"%s\", but got \"%s\".", expectedIssueMessage, msg);
        TextRange textRange = issue.primaryLocation().textRange();
        SonarXmlCheckVerifier.reportProblem(textRange != null, "Expected issue location to be null, but issue is reported on line %d.", textRange == null ? -1 : textRange.start().line());
        List flows = issue.flows();
        SonarXmlCheckVerifier.reportProblem(flows.size() != secondaryLines.length, "Expected %d secondary locations, but got %d.", secondaryLines.length, flows.size());
        List expectedLines = IntStream.of(secondaryLines).boxed().collect(Collectors.toList());
        List reportedLines = flows.stream().map(Issue.Flow::locations).map(locs -> ((IssueLocation)locs.get(0)).textRange().start().line()).collect(Collectors.toList());
        SonarXmlCheckVerifier.reportProblem(!expectedLines.equals(reportedLines), "Expected secondary locations to be %s, but got %s.", expectedLines, reportedLines);
    }

    private void checkNoIssues() {
        SonarXmlCheckVerifier.reportProblem(!this.issues.isEmpty(), "Expected no issues, but got %d.", this.issues.size());
    }

    private static void reportProblem(boolean condition, String message, Object ... args) {
        if (condition) {
            throw new AssertionError((Object)String.format(message, args));
        }
    }
}

