/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.testfixtures.measure;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.measure.Measure;
import org.sonar.api.utils.Preconditions;

@Immutable
public class TestMeasure
implements Measure {
    private Integer intValue;
    private Long longValue;
    private Double doubleValue;
    private String stringValue;
    private Boolean booleanValue;

    public static TestMeasure createMeasure(double doubleValue) {
        TestMeasure measure = new TestMeasure();
        measure.doubleValue = doubleValue;
        return measure;
    }

    public static TestMeasure createMeasure(int intValue) {
        TestMeasure measure = new TestMeasure();
        measure.intValue = intValue;
        return measure;
    }

    public static TestMeasure createMeasure(long longValue) {
        TestMeasure measure = new TestMeasure();
        measure.longValue = longValue;
        return measure;
    }

    public static TestMeasure createMeasure(String stringValue) {
        TestMeasure measure = new TestMeasure();
        measure.stringValue = Objects.requireNonNull(stringValue, "Value cannot be null");
        return measure;
    }

    public static TestMeasure createMeasure(boolean booleanValue) {
        TestMeasure measure = new TestMeasure();
        measure.booleanValue = booleanValue;
        return measure;
    }

    public int getIntValue() {
        Preconditions.checkState((this.intValue != null ? 1 : 0) != 0, (String)"Not an integer measure");
        return this.intValue;
    }

    public long getLongValue() {
        Preconditions.checkState((this.longValue != null ? 1 : 0) != 0, (String)"Not a long measure");
        return this.longValue;
    }

    public double getDoubleValue() {
        Preconditions.checkState((this.doubleValue != null ? 1 : 0) != 0, (String)"Not a double measure");
        return this.doubleValue;
    }

    public String getStringValue() {
        Preconditions.checkState((this.stringValue != null ? 1 : 0) != 0, (String)"Not a string measure");
        return this.stringValue;
    }

    public boolean getBooleanValue() {
        Preconditions.checkState((this.booleanValue != null ? 1 : 0) != 0, (String)"Not a boolean measure");
        return this.booleanValue;
    }
}

