/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.testfixtures.posttask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ce.posttask.Analysis;
import org.sonar.api.ce.posttask.Branch;
import org.sonar.api.ce.posttask.CeTask;
import org.sonar.api.ce.posttask.Organization;
import org.sonar.api.ce.posttask.PostProjectAnalysisTask;
import org.sonar.api.ce.posttask.Project;
import org.sonar.api.ce.posttask.QualityGate;
import org.sonar.api.ce.posttask.ScannerContext;
import org.sonar.api.utils.Preconditions;

public class PostProjectAnalysisTaskTester {
    private static final String DATE_CAN_NOT_BE_NULL = "date cannot be null";
    private static final String PROJECT_CAN_NOT_BE_NULL = "project cannot be null";
    private static final String CE_TASK_CAN_NOT_BE_NULL = "ceTask cannot be null";
    private static final String STATUS_CAN_NOT_BE_NULL = "status cannot be null";
    private static final String SCANNER_CONTEXT_CAN_NOT_BE_NULL = "scannerContext cannot be null";
    private static final String KEY_CAN_NOT_BE_NULL = "key cannot be null";
    private static final String NAME_CAN_NOT_BE_NULL = "name cannot be null";
    private final PostProjectAnalysisTask underTest;
    @CheckForNull
    private CeTask ceTask;
    @CheckForNull
    private Project project;
    @CheckForNull
    private Date date;
    @CheckForNull
    private QualityGate qualityGate;
    @CheckForNull
    private Branch branch;
    private ScannerContext scannerContext;
    private String analysisUuid;
    @Nullable
    private String revision;
    @CheckForNull
    private Map<String, Object> stats;

    private PostProjectAnalysisTaskTester(PostProjectAnalysisTask underTest) {
        this.underTest = Objects.requireNonNull(underTest, "PostProjectAnalysisTask instance cannot be null");
    }

    public static PostProjectAnalysisTaskTester of(PostProjectAnalysisTask underTest) {
        return new PostProjectAnalysisTaskTester(underTest);
    }

    public static CeTaskBuilder newCeTaskBuilder() {
        return new CeTaskBuilder();
    }

    public static ProjectBuilder newProjectBuilder() {
        return new ProjectBuilder();
    }

    public static BranchBuilder newBranchBuilder() {
        return new BranchBuilder();
    }

    public static QualityGateBuilder newQualityGateBuilder() {
        return new QualityGateBuilder();
    }

    public static ConditionBuilder newConditionBuilder() {
        return new ConditionBuilder();
    }

    public static ScannerContextBuilder newScannerContextBuilder() {
        return new ScannerContextBuilder();
    }

    public PostProjectAnalysisTaskTester withCeTask(CeTask ceTask) {
        this.ceTask = Objects.requireNonNull(ceTask, CE_TASK_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester withProject(Project project) {
        this.project = Objects.requireNonNull(project, PROJECT_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester withScannerContext(ScannerContext scannerContext) {
        this.scannerContext = Objects.requireNonNull(scannerContext, SCANNER_CONTEXT_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester at(Date date) {
        this.date = Objects.requireNonNull(date, DATE_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester withQualityGate(@Nullable QualityGate qualityGate) {
        this.qualityGate = qualityGate;
        return this;
    }

    public PostProjectAnalysisTaskTester withBranch(@Nullable Branch b) {
        this.branch = b;
        return this;
    }

    public PostProjectAnalysisTaskTester withAnalysisUuid(@Nullable String analysisUuid) {
        this.analysisUuid = analysisUuid;
        return this;
    }

    public PostProjectAnalysisTaskTester withRevision(@Nullable String revision) {
        this.revision = revision;
        return this;
    }

    public PostProjectAnalysisTask.ProjectAnalysis execute() {
        Objects.requireNonNull(this.ceTask, CE_TASK_CAN_NOT_BE_NULL);
        Objects.requireNonNull(this.project, PROJECT_CAN_NOT_BE_NULL);
        Objects.requireNonNull(this.date, DATE_CAN_NOT_BE_NULL);
        Analysis analysis = null;
        if (this.analysisUuid != null) {
            analysis = new AnalysisBuilder().setDate(this.date).setAnalysisUuid(this.analysisUuid).setRevision(this.revision).build();
        }
        final PostProjectAnalysisTask.ProjectAnalysis projectAnalysis = new ProjectAnalysisBuilder().setCeTask(this.ceTask).setProject(this.project).setBranch(this.branch).setQualityGate(this.qualityGate).setAnalysis(analysis).setScannerContext(this.scannerContext).setDate(this.date).build();
        this.stats = new HashMap<String, Object>();
        final PostProjectAnalysisTask.LogStatistics logStatistics = new PostProjectAnalysisTask.LogStatistics(){

            public PostProjectAnalysisTask.LogStatistics add(String key, Object value) {
                Objects.requireNonNull(key, "Statistic has null key");
                Objects.requireNonNull(value, () -> String.format("Statistic with key [%s] has null value", key));
                Preconditions.checkArgument((!key.equalsIgnoreCase("time") ? 1 : 0) != 0, (String)"Statistic with key [time] is not accepted");
                Preconditions.checkArgument((!PostProjectAnalysisTaskTester.this.stats.containsKey(key) ? 1 : 0) != 0, (String)"Statistic with key [%s] is already present", (Object[])new Object[]{key});
                PostProjectAnalysisTaskTester.this.stats.put(key, value);
                return this;
            }
        };
        this.underTest.finished(new PostProjectAnalysisTask.Context(){

            public PostProjectAnalysisTask.ProjectAnalysis getProjectAnalysis() {
                return projectAnalysis;
            }

            public PostProjectAnalysisTask.LogStatistics getLogStatistics() {
                return logStatistics;
            }
        });
        return projectAnalysis;
    }

    public Map<String, Object> getLogStatistics() {
        Preconditions.checkState((this.stats != null ? 1 : 0) != 0, (String)"execute must be called first");
        return this.stats;
    }

    public static final class AnalysisBuilder {
        private String analysisUuid;
        private Date date;
        @Nullable
        private String revision;

        private AnalysisBuilder() {
        }

        public AnalysisBuilder setAnalysisUuid(String analysisUuid) {
            this.analysisUuid = analysisUuid;
            return this;
        }

        public AnalysisBuilder setDate(Date date) {
            this.date = date;
            return this;
        }

        public AnalysisBuilder setRevision(@Nullable String s) {
            this.revision = s;
            return this;
        }

        public Analysis build() {
            return new Analysis(){

                public String getAnalysisUuid() {
                    return analysisUuid;
                }

                public Date getDate() {
                    return date;
                }

                public Optional<String> getRevision() {
                    return Optional.ofNullable(revision);
                }
            };
        }
    }

    public static final class ProjectAnalysisBuilder {
        private CeTask ceTask;
        private Project project;
        private Branch branch;
        private QualityGate qualityGate;
        private Analysis analysis;
        private ScannerContext scannerContext;
        private Date date;

        private ProjectAnalysisBuilder() {
        }

        public ProjectAnalysisBuilder setCeTask(CeTask ceTask) {
            this.ceTask = ceTask;
            return this;
        }

        public ProjectAnalysisBuilder setProject(Project project) {
            this.project = project;
            return this;
        }

        public ProjectAnalysisBuilder setBranch(@Nullable Branch branch) {
            this.branch = branch;
            return this;
        }

        public ProjectAnalysisBuilder setQualityGate(QualityGate qualityGate) {
            this.qualityGate = qualityGate;
            return this;
        }

        public ProjectAnalysisBuilder setAnalysis(@Nullable Analysis analysis) {
            this.analysis = analysis;
            return this;
        }

        public ProjectAnalysisBuilder setScannerContext(ScannerContext scannerContext) {
            this.scannerContext = scannerContext;
            return this;
        }

        public ProjectAnalysisBuilder setDate(Date date) {
            this.date = date;
            return this;
        }

        public PostProjectAnalysisTask.ProjectAnalysis build() {
            return new PostProjectAnalysisTask.ProjectAnalysis(){

                public Optional<Organization> getOrganization() {
                    return Optional.empty();
                }

                public CeTask getCeTask() {
                    return ceTask;
                }

                public Project getProject() {
                    return project;
                }

                public Optional<Branch> getBranch() {
                    return Optional.ofNullable(branch);
                }

                @CheckForNull
                public QualityGate getQualityGate() {
                    return qualityGate;
                }

                public Optional<Analysis> getAnalysis() {
                    return Optional.ofNullable(analysis);
                }

                public ScannerContext getScannerContext() {
                    return scannerContext;
                }

                public String getScmRevisionId() {
                    return null;
                }

                public String toString() {
                    return "ProjectAnalysis{ceTask=" + String.valueOf(ceTask) + ", project=" + String.valueOf(project) + ", date=" + date.getTime() + ", analysisDate=" + date.getTime() + ", qualityGate=" + String.valueOf(qualityGate) + "}";
                }
            };
        }
    }

    public static final class ScannerContextBuilder {
        private final Map<String, String> properties = new HashMap<String, String>();

        private ScannerContextBuilder() {
        }

        public ScannerContextBuilder addProperties(Map<String, String> map) {
            this.properties.putAll(map);
            return this;
        }

        public ScannerContext build() {
            return () -> this.properties;
        }
    }

    public static final class ConditionBuilder {
        private static final String METRIC_KEY_CAN_NOT_BE_NULL = "metricKey cannot be null";
        private static final String OPERATOR_CAN_NOT_BE_NULL = "operator cannot be null";
        private static final String ERROR_THRESHOLD_CAN_NOT_BE_NULL = "errorThreshold cannot be null";
        private String metricKey;
        private QualityGate.Operator operator;
        private String errorThreshold;

        private ConditionBuilder() {
        }

        public ConditionBuilder setMetricKey(String metricKey) {
            this.metricKey = Objects.requireNonNull(metricKey, METRIC_KEY_CAN_NOT_BE_NULL);
            return this;
        }

        public ConditionBuilder setOperator(QualityGate.Operator operator) {
            this.operator = Objects.requireNonNull(operator, OPERATOR_CAN_NOT_BE_NULL);
            return this;
        }

        public ConditionBuilder setErrorThreshold(String errorThreshold) {
            this.errorThreshold = Objects.requireNonNull(errorThreshold, ERROR_THRESHOLD_CAN_NOT_BE_NULL);
            return this;
        }

        public QualityGate.Condition buildNoValue() {
            this.checkCommonProperties();
            return new QualityGate.Condition(){

                public QualityGate.EvaluationStatus getStatus() {
                    return QualityGate.EvaluationStatus.NO_VALUE;
                }

                public String getMetricKey() {
                    return metricKey;
                }

                public QualityGate.Operator getOperator() {
                    return operator;
                }

                public String getErrorThreshold() {
                    return errorThreshold;
                }

                public String getValue() {
                    throw new IllegalStateException("There is no value when status is NO_VALUE");
                }

                public String toString() {
                    return "Condition{status=" + String.valueOf(QualityGate.EvaluationStatus.NO_VALUE) + ", metricKey='" + metricKey + "', operator=" + String.valueOf(operator) + ", errorThreshold='" + errorThreshold + "'}";
                }
            };
        }

        public QualityGate.Condition build(final QualityGate.EvaluationStatus status, final String value) {
            this.checkCommonProperties();
            Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            Preconditions.checkArgument((status != QualityGate.EvaluationStatus.NO_VALUE ? 1 : 0) != 0, (String)"status cannot be NO_VALUE, use method buildNoValue() instead");
            Objects.requireNonNull(value, "value cannot be null, use method buildNoValue() instead");
            return new QualityGate.Condition(){

                public QualityGate.EvaluationStatus getStatus() {
                    return status;
                }

                public String getMetricKey() {
                    return metricKey;
                }

                public QualityGate.Operator getOperator() {
                    return operator;
                }

                public String getErrorThreshold() {
                    return errorThreshold;
                }

                public String getValue() {
                    return value;
                }

                public String toString() {
                    return "Condition{status=" + String.valueOf(status) + ", metricKey='" + metricKey + "', operator=" + String.valueOf(operator) + ", errorThreshold='" + errorThreshold + "', value='" + value + "'}";
                }
            };
        }

        private void checkCommonProperties() {
            Objects.requireNonNull(this.metricKey, METRIC_KEY_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.operator, OPERATOR_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.errorThreshold, ERROR_THRESHOLD_CAN_NOT_BE_NULL);
        }
    }

    public static final class QualityGateBuilder {
        private static final String ID_CAN_NOT_BE_NULL = "id cannot be null";
        private static final String NAME_CAN_NOT_BE_NULL = "name cannot be null";
        private String id;
        private String name;
        private QualityGate.Status status;
        private final List<QualityGate.Condition> conditions = new ArrayList<QualityGate.Condition>();

        private QualityGateBuilder() {
        }

        public QualityGateBuilder setId(String id) {
            this.id = Objects.requireNonNull(id, ID_CAN_NOT_BE_NULL);
            return this;
        }

        public QualityGateBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
            return this;
        }

        public QualityGateBuilder setStatus(QualityGate.Status status) {
            this.status = Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return this;
        }

        public QualityGateBuilder add(QualityGate.Condition condition) {
            this.conditions.add(Objects.requireNonNull(condition, "condition cannot be null"));
            return this;
        }

        public QualityGateBuilder clearConditions() {
            this.conditions.clear();
            return this;
        }

        public QualityGate build() {
            Objects.requireNonNull(this.id, ID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.name, "name cannot be null");
            Objects.requireNonNull(this.status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return new QualityGate(){

                public String getId() {
                    return id;
                }

                public String getName() {
                    return name;
                }

                public QualityGate.Status getStatus() {
                    return status;
                }

                public Collection<QualityGate.Condition> getConditions() {
                    return conditions;
                }

                public String toString() {
                    return "QualityGate{id='" + id + "', name='" + name + "', status=" + String.valueOf(status) + ", conditions=" + String.valueOf(conditions) + "}";
                }
            };
        }
    }

    public static final class BranchBuilder {
        private boolean isMain = true;
        private String name = null;
        private Branch.Type type = Branch.Type.BRANCH;

        private BranchBuilder() {
        }

        public BranchBuilder setName(@Nullable String s) {
            this.name = s;
            return this;
        }

        public BranchBuilder setType(Branch.Type t) {
            this.type = Objects.requireNonNull(t);
            return this;
        }

        public BranchBuilder setIsMain(boolean b) {
            this.isMain = b;
            return this;
        }

        public Branch build() {
            return new Branch(){

                public boolean isMain() {
                    return isMain;
                }

                public Optional<String> getName() {
                    return Optional.ofNullable(name);
                }

                public Branch.Type getType() {
                    return type;
                }
            };
        }
    }

    public static final class ProjectBuilder {
        private static final String UUID_CAN_NOT_BE_NULL = "uuid cannot be null";
        private String uuid;
        private String key;
        private String name;

        private ProjectBuilder() {
        }

        public ProjectBuilder setUuid(String uuid) {
            this.uuid = Objects.requireNonNull(uuid, UUID_CAN_NOT_BE_NULL);
            return this;
        }

        public ProjectBuilder setKey(String key) {
            this.key = Objects.requireNonNull(key, PostProjectAnalysisTaskTester.KEY_CAN_NOT_BE_NULL);
            return this;
        }

        public ProjectBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, PostProjectAnalysisTaskTester.NAME_CAN_NOT_BE_NULL);
            return this;
        }

        public Project build() {
            Objects.requireNonNull(this.uuid, UUID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.key, PostProjectAnalysisTaskTester.KEY_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.name, PostProjectAnalysisTaskTester.NAME_CAN_NOT_BE_NULL);
            return new Project(){

                public String getUuid() {
                    return uuid;
                }

                public String getKey() {
                    return key;
                }

                public String getName() {
                    return name;
                }

                public String toString() {
                    return "Project{uuid='" + uuid + "', key='" + key + "', name='" + name + "'}";
                }
            };
        }
    }

    public static final class CeTaskBuilder {
        private static final String ID_CAN_NOT_BE_NULL = "id cannot be null";
        @CheckForNull
        private String id;
        @CheckForNull
        private CeTask.Status status;

        private CeTaskBuilder() {
        }

        public CeTaskBuilder setId(String id) {
            this.id = Objects.requireNonNull(id, ID_CAN_NOT_BE_NULL);
            return this;
        }

        public CeTaskBuilder setStatus(CeTask.Status status) {
            this.status = Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return this;
        }

        public CeTask build() {
            Objects.requireNonNull(this.id, ID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return new CeTask(){

                public String getId() {
                    return id;
                }

                public CeTask.Status getStatus() {
                    return status;
                }

                public String toString() {
                    return "CeTask{id='" + id + "', status=" + String.valueOf(status) + "}";
                }
            };
        }
    }
}

